/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.barcodescannerplugin.barcodedetection;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import androidx.core.content.ContextCompat;
import com.salesforce.barcodescannerplugin.R;
import com.salesforce.barcodescannerplugin.camera.GraphicOverlay;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/salesforce/barcodescannerplugin/barcodedetection/BarcodeGraphicBase;", "Lcom/salesforce/barcodescannerplugin/camera/GraphicOverlay$Graphic;", "overlay", "Lcom/salesforce/barcodescannerplugin/camera/GraphicOverlay;", "(Lcom/salesforce/barcodescannerplugin/camera/GraphicOverlay;)V", "boxCornerRadius", "", "getBoxCornerRadius", "()F", "boxPaint", "Landroid/graphics/Paint;", "boxRect", "Landroid/graphics/RectF;", "getBoxRect", "()Landroid/graphics/RectF;", "eraserPaint", "scrimPaint", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getBarcodeReticleBox", "barcodescanner_release"})
public abstract class BarcodeGraphicBase
extends GraphicOverlay.Graphic {
    private final Paint boxPaint;
    private final Paint scrimPaint;
    private final Paint eraserPaint;
    private final float boxCornerRadius;
    @NotNull
    private final RectF boxRect;

    public final float getBoxCornerRadius() {
        return this.boxCornerRadius;
    }

    @NotNull
    public final RectF getBoxRect() {
        return this.boxRect;
    }

    @Override
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.drawRect(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight(), this.scrimPaint);
        this.eraserPaint.setStyle(Paint.Style.FILL);
        canvas.drawRoundRect(this.boxRect, this.boxCornerRadius, this.boxCornerRadius, this.eraserPaint);
        this.eraserPaint.setStyle(Paint.Style.STROKE);
        canvas.drawRoundRect(this.boxRect, this.boxCornerRadius, this.boxCornerRadius, this.eraserPaint);
        canvas.drawRoundRect(this.boxRect, this.boxCornerRadius, this.boxCornerRadius, this.boxPaint);
    }

    private final RectF getBarcodeReticleBox(GraphicOverlay overlay) {
        float overlayWidth = overlay.getWidth();
        float overlayHeight = overlay.getHeight();
        float boxWidth = overlayWidth * (float)80 / (float)100;
        float boxHeight = overlayHeight * (float)35 / (float)100;
        float cx = overlayWidth / (float)2;
        float cy = overlayHeight / (float)2;
        return new RectF(cx - boxWidth / (float)2, cy - boxHeight / (float)2, cx + boxWidth / (float)2, cy + boxHeight / (float)2);
    }

    public BarcodeGraphicBase(@NotNull GraphicOverlay overlay) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)((Object)overlay), (String)"overlay");
        super(overlay);
        Paint paint2 = new Paint();
        BarcodeGraphicBase barcodeGraphicBase = this;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint2;
        boolean bl3 = false;
        $this$apply.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.barcode_reticle_stroke));
        $this$apply.setStyle(Paint.Style.STROKE);
        $this$apply.setStrokeWidth((float)this.getContext().getResources().getDimensionPixelOffset(R.dimen.barcode_reticle_stroke_width));
        barcodeGraphicBase.boxPaint = paint = paint2;
        paint2 = new Paint();
        barcodeGraphicBase = this;
        bl = false;
        bl2 = false;
        $this$apply = paint2;
        boolean bl4 = false;
        $this$apply.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.barcode_reticle_background));
        barcodeGraphicBase.scrimPaint = paint = paint2;
        paint2 = new Paint();
        barcodeGraphicBase = this;
        bl = false;
        bl2 = false;
        $this$apply = paint2;
        boolean bl5 = false;
        $this$apply.setStrokeWidth(this.boxPaint.getStrokeWidth());
        $this$apply.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        barcodeGraphicBase.eraserPaint = paint = paint2;
        this.boxCornerRadius = this.getContext().getResources().getDimensionPixelOffset(R.dimen.barcode_reticle_corner_radius);
        this.boxRect = this.getBarcodeReticleBox(overlay);
    }
}

