/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.barcodescannerplugin.camera;

import android.content.Context;
import android.graphics.ImageFormat;
import android.hardware.Camera;
import android.util.Log;
import android.view.Display;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import com.google.android.gms.common.images.Size;
import com.google.firebase.ml.vision.common.FirebaseVisionImageMetadata;
import com.salesforce.barcodescannerplugin.Utils;
import com.salesforce.barcodescannerplugin.camera.CameraSizePair;
import com.salesforce.barcodescannerplugin.camera.CameraSource$sam$android_hardware_Camera_PreviewCallback$0;
import com.salesforce.barcodescannerplugin.camera.FrameMetadata;
import com.salesforce.barcodescannerplugin.camera.FrameProcessor;
import com.salesforce.barcodescannerplugin.camera.GraphicOverlay;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 .2\u00020\u0001:\u0002./B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001e\u001a\u00020\nH\u0002J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u000eJ\u001c\u0010$\u001a\u00020!2\u0006\u0010\t\u001a\u00020\n2\n\u0010%\u001a\u00060&R\u00020\nH\u0002J\u001c\u0010'\u001a\u00020!2\u0006\u0010\t\u001a\u00020\n2\n\u0010%\u001a\u00060&R\u00020\nH\u0002J\u0015\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b+J\r\u0010,\u001a\u00020!H\u0000\u00a2\u0006\u0002\b-R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001a\u001a\u00020\u001b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001c\u0010\u001d\u00a8\u00060"}, d2={"Lcom/salesforce/barcodescannerplugin/camera/CameraSource;", "", "graphicOverlay", "Lcom/salesforce/barcodescannerplugin/camera/GraphicOverlay;", "(Lcom/salesforce/barcodescannerplugin/camera/GraphicOverlay;)V", "bytesToByteBuffer", "Ljava/util/IdentityHashMap;", "", "Ljava/nio/ByteBuffer;", "camera", "Landroid/hardware/Camera;", "context", "Landroid/content/Context;", "frameProcessor", "Lcom/salesforce/barcodescannerplugin/camera/FrameProcessor;", "<set-?>", "Lcom/google/android/gms/common/images/Size;", "previewSize", "getPreviewSize$barcodescanner_release", "()Lcom/google/android/gms/common/images/Size;", "processingRunnable", "Lcom/salesforce/barcodescannerplugin/camera/CameraSource$FrameProcessingRunnable;", "processingThread", "Ljava/lang/Thread;", "processorLock", "Ljava/lang/Object;", "rotation", "", "rotation$annotations", "()V", "createCamera", "createPreviewBuffer", "release", "", "setFrameProcessor", "processor", "setPreviewAndPictureSize", "parameters", "Landroid/hardware/Camera$Parameters;", "setRotation", "start", "surfaceHolder", "Landroid/view/SurfaceHolder;", "start$barcodescanner_release", "stop", "stop$barcodescanner_release", "Companion", "FrameProcessingRunnable", "barcodescanner_release"})
public final class CameraSource {
    private Camera camera;
    private int rotation;
    @Nullable
    private Size previewSize;
    private Thread processingThread;
    private final FrameProcessingRunnable processingRunnable;
    private final Object processorLock;
    private FrameProcessor frameProcessor;
    private final IdentityHashMap<byte[], ByteBuffer> bytesToByteBuffer;
    private final Context context;
    private final GraphicOverlay graphicOverlay;
    public static final int CAMERA_FACING_BACK = 0;
    private static final String TAG = "CameraSource";
    private static final int IMAGE_FORMAT = 17;
    private static final int MIN_CAMERA_PREVIEW_WIDTH = 400;
    private static final int MAX_CAMERA_PREVIEW_WIDTH = 1300;
    private static final int DEFAULT_REQUESTED_CAMERA_PREVIEW_WIDTH = 640;
    private static final int DEFAULT_REQUESTED_CAMERA_PREVIEW_HEIGHT = 360;
    private static final float REQUESTED_CAMERA_FPS = 30.0f;
    public static final Companion Companion = new Companion(null);

    @FirebaseVisionImageMetadata.Rotation
    private static /* synthetic */ void rotation$annotations() {
    }

    @Nullable
    public final Size getPreviewSize$barcodescanner_release() {
        return this.previewSize;
    }

    public final synchronized void start$barcodescanner_release(@NotNull SurfaceHolder surfaceHolder) {
        Intrinsics.checkParameterIsNotNull((Object)surfaceHolder, (String)"surfaceHolder");
        if (this.camera != null) {
            return;
        }
        try {
            Camera camera;
            Object object = this.createCamera();
            CameraSource cameraSource = this;
            boolean bl = false;
            boolean bl2 = false;
            Camera $this$apply = object;
            boolean bl3 = false;
            $this$apply.setPreviewDisplay(surfaceHolder);
            $this$apply.startPreview();
            cameraSource.camera = camera = object;
            object = new Thread(this.processingRunnable);
            cameraSource = this;
            bl = false;
            bl2 = false;
            $this$apply = object;
            boolean bl4 = false;
            this.processingRunnable.setActive$barcodescanner_release(true);
            $this$apply.start();
            camera = object;
            cameraSource.processingThread = camera;
        }
        catch (IOException ioException) {
            Utils.INSTANCE.postError(TAG, "There was a problem starting the camera", ioException);
        }
    }

    public final synchronized void stop$barcodescanner_release() {
        Thread it;
        boolean bl;
        boolean bl2;
        Thread thread;
        this.processingRunnable.setActive$barcodescanner_release(false);
        Thread thread2 = this.processingThread;
        if (thread2 != null) {
            thread = thread2;
            bl2 = false;
            bl = false;
            it = thread;
            boolean bl3 = false;
            try {
                it.join();
            }
            catch (InterruptedException e) {
                Utils.INSTANCE.postError(TAG, "Frame processing thread interrupted on stop.", e);
            }
            this.processingThread = null;
        }
        Camera camera = this.camera;
        if (camera != null) {
            thread = camera;
            bl2 = false;
            bl = false;
            it = thread;
            boolean bl4 = false;
            it.stopPreview();
            it.setPreviewCallbackWithBuffer(null);
            try {
                it.setPreviewDisplay(null);
            }
            catch (Exception e) {
                Utils.INSTANCE.postError(TAG, "Failed to clear camera preview", e);
            }
            it.release();
            this.camera = null;
        }
        this.bytesToByteBuffer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        this.graphicOverlay.clear();
        Object object = this.processorLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            Unit unit;
            boolean bl3 = false;
            this.stop$barcodescanner_release();
            FrameProcessor frameProcessor = this.frameProcessor;
            if (frameProcessor != null) {
                frameProcessor.stop();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFrameProcessor(@NotNull FrameProcessor processor) {
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        this.graphicOverlay.clear();
        Object object = this.processorLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            FrameProcessor frameProcessor = this.frameProcessor;
            if (frameProcessor != null) {
                frameProcessor.stop();
            }
            this.frameProcessor = processor;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final Camera createCamera() throws IOException {
        Camera camera;
        block4: {
            Camera.Parameters parameters;
            Camera camera2 = Camera.open();
            if (camera2 == null) {
                throw (Throwable)new IOException("There is no back-facing camera.");
            }
            camera = camera2;
            Camera.Parameters parameters2 = parameters = camera.getParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)parameters2, (String)"parameters");
            this.setPreviewAndPictureSize(camera, parameters2);
            this.setRotation(camera, parameters);
            int[] nArray = CameraSource.Companion.selectPreviewFpsRange(camera);
            if (nArray == null) {
                throw (Throwable)new IOException("Could not find suitable preview frames per second range.");
            }
            int[] previewFpsRange = nArray;
            parameters.setPreviewFpsRange(previewFpsRange[0], previewFpsRange[1]);
            parameters.setPreviewFormat(17);
            if (parameters.getSupportedFocusModes().contains("continuous-video")) {
                parameters.setFocusMode("continuous-video");
            } else {
                Log.i((String)TAG, (String)"Camera auto focus is not supported on this device.");
            }
            camera.setParameters(parameters);
            Function2 function2 = (Function2)new Function2<byte[], Camera, Unit>(this.processingRunnable){

                public final void invoke(@NotNull byte[] p1, @NotNull Camera p2) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                    ((FrameProcessingRunnable)this.receiver).setNextFrame$barcodescanner_release(p1, p2);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(FrameProcessingRunnable.class);
                }

                public final String getName() {
                    return "setNextFrame";
                }

                public final String getSignature() {
                    return "setNextFrame$barcodescanner_release([BLandroid/hardware/Camera;)V";
                }
            };
            camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)new CameraSource$sam$android_hardware_Camera_PreviewCallback$0(function2));
            Size size = this.previewSize;
            if (size == null) break block4;
            function2 = size;
            boolean bl = false;
            boolean bl2 = false;
            Function2 it = function2;
            boolean bl3 = false;
            camera.addCallbackBuffer(this.createPreviewBuffer((Size)it));
            camera.addCallbackBuffer(this.createPreviewBuffer((Size)it));
            camera.addCallbackBuffer(this.createPreviewBuffer((Size)it));
            camera.addCallbackBuffer(this.createPreviewBuffer((Size)it));
        }
        return camera;
    }

    private final void setPreviewAndPictureSize(Camera camera, Camera.Parameters parameters) throws IOException {
        block1: {
            CameraSource cameraSource = this;
            boolean bl = false;
            boolean bl2 = false;
            CameraSource $this$run = cameraSource;
            boolean bl3 = false;
            Context context = $this$run.graphicOverlay.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"graphicOverlay.context");
            float displayAspectRatioInLandscape = Utils.INSTANCE.isPortraitMode(context) ? (float)$this$run.graphicOverlay.getHeight() / (float)$this$run.graphicOverlay.getWidth() : (float)$this$run.graphicOverlay.getWidth() / (float)$this$run.graphicOverlay.getHeight();
            CameraSizePair cameraSizePair = CameraSource.Companion.selectSizePair(camera, displayAspectRatioInLandscape);
            if (cameraSizePair == null) {
                throw (Throwable)new IOException("Could not find suitable preview size.");
            }
            CameraSizePair sizePair = cameraSizePair;
            cameraSource = sizePair.getPreview();
            CameraSource cameraSource2 = this;
            bl = false;
            bl2 = false;
            CameraSource it = cameraSource;
            boolean bl4 = false;
            Log.v((String)TAG, (String)("Camera preview size: " + it));
            parameters.setPreviewSize(it.getWidth(), it.getHeight());
            CameraSource cameraSource3 = cameraSource;
            cameraSource2.previewSize = cameraSource3;
            Size size = sizePair.getPicture();
            if (size == null) break block1;
            cameraSource = size;
            bl = false;
            bl2 = false;
            CameraSource pictureSize = cameraSource;
            boolean bl5 = false;
            Log.v((String)TAG, (String)("Camera picture size: " + pictureSize));
            parameters.setPictureSize(pictureSize.getWidth(), pictureSize.getHeight());
        }
    }

    private final void setRotation(Camera camera, Camera.Parameters parameters) {
        int n;
        Object object = this.context.getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        Display display = windowManager.getDefaultDisplay();
        Intrinsics.checkExpressionValueIsNotNull((Object)display, (String)"windowManager.defaultDisplay");
        int deviceRotation = display.getRotation();
        if (deviceRotation == 0) {
            n = 0;
        } else if (deviceRotation == 1) {
            n = 90;
        } else if (deviceRotation == 2) {
            n = 180;
        } else if (deviceRotation == 3) {
            n = 270;
        } else {
            Log.e((String)TAG, (String)("Bad device rotation value: " + deviceRotation));
            n = 0;
        }
        int degrees = n;
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)0, (Camera.CameraInfo)cameraInfo);
        int angle = (cameraInfo.orientation - degrees + 360) % 360;
        this.rotation = angle / 90;
        camera.setDisplayOrientation(angle);
        parameters.setRotation(angle);
    }

    /*
     * Unable to fully structure code
     */
    private final byte[] createPreviewBuffer(Size previewSize) {
        bitsPerPixel = ImageFormat.getBitsPerPixel((int)17);
        sizeInBits = (long)previewSize.getHeight() * (long)previewSize.getWidth() * (long)bitsPerPixel;
        var6_4 = (double)sizeInBits / 8.0;
        var8_6 = false;
        bufferSize = (int)Math.ceil(var6_4) + 1;
        byteArray = new byte[bufferSize];
        byteBuffer = ByteBuffer.wrap(byteArray);
        if (!byteBuffer.hasArray()) ** GOTO lbl-1000
        v0 = byteBuffer.array();
        if (v0 == null) {
            Intrinsics.throwNpe();
        }
        var8_7 = v0;
        var9_10 = false;
        if (Arrays.equals(var8_7, byteArray)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        var8_6 = v1;
        var9_10 = false;
        var10_11 = false;
        if (!var8_6) {
            $i$a$-check-CameraSource$createPreviewBuffer$1 = false;
            var10_12 = "Failed to create valid buffer for camera source.";
            throw (Throwable)new IllegalStateException(var10_12.toString());
        }
        ((Map)this.bytesToByteBuffer).put(byteArray, byteBuffer);
        return byteArray;
    }

    public CameraSource(@NotNull GraphicOverlay graphicOverlay) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)graphicOverlay), (String)"graphicOverlay");
        this.graphicOverlay = graphicOverlay;
        this.processingRunnable = new FrameProcessingRunnable();
        this.processorLock = new Object();
        this.bytesToByteBuffer = new IdentityHashMap();
        Context context = this.graphicOverlay.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"graphicOverlay.context");
        this.context = context;
    }

    public static final /* synthetic */ Size access$getPreviewSize$p(CameraSource $this) {
        return $this.previewSize;
    }

    public static final /* synthetic */ void access$setPreviewSize$p(CameraSource $this, Size size) {
        $this.previewSize = size;
    }

    public static final /* synthetic */ void access$setRotation$p(CameraSource $this, int n) {
        $this.rotation = n;
    }

    public static final /* synthetic */ void access$setFrameProcessor$p(CameraSource $this, FrameProcessor frameProcessor) {
        $this.frameProcessor = frameProcessor;
    }

    public static final /* synthetic */ void access$setCamera$p(CameraSource $this, Camera camera) {
        $this.camera = camera;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\fJ\u001d\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/salesforce/barcodescannerplugin/camera/CameraSource$FrameProcessingRunnable;", "Ljava/lang/Runnable;", "(Lcom/salesforce/barcodescannerplugin/camera/CameraSource;)V", "active", "", "lock", "Ljava/lang/Object;", "pendingFrameData", "Ljava/nio/ByteBuffer;", "run", "", "setActive", "setActive$barcodescanner_release", "setNextFrame", "data", "", "camera", "Landroid/hardware/Camera;", "setNextFrame$barcodescanner_release", "barcodescanner_release"})
    private final class FrameProcessingRunnable
    implements Runnable {
        private final Object lock = new Object();
        private boolean active = true;
        private ByteBuffer pendingFrameData;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setActive$barcodescanner_release(boolean active) {
            Object object = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                this.active = active;
                this.lock.notifyAll();
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setNextFrame$barcodescanner_release(@NotNull byte[] data, @NotNull Camera camera) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)camera, (String)"camera");
            Object object = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                ByteBuffer byteBuffer = this.pendingFrameData;
                if (byteBuffer != null) {
                    ByteBuffer byteBuffer2 = byteBuffer;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    ByteBuffer it = byteBuffer2;
                    boolean bl6 = false;
                    camera.addCallbackBuffer(it.array());
                    this.pendingFrameData = null;
                }
                if (!CameraSource.this.bytesToByteBuffer.containsKey(data)) {
                    Log.d((String)CameraSource.TAG, (String)"Skipping frame. Could not find ByteBuffer associated with the image data from the camera.");
                    return;
                }
                this.pendingFrameData = (ByteBuffer)CameraSource.this.bytesToByteBuffer.get(data);
                this.lock.notifyAll();
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Ref.ObjectRef data = new Ref.ObjectRef();
            while (true) {
                Object object = this.lock;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    while (this.active && this.pendingFrameData == null) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException e) {
                            Utils.INSTANCE.postError(CameraSource.TAG, "Frame processing loop terminated.", e);
                            return;
                        }
                    }
                    if (!this.active) {
                        return;
                    }
                    data.element = this.pendingFrameData;
                    this.pendingFrameData = null;
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    object = CameraSource.this.processorLock;
                    bl = false;
                    boolean bl4 = false;
                    synchronized (object) {
                        Unit unit;
                        boolean bl5 = false;
                        Size size = CameraSource.this.getPreviewSize$barcodescanner_release();
                        if (size == null) {
                            Intrinsics.throwNpe();
                        }
                        int n = size.getWidth();
                        Size size2 = CameraSource.this.getPreviewSize$barcodescanner_release();
                        if (size2 == null) {
                            Intrinsics.throwNpe();
                        }
                        FrameMetadata frameMetadata = new FrameMetadata(n, size2.getHeight(), CameraSource.this.rotation);
                        if ((ByteBuffer)data.element != null) {
                            ByteBuffer byteBuffer;
                            boolean bl6 = false;
                            boolean bl7 = false;
                            ByteBuffer it = byteBuffer;
                            boolean bl8 = false;
                            FrameProcessor frameProcessor = CameraSource.this.frameProcessor;
                            if (frameProcessor != null) {
                                frameProcessor.process(it, frameMetadata, CameraSource.this.graphicOverlay);
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                        } else {
                            unit = null;
                        }
                        Unit unit2 = unit;
                        continue;
                    }
                }
                catch (Exception e) {
                    Utils.INSTANCE.postError(CameraSource.TAG, "Exception thrown from receiver.", e);
                    continue;
                }
                finally {
                    ByteBuffer byteBuffer = (ByteBuffer)data.element;
                    if (byteBuffer == null) continue;
                    object = byteBuffer;
                    bl = false;
                    boolean bl9 = false;
                    Object it = object;
                    boolean bl10 = false;
                    Camera camera = CameraSource.this.camera;
                    if (camera != null) {
                        camera.addCallbackBuffer(((ByteBuffer)it).array());
                    }
                    continue;
                }
                break;
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/salesforce/barcodescannerplugin/camera/CameraSource$Companion;", "", "()V", "CAMERA_FACING_BACK", "", "DEFAULT_REQUESTED_CAMERA_PREVIEW_HEIGHT", "DEFAULT_REQUESTED_CAMERA_PREVIEW_WIDTH", "IMAGE_FORMAT", "MAX_CAMERA_PREVIEW_WIDTH", "MIN_CAMERA_PREVIEW_WIDTH", "REQUESTED_CAMERA_FPS", "", "TAG", "", "selectPreviewFpsRange", "", "camera", "Landroid/hardware/Camera;", "selectSizePair", "Lcom/salesforce/barcodescannerplugin/camera/CameraSizePair;", "displayAspectRatioInLandscape", "barcodescanner_release"})
    public static final class Companion {
        private final CameraSizePair selectSizePair(Camera camera, float displayAspectRatioInLandscape) {
            boolean bl;
            List<CameraSizePair> validPreviewSizes = Utils.INSTANCE.generateValidPreviewSizeList(camera);
            CameraSizePair selectedPair = null;
            float minAspectRatioDiff = FloatCompanionObject.INSTANCE.getMAX_VALUE();
            for (CameraSizePair sizePair : validPreviewSizes) {
                Size previewSize = sizePair.getPreview();
                if (previewSize.getWidth() < 400 || previewSize.getWidth() > 1300) continue;
                float previewAspectRatio = (float)previewSize.getWidth() / (float)previewSize.getHeight();
                float f = displayAspectRatioInLandscape - previewAspectRatio;
                bl = false;
                float aspectRatioDiff = Math.abs(f);
                f = aspectRatioDiff - minAspectRatioDiff;
                bl = false;
                if (Math.abs(f) < 0.01f) {
                    if (selectedPair != null && selectedPair.getPreview().getWidth() >= sizePair.getPreview().getWidth()) continue;
                    selectedPair = sizePair;
                    continue;
                }
                if (!(aspectRatioDiff < minAspectRatioDiff)) continue;
                minAspectRatioDiff = aspectRatioDiff;
                selectedPair = sizePair;
            }
            if (selectedPair == null) {
                int minDiff = Integer.MAX_VALUE;
                for (CameraSizePair sizePair : validPreviewSizes) {
                    Size size = sizePair.getPreview();
                    int n = size.getWidth() - 640;
                    bl = false;
                    int n2 = Math.abs(n);
                    n = size.getHeight() - 360;
                    int n3 = n2;
                    bl = false;
                    int n4 = Math.abs(n);
                    int diff = n3 + n4;
                    if (diff >= minDiff) continue;
                    selectedPair = sizePair;
                    minDiff = diff;
                }
            }
            return selectedPair;
        }

        private final int[] selectPreviewFpsRange(Camera camera) {
            int desiredPreviewFpsScaled = (int)30000.0f;
            int[] selectedFpsRange = null;
            int minDiff = Integer.MAX_VALUE;
            Camera.Parameters parameters = camera.getParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)parameters, (String)"camera.parameters");
            for (int[] range : parameters.getSupportedPreviewFpsRange()) {
                int deltaMin = desiredPreviewFpsScaled - range[0];
                int deltaMax = desiredPreviewFpsScaled - range[1];
                boolean bl = false;
                int n = Math.abs(deltaMin);
                bl = false;
                int n2 = Math.abs(deltaMax);
                int diff = n + n2;
                if (diff >= minDiff) continue;
                selectedFpsRange = range;
                minDiff = diff;
            }
            return selectedFpsRange;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

