/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.barcodescannerplugin.camera;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.google.android.gms.common.images.Size;
import com.salesforce.barcodescannerplugin.Utils;
import com.salesforce.barcodescannerplugin.camera.CameraSource;
import java.util.ArrayList;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tJ\u0006\u0010\u0015\u001a\u00020\u0013J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000bH\u0002J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/salesforce/barcodescannerplugin/camera/GraphicOverlay;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "graphics", "Ljava/util/ArrayList;", "Lcom/salesforce/barcodescannerplugin/camera/GraphicOverlay$Graphic;", "heightScaleFactor", "", "lock", "", "previewHeight", "", "previewWidth", "widthScaleFactor", "add", "", "graphic", "clear", "onDraw", "canvas", "Landroid/graphics/Canvas;", "setCameraInfo", "cameraSource", "Lcom/salesforce/barcodescannerplugin/camera/CameraSource;", "translateRect", "Landroid/graphics/RectF;", "rect", "Landroid/graphics/Rect;", "translateX", "x", "translateY", "y", "Graphic", "barcodescanner_release"})
public final class GraphicOverlay
extends View {
    private final Object lock;
    private int previewWidth;
    private float widthScaleFactor;
    private int previewHeight;
    private float heightScaleFactor;
    private final ArrayList<Graphic> graphics;
    private HashMap _$_findViewCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.graphics.clear();
            Unit unit = Unit.INSTANCE;
        }
        this.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(@NotNull Graphic graphic) {
        Intrinsics.checkParameterIsNotNull((Object)graphic, (String)"graphic");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            bl2 = this.graphics.add(graphic);
        }
    }

    public final void setCameraInfo(@NotNull CameraSource cameraSource) {
        Intrinsics.checkParameterIsNotNull((Object)cameraSource, (String)"cameraSource");
        Size size = cameraSource.getPreviewSize$barcodescanner_release();
        if (size == null) {
            return;
        }
        Size previewSize = size;
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        if (Utils.INSTANCE.isPortraitMode(context)) {
            this.previewWidth = previewSize.getHeight();
            this.previewHeight = previewSize.getWidth();
        } else {
            this.previewWidth = previewSize.getWidth();
            this.previewHeight = previewSize.getHeight();
        }
    }

    private final float translateX(float x) {
        return x * this.widthScaleFactor;
    }

    private final float translateY(float y) {
        return y * this.heightScaleFactor;
    }

    @NotNull
    public final RectF translateRect(@NotNull Rect rect) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        return new RectF(this.translateX(rect.left), this.translateY(rect.top), this.translateX(rect.right), this.translateY(rect.bottom));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (this.previewWidth > 0 && this.previewHeight > 0) {
            this.widthScaleFactor = (float)this.getWidth() / (float)this.previewWidth;
            this.heightScaleFactor = (float)this.getHeight() / (float)this.previewHeight;
        }
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            Iterable $this$forEach$iv = this.graphics;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Graphic it = (Graphic)element$iv;
                boolean bl4 = false;
                it.draw(canvas);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public GraphicOverlay(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.lock = new Object();
        this.widthScaleFactor = 1.0f;
        this.heightScaleFactor = 1.0f;
        this.graphics = new ArrayList();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/salesforce/barcodescannerplugin/camera/GraphicOverlay$Graphic;", "", "overlay", "Lcom/salesforce/barcodescannerplugin/camera/GraphicOverlay;", "(Lcom/salesforce/barcodescannerplugin/camera/GraphicOverlay;)V", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "draw", "", "canvas", "Landroid/graphics/Canvas;", "barcodescanner_release"})
    public static abstract class Graphic {
        @NotNull
        private final Context context;

        @NotNull
        protected final Context getContext() {
            return this.context;
        }

        public abstract void draw(@NotNull Canvas var1);

        protected Graphic(@NotNull GraphicOverlay overlay) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)overlay), (String)"overlay");
            Context context = overlay.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"overlay.context");
            this.context = context;
        }
    }
}

