/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.http.interceptor;

import com.safframework.http.interceptor.Logger;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/safframework/http/interceptor/LoggingInterceptor;", "Lokhttp3/Interceptor;", "builder", "Lcom/safframework/http/interceptor/LoggingInterceptor$Builder;", "(Lcom/safframework/http/interceptor/LoggingInterceptor$Builder;)V", "isDebug", "", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "subtypeIsNotFile", "subtype", "", "Builder", "lib_release"})
public final class LoggingInterceptor
implements Interceptor {
    private final boolean isDebug;
    private final Builder builder;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request request = chain.request();
        if (this.builder.getHeaders$lib_release().size() > 0) {
            Headers headers = request.headers();
            Set names = headers.names();
            Iterator iterator = names.iterator();
            Request.Builder requestBuilder = request.newBuilder();
            requestBuilder.headers(this.builder.getHeaders$lib_release());
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                requestBuilder.addHeader(name, headers.get(name));
            }
            request = requestBuilder.build();
        }
        if (!this.isDebug) {
            Response response = chain.proceed(request);
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"chain.proceed(request)");
            return response;
        }
        RequestBody requestBody = request.body();
        MediaType rContentType = null;
        if (requestBody != null) {
            RequestBody requestBody2 = request.body();
            if (requestBody2 == null) {
                Intrinsics.throwNpe();
            }
            rContentType = requestBody2.contentType();
        }
        String rSubtype = null;
        if (rContentType != null) {
            rSubtype = rContentType.subtype();
        }
        if (this.builder.getRequestFlag()) {
            if (Intrinsics.areEqual((Object)request.method(), (Object)"GET")) {
                Request request2 = request;
                Intrinsics.checkExpressionValueIsNotNull((Object)request2, (String)"request");
                Logger.Companion.printJsonRequest(this.builder, request2);
            } else if (this.subtypeIsNotFile(rSubtype)) {
                Request request3 = request;
                Intrinsics.checkExpressionValueIsNotNull((Object)request3, (String)"request");
                Logger.Companion.printJsonRequest(this.builder, request3);
            } else {
                Request request4 = request;
                Intrinsics.checkExpressionValueIsNotNull((Object)request4, (String)"request");
                Logger.Companion.printFileRequest(this.builder, request4);
            }
        }
        long st = System.nanoTime();
        Response response = chain.proceed(request);
        if (this.builder.getResponseFlag()) {
            ResponseBody responseBody;
            Object object = request.tag();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type okhttp3.Request");
            }
            List segmentList = ((Request)object).url().encodedPathSegments();
            long chainMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - st);
            String header = response.headers().toString();
            int code = response.code();
            Response response2 = response;
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
            boolean isSuccessful = response2.isSuccessful();
            ResponseBody responseBody2 = responseBody = response.body();
            if (responseBody2 == null) {
                Intrinsics.throwNpe();
            }
            MediaType contentType = responseBody2.contentType();
            String subtype = null;
            if (contentType != null) {
                subtype = contentType.subtype();
            }
            if (!this.subtypeIsNotFile(subtype)) {
                String string = header;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"header");
                List list = segmentList;
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"segmentList");
                Logger.Companion.printFileResponse(this.builder, chainMs, isSuccessful, code, string, list);
                return response;
            }
            String string = responseBody.string();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"responseBody.string()");
            String bodyString = Logger.Companion.getJsonString(string);
            String string2 = header;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"header");
            List list = segmentList;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"segmentList");
            Logger.Companion.printJsonResponse(this.builder, chainMs, isSuccessful, code, string2, bodyString, list);
            ResponseBody responseBody3 = ResponseBody.create((MediaType)contentType, (String)bodyString);
            Intrinsics.checkExpressionValueIsNotNull((Object)responseBody3, (String)"ResponseBody.create(contentType, bodyString)");
            ResponseBody body = responseBody3;
            Response response3 = response.newBuilder().body(body).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response3, (String)"response.newBuilder().body(body).build()");
            return response3;
        }
        Response response4 = response;
        Intrinsics.checkExpressionValueIsNotNull((Object)response4, (String)"response");
        return response4;
    }

    private final boolean subtypeIsNotFile(String subtype) {
        return subtype != null && (StringsKt.contains$default((CharSequence)subtype, (CharSequence)"json", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)subtype, (CharSequence)"xml", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)subtype, (CharSequence)"plain", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)subtype, (CharSequence)"html", (boolean)false, (int)2, null));
    }

    private LoggingInterceptor(Builder builder) {
        this.builder = builder;
        this.isDebug = this.builder.isDebug();
    }

    public /* synthetic */ LoggingInterceptor(@NotNull Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\u0006\u0010\u001f\u001a\u00020 J\u0015\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b#J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010%\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0004J\u0006\u0010'\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0004J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0011\"\u0004\b\u001a\u0010\u0013R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/safframework/http/interceptor/LoggingInterceptor$Builder;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "setTAG", "(Ljava/lang/String;)V", "builder", "Lokhttp3/Headers$Builder;", "headers", "Lokhttp3/Headers;", "getHeaders$lib_release", "()Lokhttp3/Headers;", "isDebug", "", "()Z", "setDebug", "(Z)V", "requestFlag", "getRequestFlag", "setRequestFlag", "requestTag", "responseFlag", "getResponseFlag", "setResponseFlag", "responseTag", "addHeader", "name", "value", "build", "Lcom/safframework/http/interceptor/LoggingInterceptor;", "getTag", "isRequest", "getTag$lib_release", "loggable", "request", "tag", "response", "lib_release"})
    public static final class Builder {
        @NotNull
        private String TAG = "SAF_Logging_Interceptor";
        private boolean isDebug;
        private boolean requestFlag;
        private boolean responseFlag;
        private String requestTag;
        private String responseTag;
        private final Headers.Builder builder = new Headers.Builder();

        @NotNull
        public final String getTAG() {
            return this.TAG;
        }

        public final void setTAG(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.TAG = string;
        }

        public final boolean isDebug() {
            return this.isDebug;
        }

        public final void setDebug(boolean bl) {
            this.isDebug = bl;
        }

        public final boolean getRequestFlag() {
            return this.requestFlag;
        }

        public final void setRequestFlag(boolean bl) {
            this.requestFlag = bl;
        }

        public final boolean getResponseFlag() {
            return this.responseFlag;
        }

        public final void setResponseFlag(boolean bl) {
            this.responseFlag = bl;
        }

        @NotNull
        public final Headers getHeaders$lib_release() {
            Headers headers = this.builder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)headers, (String)"builder.build()");
            return headers;
        }

        @NotNull
        public final String getTag$lib_release(boolean isRequest) {
            String string;
            if (isRequest) {
                String string2;
                CharSequence charSequence = this.requestTag;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    string2 = this.TAG;
                } else {
                    string2 = this.requestTag;
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                }
                return string2;
            }
            CharSequence charSequence = this.responseTag;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                string = this.TAG;
            } else {
                string = this.responseTag;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
            }
            return string;
        }

        @NotNull
        public final Builder addHeader(@NotNull String name, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.builder.set(name, value);
            return this;
        }

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.TAG = tag;
            return this;
        }

        @NotNull
        public final Builder requestTag(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.requestTag = tag;
            return this;
        }

        @NotNull
        public final Builder responseTag(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.responseTag = tag;
            return this;
        }

        @NotNull
        public final Builder request() {
            this.requestFlag = true;
            return this;
        }

        @NotNull
        public final Builder response() {
            this.responseFlag = true;
            return this;
        }

        @NotNull
        public final Builder loggable(boolean isDebug) {
            this.isDebug = isDebug;
            return this;
        }

        @NotNull
        public final LoggingInterceptor build() {
            return new LoggingInterceptor(this, null);
        }
    }
}

