/*
 * Decompiled with CFR 0.152.
 */
package com.rustfisher.btscanner;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.rustfisher.btscanner.BtDeviceItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class BtScanner {
    private static final String TAG = "rustApp";
    private long scanPeriod = 14000L;
    private long notifyInterval = 2000L;
    private boolean loadBondDevice = true;
    private BluetoothAdapter btAdapter;
    private Handler handler;
    private ArrayList<BtDeviceItem> deviceList;
    private List<Listener> listeners;
    private NotifyScanListThread notifyScanListThread;
    private BluetoothLeScanner bleScanner;
    private ScanCallback bleScanCallback;
    private boolean scanning;
    private Runnable stopScanLeRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                BtScanner.this.stopNotifyThread();
                BtScanner.this.scanning = false;
                BtScanner.this.notifyScanStatus(false);
                if (BtScanner.laterThanLL()) {
                    BtScanner.this.bleScanner.stopScan(BtScanner.this.bleScanCallback);
                } else {
                    BtScanner.this.btAdapter.stopLeScan(BtScanner.this.defBleScanCallback);
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
    };
    private BluetoothAdapter.LeScanCallback defBleScanCallback = new BluetoothAdapter.LeScanCallback(){

        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            String name = device.getName();
            if (TextUtils.isEmpty((CharSequence)name)) {
                return;
            }
            BtDeviceItem item = new BtDeviceItem(device, rssi);
            int index = BtScanner.this.deviceList.indexOf(item);
            if (index <= -1) {
                BtScanner.this.deviceList.add(item);
            } else {
                ((BtDeviceItem)BtScanner.this.deviceList.get(index)).setRssi(rssi);
            }
        }
    };

    public BtScanner() {
        this.initBtUtils();
    }

    public BtScanner(long period) {
        this.initBtUtils();
        this.setScanPeriod(period);
    }

    private void initBtUtils() {
        this.btAdapter = BluetoothAdapter.getDefaultAdapter();
        this.deviceList = new ArrayList();
        this.listeners = new ArrayList<Listener>();
        this.handler = new Handler(Looper.getMainLooper());
        if (BtScanner.laterThanLL()) {
            this.bleScanner = this.btAdapter.getBluetoothLeScanner();
            this.initBleScanCallback();
        }
    }

    public long getScanPeriod() {
        return this.scanPeriod;
    }

    public void setScanPeriod(long scanPeriod) {
        if (scanPeriod < 100L) {
            scanPeriod = 100L;
        } else if (scanPeriod > 180000L) {
            scanPeriod = 180000L;
        }
        this.scanPeriod = scanPeriod;
    }

    public long getNotifyInterval() {
        return this.notifyInterval;
    }

    public void setNotifyInterval(long interval) {
        if (interval < 100L) {
            interval = 100L;
        } else if (interval > 5000L) {
            interval = 5000L;
        }
        this.notifyInterval = interval;
    }

    public boolean isLoadBondDevice() {
        return this.loadBondDevice;
    }

    public void setLoadBondDevice(boolean loadBondDevice) {
        this.loadBondDevice = loadBondDevice;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void clearListener() {
        this.listeners.clear();
    }

    public boolean isScanning() {
        return this.scanning;
    }

    private void updatePairedDevice() {
        Set pairedDevices = this.btAdapter.getBondedDevices();
        if (pairedDevices.size() > 0) {
            for (BluetoothDevice device : pairedDevices) {
                String name = device.getName();
                if (TextUtils.isEmpty((CharSequence)name)) continue;
                this.deviceList.add(new BtDeviceItem(device, 0));
            }
            this.notifyDeviceListChanged(this.deviceList);
        }
    }

    private void restartNotifyThread() {
        this.stopNotifyThread();
        this.notifyScanListThread = new NotifyScanListThread(this);
        this.notifyScanListThread.start();
    }

    private void stopNotifyThread() {
        if (null != this.notifyScanListThread) {
            this.notifyScanListThread.interrupt();
            this.notifyScanListThread = null;
        }
    }

    public void startScan() {
        if (!this.btIsOn()) {
            Log.e((String)TAG, (String)("start scan fail, bt is not On.  Bt state = " + this.btAdapter.getState()));
            return;
        }
        this.deviceList.clear();
        this.handler.removeCallbacks(this.stopScanLeRunnable);
        if (this.loadBondDevice) {
            this.updatePairedDevice();
        }
        this.handler.postDelayed(this.stopScanLeRunnable, this.scanPeriod);
        this.scanning = true;
        if (BtScanner.laterThanLL()) {
            this.bleScanner.startScan(this.bleScanCallback);
            Log.d((String)TAG, (String)"bleScanner startScan");
        } else {
            this.btAdapter.startLeScan(this.defBleScanCallback);
            Log.d((String)TAG, (String)"btAdapter startLeScan");
        }
        this.notifyScanStatus(this.scanning);
        this.restartNotifyThread();
    }

    public void stopScan() {
        if (!this.btIsOn()) {
            Log.e((String)TAG, (String)("stop scan fail, bt is not On.  Bt state = " + this.btAdapter.getState()));
            return;
        }
        this.stopNotifyThread();
        this.handler.removeCallbacks(null);
        this.scanning = false;
        this.notifyScanStatus(false);
        if (BtScanner.laterThanLL()) {
            this.bleScanner.stopScan(this.bleScanCallback);
        } else {
            this.btAdapter.stopLeScan(this.defBleScanCallback);
        }
    }

    private void initBleScanCallback() {
        if (BtScanner.laterThanLL()) {
            this.bleScanCallback = new ScanCallback(){

                public void onScanResult(int callbackType, ScanResult result) {
                    super.onScanResult(callbackType, result);
                    if (BtScanner.laterThanLL()) {
                        String name = result.getDevice().getName();
                        if (TextUtils.isEmpty((CharSequence)name)) {
                            return;
                        }
                        BtDeviceItem item = new BtDeviceItem(result.getDevice(), result.getRssi());
                        int index = BtScanner.this.deviceList.indexOf(item);
                        if (index <= -1) {
                            BtScanner.this.deviceList.add(item);
                        } else {
                            ((BtDeviceItem)BtScanner.this.deviceList.get(index)).setRssi(result.getRssi());
                        }
                    }
                }

                public void onBatchScanResults(List<ScanResult> results) {
                    super.onBatchScanResults(results);
                }

                public void onScanFailed(int errorCode) {
                    super.onScanFailed(errorCode);
                    BtScanner.this.notifyScanStatus(false);
                }
            };
        }
    }

    private void notifyDeviceListChanged(ArrayList<BtDeviceItem> deviceList) {
        final ArrayList<Listener> listenerList = new ArrayList<Listener>(this.listeners);
        final ArrayList<BtDeviceItem> newESList = new ArrayList<BtDeviceItem>(deviceList);
        Collections.sort(newESList);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (Listener l : listenerList) {
                    l.onDeviceListUpdated(newESList);
                }
            }
        });
    }

    private void notifyScanStatus(boolean scanning) {
        final ArrayList<Listener> list = new ArrayList<Listener>(this.listeners);
        final boolean finalScanning = scanning;
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (Listener l : list) {
                    l.onScanning(finalScanning);
                }
            }
        });
    }

    private boolean btIsOn() {
        return this.btAdapter.isEnabled();
    }

    private static boolean laterThanLL() {
        return Build.VERSION.SDK_INT >= 21;
    }

    private class NotifyScanListThread
    extends Thread {
        BtScanner mmScanner;

        NotifyScanListThread(BtScanner s) {
            this.mmScanner = s;
        }

        @Override
        public void run() {
            super.run();
            while (this.mmScanner.isScanning() && !this.isInterrupted()) {
                try {
                    Thread.sleep(BtScanner.this.notifyInterval);
                    this.mmScanner.notifyDeviceListChanged(this.mmScanner.deviceList);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
    }

    public static interface Listener {
        public void onDeviceListUpdated(ArrayList<BtDeviceItem> var1);

        public void onScanning(boolean var1);
    }
}

