/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.SpannableStringBuilder;
import android.text.style.DynamicDrawableSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsListView;
import com.run.utils.SystemUtil;

public class ViewUtils {
    private static final int MAX_SMOOTH_SCROLL_POSITION = 5;
    private static final String REDIRECT_URL_PREFIX = "url=";
    private static final String ELLIPSIS = "...";
    private static final int TOAST_LENGTH = 25;
    private static final long TOAST_TIME = 500L;

    private ViewUtils() {
    }

    public static void setViewSize(View view, int width, int height) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        layoutParams.width = width;
        layoutParams.height = height;
        view.setLayoutParams(layoutParams);
    }

    @TargetApi(value=16)
    public static void setBackground(View view, Drawable background) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(background);
        } else {
            view.setBackgroundDrawable(background);
        }
    }

    public static View newInstance(ViewGroup parent, int resId) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(resId, parent, false);
    }

    public static View newInstance(Context context, int resId) {
        return LayoutInflater.from((Context)context).inflate(resId, null);
    }

    public static CharSequence getDrawableTextSpan(final int textSize, String text, final Drawable drawable) {
        SpannableStringBuilder sb = new SpannableStringBuilder((CharSequence)" ");
        sb.append((CharSequence)text);
        DynamicDrawableSpan drawableSpan = new DynamicDrawableSpan(){

            public Drawable getDrawable() {
                float height = textSize;
                float width = (float)drawable.getIntrinsicWidth() * height / (float)drawable.getIntrinsicHeight();
                drawable.setBounds(0, 0, (int)width, (int)height);
                return drawable;
            }
        };
        sb.setSpan((Object)drawableSpan, 0, 1, 17);
        return sb;
    }

    public static boolean isViewAttachedToDecorView(View view) {
        if (!(view.getContext() instanceof Activity)) {
            return true;
        }
        View decorView = ((Activity)view.getContext()).getWindow().getDecorView();
        if (view == decorView) {
            return true;
        }
        if (view.getWindowToken() != null && view.getWindowToken() != decorView.getWindowToken()) {
            return true;
        }
        for (ViewParent parent = view.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != decorView) continue;
            return true;
        }
        return false;
    }

    @TargetApi(value=8)
    public static boolean scrollToTop(AbsListView listView) {
        if (listView.getFirstVisiblePosition() == 0) {
            View firstChild = listView.getChildAt(0);
            if (firstChild == null) {
                return false;
            }
            if (firstChild.getTop() == listView.getPaddingTop()) {
                return false;
            }
        }
        ViewUtils.scrollToChildAt(listView, 0);
        return true;
    }

    @TargetApi(value=8)
    public static void scrollToChildAt(AbsListView listView, int position) {
        if (SystemUtil.aboveApiLevel(8)) {
            listView.smoothScrollBy(0, 0);
            if (Math.abs(listView.getFirstVisiblePosition() - position) <= 5) {
                listView.smoothScrollToPosition(position);
            } else {
                listView.setSelection(position);
            }
        } else {
            listView.setSelection(position);
        }
    }

    public static void clearSelected(ViewGroup viewGroup, View withoutView) {
        if (viewGroup == null) {
            return;
        }
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View child = viewGroup.getChildAt(i);
            if (child == withoutView) continue;
            child.setSelected(false);
        }
    }

    public static boolean isParentSonView(View sonView, View parentView) {
        boolean isChild = false;
        for (View parent = sonView; null != parent; parent = (View)parent.getParent()) {
            if (parent == parentView) {
                isChild = true;
                break;
            }
            if (parent.getParent() instanceof View) {
                continue;
            }
            isChild = false;
            break;
        }
        return isChild;
    }

    public static View findChildViewById(ViewGroup parent, int id) {
        if (parent == null) {
            return null;
        }
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = parent.getChildAt(i);
            if (child.getId() != id) continue;
            return child;
        }
        return null;
    }
}

