/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public class UrlExtractor {
    private URL url;

    public UrlExtractor(String urlStr) {
        try {
            this.url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            this.url = null;
            e.printStackTrace();
        }
    }

    public UrlExtractor(URL url) {
        this.url = url;
    }

    private boolean isContainHost(String host) {
        if (this.url != null) {
            return this.url.getHost().contains(host);
        }
        return false;
    }

    private URL extractUrl() {
        if (this.url != null) {
            String query = this.url.getQuery();
            Map<String, String> queryMap = UrlExtractor.splitUrlQuery(query);
            if (queryMap.containsKey("url")) {
                URL url;
                String newUrl = queryMap.get("url");
                try {
                    url = new URL(URLDecoder.decode(newUrl, "UTF-8"));
                }
                catch (MalformedURLException e) {
                    return null;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    return null;
                }
                return url;
            }
            return null;
        }
        return null;
    }

    public String extractHost(String host) {
        if (this.isContainHost(host)) {
            URL secondUrl = this.extractUrl();
            if (secondUrl != null) {
                return secondUrl.getHost();
            }
            return null;
        }
        if (this.url != null) {
            return this.url.getHost();
        }
        return null;
    }

    private static Map<String, String> splitUrlQuery(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] pairs = query.split("&");
        if (pairs != null && pairs.length > 0) {
            for (String pair : pairs) {
                String[] param = pair.split("=", 2);
                if (param == null || param.length != 2) continue;
                result.put(param[0], param[1]);
            }
        }
        return result;
    }
}

