/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import android.annotation.TargetApi;
import android.net.Uri;
import android.text.TextUtils;
import java.util.Map;

public class URIUtils {
    public static String putParamsToURL(String url, Map<String, Object> params) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        if (params == null || params.isEmpty()) {
            return url;
        }
        Uri.Builder uriBuilder = Uri.parse((String)url).buildUpon();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry == null || entry.getValue() == null) continue;
            uriBuilder.appendQueryParameter(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return uriBuilder.toString();
    }

    public static String putParamsToURLWithNoReplace(String url, Map<String, Object> params) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        if (params == null || params.isEmpty()) {
            return url;
        }
        if (url.contains("h5.ffan.com/hybrid/#") || url.contains("h5.sit.ffan.com/hybrid/#") || url.contains("h5.uat.ffan.com/hybrid/#")) {
            return URIUtils.putParamsToURLWithNoReplaceExceptionForHashTag(url, params);
        }
        if (url.contains("?")) {
            return URIUtils.putParamsToURLWithQuestion(url, params);
        }
        Uri uri = Uri.parse((String)url);
        Uri.Builder uriBuilder = uri.buildUpon();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry == null || entry.getValue() == null || !TextUtils.isEmpty((CharSequence)uri.getQueryParameter(entry.getKey()))) continue;
            uriBuilder.appendQueryParameter(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return uriBuilder.toString();
    }

    @TargetApi(value=11)
    public static String putParamsToURLWithNoReplaceExceptionForHashTag(String url, Map<String, Object> params) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        if (params == null || params.isEmpty()) {
            return url;
        }
        Uri uri = Uri.parse((String)url);
        StringBuilder stringBuilder = null;
        int position = url.indexOf("?");
        String part1 = "";
        String part2 = "";
        if (position != -1) {
            part1 = url.substring(0, position);
            part2 = url.substring(position + 1, url.length());
            stringBuilder = new StringBuilder(part1);
        } else {
            stringBuilder = new StringBuilder(url);
        }
        if (!params.isEmpty()) {
            stringBuilder.append("?");
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry == null || entry.getValue() == null || !TextUtils.isEmpty((CharSequence)uri.getQueryParameter(entry.getKey()))) continue;
            stringBuilder.append(entry.getKey()).append("=").append(Uri.encode((String)String.valueOf(entry.getValue()))).append("&");
        }
        if (TextUtils.isEmpty((CharSequence)part2)) {
            return stringBuilder.toString();
        }
        return stringBuilder.append(part2).toString();
    }

    public static String putParamsToURLWithQuestion(String url, Map<String, Object> params) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        if (params == null || params.isEmpty()) {
            return url;
        }
        Uri uri = Uri.parse((String)url);
        StringBuilder stringBuilder = null;
        int position = url.indexOf("?");
        String part1 = "";
        String part2 = "";
        if (position == -1) {
            return url;
        }
        part1 = url.substring(0, position + 1);
        part2 = url.substring(position + 1, url.length());
        stringBuilder = new StringBuilder(part1);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry == null || entry.getValue() == null || !TextUtils.isEmpty((CharSequence)uri.getQueryParameter(entry.getKey()))) continue;
            stringBuilder.append(entry.getKey()).append("=").append(Uri.encode((String)String.valueOf(entry.getValue()))).append("&");
        }
        if (TextUtils.isEmpty((CharSequence)part2)) {
            return stringBuilder.toString();
        }
        return stringBuilder.append(part2).toString();
    }
}

