/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import android.text.TextUtils;
import android.widget.TextView;

public class TextViewUtils {
    public static void setTextGoneWhenNull(TextView textView, String text) {
        TextViewUtils.setTextGoneWhenNull(textView, text, text);
    }

    public static void setTextGoneWhenNull(TextView textView, String text, String ... keyValue) {
        TextViewUtils.setText(Action.GONE, textView, text, keyValue);
    }

    public static void setTextInvisibleWhenNull(TextView textView, String text) {
        TextViewUtils.setTextInvisibleWhenNull(textView, text, text);
    }

    public static void setTextInvisibleWhenNull(TextView textView, String text, String ... keyValue) {
        TextViewUtils.setText(Action.INVISIBLE, textView, text, keyValue);
    }

    private static void setText(Action action, TextView textView, String text, String ... keyValue) {
        if (textView == null) {
            return;
        }
        if (keyValue == null || TextUtils.isEmpty((CharSequence)text)) {
            TextViewUtils.doAction(textView, action);
            return;
        }
        for (int i = 0; i < keyValue.length; ++i) {
            if (!TextUtils.isEmpty((CharSequence)keyValue[i])) continue;
            TextViewUtils.doAction(textView, action);
            return;
        }
        textView.setVisibility(0);
        textView.setText((CharSequence)text);
    }

    private static void doAction(TextView textView, Action action) {
        if (action == Action.GONE) {
            textView.setVisibility(8);
        } else {
            textView.setVisibility(4);
        }
    }

    private static enum Action {
        GONE,
        INVISIBLE;

    }
}

