/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.IBinder;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.ViewConfiguration;
import android.view.Window;
import android.view.WindowManager;
import com.run.utils.config.GlobalConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;

public class SystemUtil {
    public static final String META_CHANNEL = "CHANNEL";
    public static final String MEATA_BUILD_VERSION = "BUILD_VERSION";
    private static final String BUILD_PROP_FILE = "/system/build.prop";
    private static final String PROP_NAME_MIUI_VERSION_CODE = "ro.miui.ui.version.code";
    private static String packageVersionName = null;
    private static int versionCode = 0;

    private SystemUtil() {
    }

    public static boolean aboveApiLevel(int sdkInt) {
        return SystemUtil.getApiLevel() >= sdkInt;
    }

    public static int getApiLevel() {
        return Build.VERSION.SDK_INT;
    }

    public static boolean isBlur() {
        try {
            return Build.BRAND.toLowerCase().contains("blur");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isZTE() {
        try {
            return Build.BRAND.toLowerCase().contains("zte");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isGalaxyS2() {
        try {
            String lowerCaseModel = Build.MODEL.toLowerCase();
            return lowerCaseModel.contains("gt-i9100") || lowerCaseModel.contains("gt-i9108") || lowerCaseModel.contains("gt-i9103");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isNexusS() {
        try {
            String lowerCaseModel = Build.MODEL.toLowerCase();
            return lowerCaseModel.contains("nexus s");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isKindleFire() {
        try {
            return Build.MODEL.toLowerCase().contains("kindle fire");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isMIUI() {
        File buildPropFile = new File(BUILD_PROP_FILE);
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(buildPropFile));
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith(PROP_NAME_MIUI_VERSION_CODE)) continue;
                return true;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isSDCardMounted() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static boolean isExternalSDCardMounted() {
        if (Build.VERSION.SDK_INT < 11) {
            return "mounted".equals(Environment.getExternalStorageState());
        }
        return "mounted".equals(Environment.getExternalStorageState()) && !Environment.isExternalStorageEmulated();
    }

    public static String getMacAddress(Context context) {
        WifiManager wifi = (WifiManager)context.getSystemService("wifi");
        if (wifi == null) {
            return null;
        }
        WifiInfo info = null;
        try {
            info = wifi.getConnectionInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (info != null) {
            return info.getMacAddress();
        }
        return null;
    }

    public static String getWifiIPAddress(Context context) {
        try {
            WifiManager mgr = (WifiManager)context.getSystemService("wifi");
            if (mgr == null) {
                return null;
            }
            WifiInfo info = mgr.getConnectionInfo();
            if (info == null) {
                return null;
            }
            int ipAddress = info.getIpAddress();
            if (ipAddress == 0) {
                return null;
            }
            String ip = String.format(Locale.US, "%d.%d.%d.%d", ipAddress & 0xFF, ipAddress >> 8 & 0xFF, ipAddress >> 16 & 0xFF, ipAddress >> 24 & 0xFF);
            return ip;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getSecureAndroidID(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public static String getSdkVersion() {
        try {
            return Build.VERSION.SDK;
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.valueOf(SystemUtil.getSdkVersionInt());
        }
    }

    public static String getSdkReleaseVersion() {
        try {
            return Build.VERSION.RELEASE;
        }
        catch (Exception e) {
            e.printStackTrace();
            return SystemUtil.getSdkVersion();
        }
    }

    public static int getSdkVersionInt() {
        try {
            return Build.VERSION.SDK_INT;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static long getAvailableExternalStorage() {
        try {
            StatFs sdFs;
            File file = Environment.getExternalStorageDirectory();
            if (file != null && file.exists() && (sdFs = new StatFs(file.getPath())) != null) {
                long sdBlockSize = sdFs.getBlockSize();
                long sdAvailCount = sdFs.getAvailableBlocks();
                return sdAvailCount * sdBlockSize;
            }
            return 0L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static long getTotalExternalMemorySize() {
        try {
            StatFs sdFs;
            File file = Environment.getExternalStorageDirectory();
            if (file != null && file.exists() && (sdFs = new StatFs(file.getPath())) != null) {
                long sdBlockSize = sdFs.getBlockSize();
                long sdTotalCount = sdFs.getBlockCount();
                return sdTotalCount * sdBlockSize;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public static long getAvailableInternalStorage() {
        StatFs sdFs;
        File file = Environment.getDataDirectory();
        if (file != null && file.exists() && (sdFs = new StatFs(file.getPath())) != null) {
            long sdBlockSize = sdFs.getBlockSize();
            long sdAvailCount = sdFs.getAvailableBlocks();
            return sdAvailCount * sdBlockSize;
        }
        return 0L;
    }

    public static long getTotalInternalMemorySize() {
        File path = Environment.getDataDirectory();
        if (path != null && path.exists()) {
            StatFs stat = new StatFs(path.getPath());
            long blockSize = stat.getBlockSize();
            long totalBlocks = stat.getBlockCount();
            return totalBlocks * blockSize;
        }
        return 0L;
    }

    public static boolean checkSdCardStatusOk() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    public static boolean checkAvailableInternalStorage(long size) {
        long availabelStorage = SystemUtil.getAvailableInternalStorage();
        if (size < 0L) {
            return true;
        }
        if (availabelStorage <= 0L) {
            return false;
        }
        return availabelStorage >= size;
    }

    public static boolean checkAvailableExternalStorage(long size) {
        long availabelStorage = SystemUtil.getAvailableExternalStorage();
        if (size < 0L) {
            return true;
        }
        if (availabelStorage <= 0L) {
            return false;
        }
        return availabelStorage >= size;
    }

    public static boolean checkSpaceEnough(String path, InstallOption installOpition) {
        if (TextUtils.isEmpty((CharSequence)path) || installOpition == null) {
            return false;
        }
        if (installOpition == InstallOption.AUTO) {
            return true;
        }
        File file = new File(path);
        if (installOpition == InstallOption.INTERNAL) {
            return SystemUtil.checkAvailableInternalStorage(file.length());
        }
        if (installOpition == InstallOption.EXTERNAL) {
            return SystemUtil.checkAvailableStorage(file.length());
        }
        return false;
    }

    public static boolean checkAvailableStorage(long size) {
        long availabelStorage = SystemUtil.getAvailableExternalStorage();
        if (size < 0L) {
            return true;
        }
        if (availabelStorage <= 0L) {
            return false;
        }
        return availabelStorage >= size;
    }

    public static int getVersionCode(Context context) {
        if (versionCode != 0) {
            return versionCode;
        }
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            versionCode = packageInfo.versionCode;
            return versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static void sleepZero() {
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static String getNonNullModel() {
        if (TextUtils.isEmpty((CharSequence)Build.MODEL)) {
            return "";
        }
        return Build.MODEL;
    }

    public static IBinder invokeGetService(String name) {
        IBinder binder;
        Method method;
        try {
            method = Class.forName("android.os.ServiceManager").getMethod("getService", String.class);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        try {
            binder = (IBinder)method.invoke(null, name);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
        return binder;
    }

    @TargetApi(value=8)
    public static File getDeviceExternalCacheDir() {
        Context context = GlobalConfig.getAppContext();
        if (Build.VERSION.SDK_INT >= 8) {
            return context.getExternalCacheDir();
        }
        return new File(Environment.getExternalStorageDirectory() + "/Android/data/" + context.getPackageName() + "/cache/");
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getImei(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            return telephonyManager.getDeviceId();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getVersionName(Context context) {
        if (packageVersionName == null) {
            PackageInfo packageInfo = SystemUtil.getPackageInfo(context, context.getPackageName(), 0);
            packageVersionName = packageInfo != null ? packageInfo.versionName : "";
        }
        return packageVersionName;
    }

    public static String getFullVersion() {
        return SystemUtil.getVersionName(GlobalConfig.getAppContext()) + "." + SystemUtil.getVersionCode(GlobalConfig.getAppContext());
    }

    public static PackageInfo getPackageInfo(Context context, String packageName, int flag) {
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packageInfo = null;
        try {
            packageInfo = packageManager.getPackageInfo(packageName, flag);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return packageInfo;
    }

    @TargetApi(value=9)
    public static boolean isPrimaryExternalStorageRemoveable() {
        if (SystemUtil.getApiLevel() >= 9) {
            return Environment.isExternalStorageRemovable();
        }
        return true;
    }

    public static int getScreentHeight(WindowManager windowManager) {
        int heightPixels = 0;
        Display defaultDisplay = windowManager.getDefaultDisplay();
        if (SystemUtil.aboveApiLevel(14) && !SystemUtil.aboveApiLevel(17)) {
            try {
                heightPixels = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)defaultDisplay, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (SystemUtil.aboveApiLevel(17)) {
            Point realSize = new Point();
            defaultDisplay.getRealSize(realSize);
            heightPixels = realSize.y;
        } else {
            DisplayMetrics metrics = new DisplayMetrics();
            defaultDisplay.getMetrics(metrics);
            heightPixels = metrics.heightPixels;
        }
        return heightPixels;
    }

    public static int getScreentWidth(WindowManager windowManager) {
        int widthPixels = 0;
        Display defaultDisplay = windowManager.getDefaultDisplay();
        if (SystemUtil.aboveApiLevel(14) && !SystemUtil.aboveApiLevel(17)) {
            try {
                widthPixels = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)defaultDisplay, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (SystemUtil.aboveApiLevel(17)) {
            Point realSize = new Point();
            defaultDisplay.getRealSize(realSize);
            widthPixels = realSize.x;
        } else {
            DisplayMetrics metrics = new DisplayMetrics();
            defaultDisplay.getMetrics(metrics);
            widthPixels = metrics.widthPixels;
        }
        return widthPixels;
    }

    public static String getResolution() {
        WindowManager wm = (WindowManager)GlobalConfig.getAppContext().getSystemService("window");
        int w = SystemUtil.getScreentWidth(wm);
        int h = SystemUtil.getScreentHeight(wm);
        StringBuilder sb = new StringBuilder();
        sb.append(w).append("*").append(h);
        return sb.toString();
    }

    public static boolean hasSoftKeys(Context context) {
        if (Build.VERSION.SDK_INT >= 14) {
            return !ViewConfiguration.get((Context)context).hasPermanentMenuKey();
        }
        return false;
    }

    public static boolean isRooted() {
        boolean rooted = false;
        boolean hasSuFile = false;
        String command = "ls -l /%s/su";
        File su = new File("/system/bin/su");
        if (su.exists()) {
            hasSuFile = true;
            command = String.format(command, "system/bin");
        } else {
            su = new File("/system/xbin/su");
            if (su.exists()) {
                hasSuFile = true;
                command = String.format(command, "system/xbin");
            } else {
                su = new File("/data/bin/su");
                if (su.exists()) {
                    hasSuFile = true;
                    command = String.format(command, "data/bin");
                }
            }
        }
        if (hasSuFile) {
            rooted = true;
        }
        return rooted;
    }

    public static String getWifiSSID(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        if (wifiManager == null) {
            return null;
        }
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        if (wifiInfo == null) {
            return null;
        }
        String ssid = wifiInfo.getSSID();
        if (ssid != null && ssid.startsWith("\"") && ssid.endsWith("\"")) {
            ssid = ssid.substring(1, ssid.length() - 1);
        }
        return ssid;
    }

    public static String getSystemDisplayId() {
        if (TextUtils.isEmpty((CharSequence)Build.DISPLAY)) {
            return "";
        }
        return Build.DISPLAY;
    }

    public static String getBrand() {
        if (TextUtils.isEmpty((CharSequence)Build.BRAND)) {
            return "";
        }
        return Build.BRAND;
    }

    @TargetApi(value=4)
    public static int getMetricsSize(WindowManager windowManager) {
        if (windowManager == null) {
            return 0;
        }
        DisplayMetrics metrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(metrics);
        return metrics.densityDpi;
    }

    @TargetApi(value=4)
    public static String getDpi(WindowManager windowManager) {
        if (windowManager == null) {
            return "";
        }
        int densityDpi = SystemUtil.getMetricsSize(windowManager);
        switch (densityDpi) {
            case 120: {
                return "ldpi";
            }
            case 160: {
                return "mdpi";
            }
            case 240: {
                return "hdpi";
            }
            case 320: {
                return "xhpdi";
            }
        }
        return "xxhdpi";
    }

    public static String getMetaValue(Context context, String meta_name) {
        String channel = "";
        try {
            Bundle data = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            if (data != null) {
                channel = data.getString(meta_name);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return channel;
    }

    public static int getScreenBrightness() {
        int brightness = -1;
        try {
            brightness = Settings.System.getInt((ContentResolver)GlobalConfig.getAppContext().getContentResolver(), (String)"screen_brightness");
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
        }
        return brightness;
    }

    public static void setScreenBrightness(Activity activity, int brightness) {
        try {
            if (activity == null) {
                return;
            }
            Settings.System.putInt((ContentResolver)GlobalConfig.getAppContext().getContentResolver(), (String)"screen_brightness", (int)brightness);
            Window localWindow = activity.getWindow();
            WindowManager.LayoutParams localLayoutParams = localWindow.getAttributes();
            localLayoutParams.screenBrightness = (float)brightness / 255.0f;
            localWindow.setAttributes(localLayoutParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum InstallOption {
        AUTO,
        EXTERNAL,
        INTERNAL,
        ERROR;

    }
}

