/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.run.utils.config.GlobalConfig;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;

public class NetworkUtil {
    public static final int NETWORK_TYPE_NONE = -1;
    public static final int NETWORK_TYPE_MOBILE = 0;
    public static final int NETWORK_TYPE_WIFI = 1;
    private static boolean reverseProxyOn = false;
    public static final String INTERFACE_WLAN0 = "wlan0";
    private static final String ANDROID_HOTSPOT_IP_ADDRESS = "192.168.43.1";
    private static final String IOS_HOTSPOT_IP_ADDRESS = "172.20.10.1";

    private NetworkUtil() {
    }

    public static boolean isNetworkConnected() {
        if (reverseProxyOn) {
            return true;
        }
        ConnectivityManager connManager = (ConnectivityManager)GlobalConfig.getAppContext().getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = null;
        try {
            activeNetworkInfo = connManager.getActiveNetworkInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    public static NetworkInfo getNetworkInfo(Context context) {
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connManager.getActiveNetworkInfo();
        return activeNetworkInfo;
    }

    public static boolean isMobileNetworkConnected(Context context) {
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connManager.getNetworkInfo(0);
        return networkInfo != null && networkInfo.isConnected();
    }

    public static boolean isWifiConnected(Context context) {
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connManager == null) {
            return false;
        }
        NetworkInfo networkInfo = null;
        try {
            networkInfo = connManager.getNetworkInfo(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    private static InetAddress intToInetAddress(int hostAddress) {
        InetAddress inetAddress = null;
        byte[] addressBytes = new byte[]{(byte)(0xFF & hostAddress), (byte)(0xFF & hostAddress >> 8), (byte)(0xFF & hostAddress >> 16), (byte)(0xFF & hostAddress >> 24)};
        try {
            inetAddress = InetAddress.getByAddress(addressBytes);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return inetAddress;
    }

    public static boolean checkWifiIsHotSpot(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        if (wifiManager == null) {
            return false;
        }
        DhcpInfo dhcpInfo = wifiManager.getDhcpInfo();
        if (dhcpInfo == null) {
            return false;
        }
        InetAddress address = NetworkUtil.intToInetAddress(dhcpInfo.gateway);
        if (address == null) {
            return false;
        }
        String currentGateway = address.getHostAddress();
        return TextUtils.equals((CharSequence)currentGateway, (CharSequence)ANDROID_HOTSPOT_IP_ADDRESS) || TextUtils.equals((CharSequence)currentGateway, (CharSequence)IOS_HOTSPOT_IP_ADDRESS);
    }

    public static boolean isReverseProxyOn() {
        return reverseProxyOn;
    }

    public static void setUsbReverseProxyState(boolean proxyOn) {
        reverseProxyOn = proxyOn;
    }

    public static int getNetworkType() {
        NetworkInfo networkInfo;
        ConnectivityManager connManager = (ConnectivityManager)GlobalConfig.getAppContext().getSystemService("connectivity");
        try {
            networkInfo = connManager.getActiveNetworkInfo();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return -1;
        }
        return NetworkUtil.parseNetworkType(networkInfo);
    }

    public static int parseNetworkType(NetworkInfo networkInfo) {
        if (networkInfo == null || !networkInfo.isConnected()) {
            return -1;
        }
        if (networkInfo.getType() == 0) {
            return 0;
        }
        return 1;
    }

    public static String getNetworkTypeName(Context context) {
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connManager == null) {
            return null;
        }
        try {
            NetworkInfo networkInfo = connManager.getActiveNetworkInfo();
            return NetworkUtil.getNetworkTypeName(context, networkInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getNetworkTypeName(Context context, NetworkInfo networkInfo) {
        if (networkInfo == null) {
            if (reverseProxyOn) {
                return "PC";
            }
        } else {
            if (networkInfo.getType() == 0) {
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                return NetworkUtil.getNetworkTypeName(telephonyManager.getNetworkType());
            }
            return "WIFI";
        }
        return null;
    }

    private static String getNetworkTypeName(int type) {
        switch (type) {
            case 1: {
                return "GPRS";
            }
            case 2: {
                return "EDGE";
            }
            case 3: {
                return "UMTS";
            }
            case 8: {
                return "HSDPA";
            }
            case 9: {
                return "HSUPA";
            }
            case 10: {
                return "HSPA";
            }
            case 4: {
                return "CDMA";
            }
            case 5: {
                return "CDMA - EvDo rev. 0";
            }
            case 6: {
                return "CDMA - EvDo rev. A";
            }
            case 12: {
                return "CDMA - EvDo rev. B";
            }
            case 7: {
                return "CDMA - 1xRTT";
            }
            case 13: {
                return "LTE";
            }
            case 14: {
                return "CDMA - eHRPD";
            }
            case 11: {
                return "iDEN";
            }
            case 15: {
                return "HSPA+";
            }
        }
        return "UNKNOWN";
    }

    public static String getIPv4Address() {
        return NetworkUtil.getIPAddress(true);
    }

    public static String getIPv6Address() {
        return NetworkUtil.getIPAddress(false);
    }

    public static String getIPAddress(boolean useIPv4) {
        return "";
    }

    public static String getProxyHost() {
        if (Build.VERSION.SDK_INT >= 9) {
            return System.getProperty("http.proxyHost");
        }
        return Proxy.getDefaultHost();
    }

    public static int getProxyPort() {
        if (Build.VERSION.SDK_INT >= 9) {
            return Integer.valueOf(System.getProperty("http.proxyPort"));
        }
        return Integer.valueOf(Proxy.getDefaultHost());
    }

    public static String getMacAddress() {
        String macAddress = null;
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            Iterator iterator = interfaces.iterator();
            if (iterator.hasNext()) {
                NetworkInterface intf = (NetworkInterface)iterator.next();
                byte[] mac = intf.getHardwareAddress();
                macAddress = NetworkUtil.convertMacAddress(mac);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (TextUtils.isEmpty(macAddress)) {
            return NetworkUtil.getWifiMacAddress(GlobalConfig.getAppContext());
        }
        return macAddress;
    }

    private static String convertMacAddress(byte[] mac) {
        if (mac == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int idx = 0; idx < mac.length; ++idx) {
            buf.append(String.format("%02X:", mac[idx]));
        }
        if (buf.length() > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        if (buf.length() != 12 && buf.length() != 17) {
            return null;
        }
        return buf.toString();
    }

    private static String getWifiMacAddress(Context ctx) {
        WifiManager manager = null;
        try {
            manager = (WifiManager)ctx.getSystemService("wifi");
            if (manager == null || manager.getConnectionInfo() == null) {
                return null;
            }
            Enumeration<NetworkInterface> interfaces = null;
            interfaces = NetworkInterface.getNetworkInterfaces();
            int wifiIP = manager.getConnectionInfo().getIpAddress();
            int reverseWifiIP = Integer.reverseBytes(wifiIP);
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = iface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress nextElement = inetAddresses.nextElement();
                    int byteArrayToInt = NetworkUtil.byteArrayToInt(nextElement.getAddress(), 0);
                    if (byteArrayToInt != wifiIP && byteArrayToInt != reverseWifiIP) continue;
                    byte[] mac = iface.getHardwareAddress();
                    return NetworkUtil.convertMacAddress(mac);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static final int byteArrayToInt(byte[] arr, int offset) {
        if (arr == null || arr.length - offset < 4) {
            return -1;
        }
        int r0 = (arr[offset] & 0xFF) << 24;
        int r1 = (arr[offset + 1] & 0xFF) << 16;
        int r2 = (arr[offset + 2] & 0xFF) << 8;
        int r3 = arr[offset + 3] & 0xFF;
        return r0 + r1 + r2 + r3;
    }
}

