/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.widget.Toast;
import com.run.utils.ToastUtils;
import com.run.utils.config.GlobalConfig;

public class MainThreadPostUtils {
    private static final int MESSAGE_TOAST = 1001;
    private static final int MESSAGE_TOAST_LONG = 1002;
    private static final int MESSAGE_SHORT_TOAST_IN_CENTER = 1003;
    private static Handler handler;
    private static byte[] handlerLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Handler getHandler() {
        byte[] byArray = handlerLock;
        synchronized (handlerLock) {
            if (handler == null) {
                handler = new Handler(Looper.getMainLooper()){

                    public void handleMessage(Message msg) {
                        switch (msg.what) {
                            case 1001: {
                                Toast.makeText((Context)GlobalConfig.getAppContext(), (CharSequence)msg.obj.toString(), (int)0).show();
                                break;
                            }
                            case 1002: {
                                Toast.makeText((Context)GlobalConfig.getAppContext(), (CharSequence)msg.obj.toString(), (int)1).show();
                                break;
                            }
                            case 1003: {
                                MainThreadPostUtils.showToastWithCustomView((View)msg.obj);
                                break;
                            }
                        }
                    }
                };
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return handler;
        }
    }

    public static void post(Runnable run) {
        MainThreadPostUtils.getHandler().post(run);
    }

    public static void postAtFrontOfQueue(Runnable run) {
        MainThreadPostUtils.getHandler().postAtFrontOfQueue(run);
    }

    public static void postDelayed(Runnable run, long delayMillis) {
        MainThreadPostUtils.getHandler().postDelayed(run, delayMillis);
    }

    public static void toast(final String message) {
        if (!TextUtils.isEmpty((CharSequence)message)) {
            if (!Thread.currentThread().getName().equals(Looper.getMainLooper().getThread().getName())) {
                MainThreadPostUtils.post(new Runnable(){

                    @Override
                    public void run() {
                        ToastUtils.showShortToast(message);
                    }
                });
            } else {
                ToastUtils.showShortToast(message);
            }
        }
    }

    public static void toastLong(final String message) {
        if (!TextUtils.isEmpty((CharSequence)message)) {
            if (!Thread.currentThread().getName().equals(Looper.getMainLooper().getThread().getName())) {
                MainThreadPostUtils.post(new Runnable(){

                    @Override
                    public void run() {
                        ToastUtils.showLongToast(message);
                    }
                });
            } else {
                ToastUtils.showLongToast(message);
            }
        }
    }

    public static void toastCustomViewInCenter(View v) {
        if (v != null) {
            Message msg = MainThreadPostUtils.getHandler().obtainMessage(1003, (Object)v);
            msg.sendToTarget();
        }
    }

    public static void toast(int res) {
        final String msg = GlobalConfig.getAppContext().getString(res);
        if (!Thread.currentThread().getName().equals(Looper.getMainLooper().getThread().getName())) {
            MainThreadPostUtils.post(new Runnable(){

                @Override
                public void run() {
                    ToastUtils.showShortToast(msg);
                }
            });
        } else {
            ToastUtils.showShortToast(msg);
        }
    }

    public static void toastLong(int res) {
        final String msg = GlobalConfig.getAppContext().getString(res);
        MainThreadPostUtils.toastLong(msg);
        if (!Thread.currentThread().getName().equals(Looper.getMainLooper().getThread().getName())) {
            MainThreadPostUtils.post(new Runnable(){

                @Override
                public void run() {
                    ToastUtils.showLongToast(msg);
                }
            });
        } else {
            ToastUtils.showLongToast(msg);
        }
    }

    public static void showToastWithCustomView(View v) {
        Toast toast = new Toast(GlobalConfig.getAppContext());
        toast.setGravity(17, 0, 0);
        toast.setView(v);
        toast.setDuration(0);
        toast.show();
    }

    public static void cancel(Runnable r) {
        MainThreadPostUtils.getHandler().removeCallbacks(r);
    }

    static {
        handlerLock = new byte[0];
    }
}

