/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.util.Log;
import com.run.utils.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LibraryLoaderHelper {
    private static final String TAG = "LibraryLoaderHelper";
    private static final String LIB_DIR = "lib_so";
    private static List<String> loadedLibNames = new ArrayList<String>();

    public static synchronized boolean loadLibrarySafety(Context context, String library) {
        if (loadedLibNames.contains(library)) {
            return true;
        }
        File libFile = LibraryLoaderHelper.getWorkaroundLibFile(context, library);
        try {
            System.loadLibrary(library);
            loadedLibNames.add(library);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            Log.e((String)TAG, (String)"loadLibrarySafety normal way error ", (Throwable)e);
            if (!libFile.exists() && !LibraryLoaderHelper.unpackLibrariesOnce(context, library)) {
                Log.d((String)TAG, (String)"loadLibrarySafety unpackLibrariesOnce fail ");
                throw e;
            }
            try {
                System.load(libFile.getAbsolutePath());
                loadedLibNames.add(library);
                return true;
            }
            catch (UnsatisfiedLinkError e2) {
                Log.e((String)TAG, (String)"loadLibrarySafety in apk fail ", (Throwable)e2);
                throw e2;
            }
        }
    }

    private static File getWorkaroundLibDir(Context context) {
        File file = new File(context.getFilesDir(), LIB_DIR);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    private static File getWorkaroundLibFile(Context context, String library) {
        String libName = System.mapLibraryName(library);
        return new File(LibraryLoaderHelper.getWorkaroundLibDir(context), libName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unpackLibrariesOnce(Context context, String libName) {
        File libDir = LibraryLoaderHelper.getWorkaroundLibDir(context);
        LibraryLoaderHelper.deleteDirectorySync(libDir);
        ZipFile file = null;
        InputStream is = null;
        FileOutputStream os = null;
        try {
            ApplicationInfo appInfo = context.getApplicationInfo();
            file = new ZipFile(new File(appInfo.sourceDir), 1);
            String jniNameInApk = "lib/" + Build.CPU_ABI + "/" + System.mapLibraryName(libName);
            ZipEntry entry = file.getEntry(jniNameInApk);
            if (entry == null) {
                Log.e((String)TAG, (String)(appInfo.sourceDir + " doesn't have file " + jniNameInApk));
                int lineCharIndex = Build.CPU_ABI.indexOf(45);
                jniNameInApk = "lib/" + Build.CPU_ABI.substring(0, lineCharIndex > 0 ? lineCharIndex : Build.CPU_ABI.length()) + "/" + System.mapLibraryName(libName);
                entry = file.getEntry(jniNameInApk);
                if (entry == null) {
                    Log.e((String)TAG, (String)(appInfo.sourceDir + " doesn't have file " + jniNameInApk));
                    file.close();
                    LibraryLoaderHelper.deleteDirectorySync(libDir);
                    boolean bl = false;
                    return bl;
                }
            }
            File outputFile = LibraryLoaderHelper.getWorkaroundLibFile(context, libName);
            Log.i((String)TAG, (String)("Extracting native libraries into " + outputFile.getAbsolutePath()));
            if (!outputFile.createNewFile()) {
                boolean bl = false;
                return bl;
            }
            is = file.getInputStream(entry);
            os = new FileOutputStream(outputFile);
            int count = 0;
            byte[] buffer = new byte[16384];
            while ((count = is.read(buffer)) > 0) {
                os.write(buffer, 0, count);
            }
            FileUtil.setPermissions(outputFile.getAbsolutePath(), 493);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Failed to unpack native libraries", (Throwable)e);
            LibraryLoaderHelper.deleteDirectorySync(libDir);
            boolean bl = false;
            return bl;
        }
        catch (NoSuchMethodError e2) {
            e2.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (is != null) {
                    is.close();
                }
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void deleteDirectorySync(File dir) {
        try {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    String fileName = file.getName();
                    if (file.delete()) continue;
                    Log.e((String)TAG, (String)("Failed to remove " + file.getAbsolutePath()));
                }
            }
            if (!dir.delete()) {
                Log.w((String)TAG, (String)("Failed to remove " + dir.getAbsolutePath()));
            }
            return;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to remove old libs, ", (Throwable)e);
            return;
        }
    }
}

