/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import com.run.utils.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class GZipUtil {
    private static final int BUFFER_SIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zipBytes(byte[] bytes) {
        byte[] byArray;
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bais = null;
        ByteArrayOutputStream baos = null;
        GZIPOutputStream gzout = null;
        try {
            int count;
            bais = new ByteArrayInputStream(bytes);
            baos = new ByteArrayOutputStream();
            gzout = new GZIPOutputStream(baos);
            byte[] buffer = new byte[1024];
            while ((count = bais.read(buffer, 0, 1024)) != -1) {
                gzout.write(buffer, 0, count);
            }
            gzout.close();
            byArray = baos.toByteArray();
        }
        catch (IOException e) {
            byte[] byArray2;
            try {
                e.printStackTrace();
                byArray2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.close(bais);
                IOUtils.close(baos);
                IOUtils.close(gzout);
                throw throwable;
            }
            IOUtils.close(bais);
            IOUtils.close(baos);
            IOUtils.close(gzout);
            return byArray2;
        }
        IOUtils.close(bais);
        IOUtils.close(baos);
        IOUtils.close(gzout);
        return byArray;
    }

    public static void zip(InputStream input, OutputStream output) {
        try {
            int readed;
            GZIPOutputStream gzout = new GZIPOutputStream(output);
            byte[] buffer = new byte[1024];
            while ((readed = input.read(buffer)) != -1) {
                gzout.write(buffer, 0, readed);
            }
            gzout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

