/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.util.Pair;
import java.util.LinkedList;
import java.util.ListIterator;

public class DeferredHandler {
    private LinkedList<Pair<Runnable, Integer>> mQueue = new LinkedList();
    private MessageQueue mMessageQueue = Looper.myQueue();
    private Impl mHandler = new Impl();

    public void post(Runnable runnable) {
        this.post(runnable, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Runnable runnable, int type) {
        LinkedList<Pair<Runnable, Integer>> linkedList = this.mQueue;
        synchronized (linkedList) {
            this.mQueue.add((Pair<Runnable, Integer>)new Pair((Object)runnable, (Object)type));
            if (this.mQueue.size() == 1) {
                this.scheduleNextLocked();
            }
        }
    }

    public void postIdle(Runnable runnable) {
        this.postIdle(runnable, 0);
    }

    public void postIdle(Runnable runnable, int type) {
        this.post(new IdleRunnable(runnable), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRunnable(Runnable runnable) {
        LinkedList<Pair<Runnable, Integer>> linkedList = this.mQueue;
        synchronized (linkedList) {
            while (this.mQueue.remove(runnable)) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllRunnablesOfType(int type) {
        LinkedList<Pair<Runnable, Integer>> linkedList = this.mQueue;
        synchronized (linkedList) {
            ListIterator iter = this.mQueue.listIterator();
            while (iter.hasNext()) {
                Pair p = (Pair)iter.next();
                if ((Integer)p.second != type) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        LinkedList<Pair<Runnable, Integer>> linkedList = this.mQueue;
        synchronized (linkedList) {
            this.mQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        LinkedList<Pair<Runnable, Integer>> queue = new LinkedList<Pair<Runnable, Integer>>();
        LinkedList<Pair<Runnable, Integer>> linkedList = this.mQueue;
        synchronized (linkedList) {
            queue.addAll(this.mQueue);
            this.mQueue.clear();
        }
        for (Pair pair : queue) {
            ((Runnable)pair.first).run();
        }
    }

    void scheduleNextLocked() {
        if (this.mQueue.size() > 0) {
            Pair<Runnable, Integer> p = this.mQueue.getFirst();
            Runnable peek = (Runnable)p.first;
            if (peek instanceof IdleRunnable) {
                this.mMessageQueue.addIdleHandler((MessageQueue.IdleHandler)this.mHandler);
            } else {
                this.mHandler.sendEmptyMessage(1);
            }
        }
    }

    private class IdleRunnable
    implements Runnable {
        Runnable mRunnable;

        IdleRunnable(Runnable r) {
            this.mRunnable = r;
        }

        @Override
        public void run() {
            this.mRunnable.run();
        }
    }

    private class Impl
    extends Handler
    implements MessageQueue.IdleHandler {
        private Impl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            Runnable r;
            LinkedList linkedList = DeferredHandler.this.mQueue;
            synchronized (linkedList) {
                if (DeferredHandler.this.mQueue.size() == 0) {
                    return;
                }
                Pair p = (Pair)DeferredHandler.this.mQueue.removeFirst();
                r = (Runnable)p.first;
            }
            r.run();
            linkedList = DeferredHandler.this.mQueue;
            synchronized (linkedList) {
                DeferredHandler.this.scheduleNextLocked();
            }
        }

        public boolean queueIdle() {
            this.handleMessage(null);
            return false;
        }
    }
}

