/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CollectionUtils {
    public static <T> List<T> replaceFromPosition(List<T> origin, List<T> newPart, int pos) {
        if (origin == null || origin.isEmpty()) {
            return newPart;
        }
        if (newPart == null || newPart.isEmpty()) {
            return origin;
        }
        if (pos > origin.size()) {
            pos = origin.size();
        }
        ArrayList<T> result = new ArrayList<T>(origin);
        int newSize = pos + newPart.size();
        result.addAll(pos, newPart);
        while (result.size() > newSize) {
            result.remove(result.size() - 1);
        }
        return result;
    }

    public static <T> List<T> appendFromPosition(List<T> origin, List<T> newPart, int pos) {
        if (origin == null || origin.isEmpty()) {
            ArrayList<T> result = new ArrayList<T>();
            if (newPart != null) {
                result.addAll(newPart);
            }
            return result;
        }
        if (newPart == null || newPart.isEmpty()) {
            return origin;
        }
        if (pos > origin.size()) {
            pos = origin.size();
        }
        ArrayList<T> result = new ArrayList<T>(origin);
        result.addAll(pos, newPart);
        return result;
    }

    public static <T> boolean isEmpty(Collection<T> list) {
        return list == null || list.isEmpty();
    }

    public static <K, V> boolean isEmpty(Map<K, V> map) {
        return map == null || CollectionUtils.isEmpty(map.keySet());
    }
}

