/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;

public class BitmapUtil {
    public static Bitmap getCropScreenShotBitmap(View rootView, int y, int height) {
        Bitmap bitmap = BitmapUtil.getScreenShotBitmap(rootView);
        if (bitmap != null) {
            Bitmap newBitmap = BitmapUtil.getCropScreenShotBitmap(bitmap, 0, y, bitmap.getWidth(), height);
            return newBitmap;
        }
        return null;
    }

    public static Bitmap getCropScreenShotBitmap(Bitmap bitmap, int x, int y, int width, int height) {
        Bitmap newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)x, (int)y, (int)width, (int)height);
        return newBitmap;
    }

    @TargetApi(value=4)
    public static Bitmap getScreenShotBitmap(View rootView) {
        rootView.setDrawingCacheEnabled(true);
        rootView.buildDrawingCache(true);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)rootView.getDrawingCache());
        rootView.setDrawingCacheEnabled(false);
        return bitmap;
    }

    public static Bitmap getBitmap(ImageView imageView) {
        if (imageView == null) {
            return null;
        }
        Drawable drawable = imageView.getDrawable();
        if (drawable != null && drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        return null;
    }
}

