/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Aug;
import com.rookout.rook.Augs.Locations.HashInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class Augs {
    AugsInFiles augsInFiles = new AugsInFiles();
    AppliedAugs appliedAugs = new AppliedAugs();

    Augs() {
    }

    synchronized void AddAug(Aug aug, String fileName, Integer lineno, HashInfo hashInfo) {
        AugList augList;
        AugsInFile augsInFile = (AugsInFile)this.augsInFiles.get(fileName = fileName.toLowerCase());
        if (null == augsInFile) {
            augsInFile = new AugsInFile();
            this.augsInFiles.put(fileName, augsInFile);
        }
        if (null == (augList = (AugList)augsInFile.get(lineno))) {
            augList = new AugList();
            augsInFile.put(lineno, augList);
        }
        HashedAug hashedAug = new HashedAug();
        hashedAug.aug = aug;
        hashedAug.hashInfo = hashInfo;
        augList.add(hashedAug);
    }

    synchronized AugsSet GetAppliedAugs(String fileName, Integer lineno) {
        LineInFile lineInFile = new LineInFile(fileName, lineno);
        return (AugsSet)this.appliedAugs.get(lineInFile);
    }

    synchronized void AddAppliedAug(Aug aug, String fileName, Integer lineno) {
        LineInFile lineInFile = new LineInFile(fileName, lineno);
        AugsSet set = (AugsSet)this.appliedAugs.get(lineInFile);
        if (set == null) {
            set = new AugsSet();
            set.add(aug);
            this.appliedAugs.put(lineInFile, set);
        } else {
            set.add(aug);
        }
    }

    synchronized AugList GetAugs(String fileName, Integer lineno) {
        AugsInFile augsInFile = (AugsInFile)this.augsInFiles.get(fileName = fileName.toLowerCase());
        if (null != augsInFile && augsInFile.containsKey(lineno)) {
            return (AugList)((AugList)augsInFile.get(lineno)).clone();
        }
        return new AugList();
    }

    synchronized AugsInFile GetAugs(String fileName) {
        AugsInFile augs = (AugsInFile)this.augsInFiles.get(fileName.toLowerCase());
        if (augs == null) {
            return new AugsInFile();
        }
        return (AugsInFile)augs.clone();
    }

    synchronized AugWithFileName RemoveAug(String augId) {
        Aug aug = null;
        String fileName = null;
        Integer lineno = null;
        block0: for (Map.Entry iterator : this.appliedAugs.entrySet()) {
            for (Aug aug2 : (AugsSet)iterator.getValue()) {
                if (!aug2.augId.equals(augId)) continue;
                ((AugsSet)iterator.getValue()).remove(aug2);
                continue block0;
            }
        }
        for (Map.Entry classIterator : this.augsInFiles.entrySet()) {
            block3: for (Map.Entry entry : ((AugsInFile)classIterator.getValue()).entrySet()) {
                for (HashedAug augIterator : (AugList)entry.getValue()) {
                    if (!augIterator.aug.augId.equals(augId)) continue;
                    aug = augIterator.aug;
                    fileName = (String)classIterator.getKey();
                    lineno = (Integer)entry.getKey();
                    continue block3;
                }
            }
        }
        if (null != fileName) {
            AugsInFile augsInFile = (AugsInFile)this.augsInFiles.get(fileName);
            augsInFile.remove(lineno);
            if (((AugsInFile)this.augsInFiles.get(fileName)).isEmpty()) {
                this.augsInFiles.remove(fileName);
            }
        }
        return new AugWithFileName(aug, fileName);
    }

    synchronized boolean HasAugs(String fileName) {
        return this.augsInFiles.containsKey(fileName.toLowerCase());
    }

    synchronized boolean HasAugs(String fileName, int lineno) {
        AugsInFile augsInFile = (AugsInFile)this.augsInFiles.get(fileName.toLowerCase());
        return null != augsInFile && augsInFile.containsKey(lineno);
    }

    synchronized Set<String> AllAugIds() {
        HashSet<String> augIds = new HashSet<String>();
        for (AugsInFile augsInFile : this.augsInFiles.values()) {
            for (AugList augList : augsInFile.values()) {
                for (HashedAug aug : augList) {
                    augIds.add(aug.aug.augId);
                }
            }
        }
        return augIds;
    }

    static class AppliedAugs
    extends HashMap<LineInFile, AugsSet> {
        AppliedAugs() {
        }
    }

    static class AugsSet
    extends HashSet<Aug> {
        AugsSet() {
        }
    }

    public class LineInFile {
        String file_name;
        Integer lineno;

        public LineInFile(String file_name, Integer lineno) {
            this.file_name = file_name;
            this.lineno = lineno;
        }

        public boolean equals(Object obj) {
            return obj instanceof LineInFile && ((LineInFile)obj).lineno.equals(this.lineno) && ((LineInFile)obj).file_name.equals(this.file_name);
        }

        public int hashCode() {
            return this.file_name.hashCode() + this.lineno.hashCode();
        }
    }

    static class AugsInFiles
    extends HashMap<String, AugsInFile> {
        AugsInFiles() {
        }
    }

    static class AugsInFile
    extends HashMap<Integer, AugList> {
        AugsInFile() {
        }
    }

    static class AugList
    extends ArrayList<HashedAug> {
        AugList() {
        }
    }

    public class HashedAug {
        HashInfo hashInfo;
        Aug aug;
    }

    static class AugWithFileName {
        Aug aug;
        String fileName;

        AugWithFileName(Aug aug, String fileName) {
            this.aug = aug;
            this.fileName = fileName;
        }
    }
}

