/*
 * Decompiled with CFR 0.152.
 */
package rook.com.google.common.cache;

import java.util.AbstractMap;
import rook.com.google.common.annotations.GwtCompatible;
import rook.com.google.common.base.Preconditions;
import rook.com.google.common.cache.RemovalCause;
import rook.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
public final class RemovalNotification<K, V>
extends AbstractMap.SimpleImmutableEntry<K, V> {
    private final RemovalCause cause;
    private static final long serialVersionUID = 0L;

    public static <K, V> RemovalNotification<K, V> create(@NullableDecl K key, @NullableDecl V value, RemovalCause cause) {
        return new RemovalNotification<K, V>(key, value, cause);
    }

    private RemovalNotification(@NullableDecl K key, @NullableDecl V value, RemovalCause cause) {
        super(key, value);
        this.cause = Preconditions.checkNotNull(cause);
    }

    public RemovalCause getCause() {
        return this.cause;
    }

    public boolean wasEvicted() {
        return this.cause.wasEvicted();
    }
}

