/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.ComWs.OutputWs;
import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Utils;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import rook.io.netty.util.internal.logging.InternalLogLevel;
import rook.io.netty.util.internal.logging.InternalLogger;
import rook.io.netty.util.internal.logging.InternalLoggerFactory;
import rook.io.netty.util.internal.logging.JdkLoggerFactory;

public class RookLogger {
    private static final int EXCEPTION_MAX_DEPTH = 6;
    private static final int EXCEPTION_MAX_COLLECTION_DEPTH = 4;
    private static final int STACK_DEPTH_OF_CALLER = 2;
    private static RookLogger logger;
    private static ArrayList<LogHandler> handlers;
    private static OutputWs output;
    private static BufferedWriter fileHandle;
    private static SimpleDateFormat dateFormat;
    private int level;

    public static RookLogger Instance() {
        if (null == logger) {
            logger = RookLogger.buildRookLogger();
            RookLogger.OverrideNettyLogger();
        }
        return logger;
    }

    public static void Close() {
        if (fileHandle != null) {
            try {
                fileHandle.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private RookLogger(Level level) {
        this.level = level.intValue();
        dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");
    }

    public static void RegisterOutput(OutputWs output) {
        RookLogger.output = output;
    }

    public static void RemoveOutput(OutputWs output) {
        RookLogger.output = null;
    }

    private static RookLogger buildRookLogger() {
        Level parsedLevel;
        block7: {
            String level = Config.Instance().LoggingConfiguration$LOG_LEVEL;
            Boolean logToStderr = Config.Instance().LoggingConfiguration$LOG_TO_STDERR;
            Boolean logToFile = Config.Instance().LoggingConfiguration$LOG_TO_FILE;
            if (Utils.GetExecutalbePath().contains("worker.org.gradle.process.internal.worker.GradleWorkerMain")) {
                System.out.println("Rook running in test verbosity");
                level = "DEBUG";
                logToStderr = true;
                logToFile = true;
            }
            parsedLevel = RookLogger.getLevel(level);
            handlers = new ArrayList();
            if (logToStderr.booleanValue()) {
                handlers.add(new LogHandler(){

                    @Override
                    public void call(LogRecord logRecord) {
                        System.out.println(RookLogger.getFormatedMessage(logRecord));
                    }
                });
            }
            if (logToFile.booleanValue() && !"".equals(Config.Instance().LoggingConfiguration$FILE_NAME)) {
                try {
                    Path logPath = Paths.get(Config.Instance().LoggingConfiguration$FILE_NAME, new String[0]);
                    if (!logPath.isAbsolute()) {
                        String osName = System.getProperty("os.name").toLowerCase();
                        logPath = osName.contains("mac") ? Paths.get(Utils.getEnv("HOME", "."), Config.Instance().LoggingConfiguration$FILE_NAME) : (osName.contains("win") ? Paths.get(Utils.getEnv("USERPROFILE", "."), Config.Instance().LoggingConfiguration$FILE_NAME) : Paths.get("/var/log", Config.Instance().LoggingConfiguration$FILE_NAME));
                    }
                    if (!Files.exists(logPath.getParent(), new LinkOption[0]) && !logPath.getParent().toFile().mkdirs()) {
                        throw new IOException("Failed to create directory- " + logPath.getParent().toString());
                    }
                    fileHandle = new BufferedWriter(new FileWriter(logPath.toString()));
                    handlers.add(new LogHandler(){

                        @Override
                        public synchronized void call(LogRecord logRecord) {
                            try {
                                if (fileHandle != null) {
                                    fileHandle.write(RookLogger.getFormatedMessage(logRecord));
                                    fileHandle.newLine();
                                    fileHandle.flush();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    if (!Config.Instance().LoggingConfiguration$DEBUG) break block7;
                    System.err.printf("[Rookout] Failed to open log file: (%s)\n", e);
                }
            }
        }
        handlers.add(new LogHandler(){

            @Override
            public void call(LogRecord logRecord) {
                if (null == output) {
                    return;
                }
                if (logRecord.getSourceClassName().startsWith("rook.org.glassfish.tyrus")) {
                    return;
                }
                ContainerNamespace arguments = new ContainerNamespace();
                try {
                    Object[] parameters;
                    Throwable e = logRecord.getThrown();
                    if (null != e) {
                        JavaObjectNamespace.ObjectDumpConfig tailoredDumpConfig = JavaObjectNamespace.ObjectDumpConfig.GetDefaultDumpConfig();
                        tailoredDumpConfig.max_depth = 6;
                        tailoredDumpConfig.max_collection_depth = 4;
                        arguments.WriteAttribute("exc", new JavaObjectNamespace(e, tailoredDumpConfig));
                    }
                    if (null != (parameters = logRecord.getParameters()) && parameters.length > 0) {
                        arguments.WriteAttribute("args", new JavaObjectNamespace(parameters));
                    }
                }
                catch (Exceptions.ToolException e) {
                    // empty catch block
                }
                String formattedMessage = logRecord.getMessage();
                output.SendLogMessage(logRecord.getLevel().intValue(), logRecord.getMillis(), logRecord.getSourceClassName(), logRecord.getSourceMethodName(), formattedMessage, formattedMessage, arguments);
            }
        });
        return new RookLogger(parsedLevel);
    }

    private LogRecord createLogEntry(StackTraceElement stackTraceElement, String msg, Level level, Throwable exception, Object ... args) {
        LogRecord logRecord = new LogRecord(level, String.format(msg, args));
        logRecord.setThrown(exception);
        if (stackTraceElement != null) {
            logRecord.setSourceClassName(stackTraceElement.getClassName());
            logRecord.setSourceMethodName(stackTraceElement.getMethodName());
        }
        if (args != null && args.length > 0) {
            logRecord.setParameters(args);
        }
        return logRecord;
    }

    private static String getFormatedMessage(LogRecord logRecord) {
        return dateFormat.format(new Date()) + " " + logRecord.getMessage();
    }

    private void publish(Level level, String format, Throwable exc, Object ... args) {
        if (level.intValue() < this.level) {
            return;
        }
        LogRecord logRecord = this.createLogEntry(new Throwable().getStackTrace()[2], format, level, exc, args);
        for (LogHandler c : handlers) {
            c.call(logRecord);
        }
    }

    public void log(Level level, String format, Object ... args) {
        this.publish(level, format, null, args);
    }

    public void log(Level level, String format, Throwable exc, Object ... args) {
        this.publish(level, format, exc, args);
    }

    public void log(Level level, String str) {
        this.publish(level, str, null, new Object[0]);
    }

    public void debug(String format, Object ... args) {
        this.publish(Level.FINE, format, null, args);
    }

    public void info(String format, Object ... args) {
        this.publish(Level.INFO, format, null, args);
    }

    public void warn(String format, Object ... args) {
        this.publish(Level.WARNING, format, null, args);
    }

    public void fatal(String format, Object ... args) {
        this.publish(Level.SEVERE, format, null, args);
    }

    private static void OverrideNettyLogger() {
        InternalLoggerFactory.setDefaultFactory(new JdkLoggerFactory(){

            @Override
            public InternalLogger newInstance(String name) {
                return new NettyPseudoLogger();
            }
        });
    }

    private static Level getLevel(String levelName) {
        switch (levelName) {
            case "CRITICAL": 
            case "ERROR": {
                return Level.SEVERE;
            }
            case "WARN": 
            case "WARNING": {
                return Level.WARNING;
            }
            case "INFO": {
                return Level.INFO;
            }
            case "DEBUG": {
                return Level.FINE;
            }
            case "OFF": {
                return Level.OFF;
            }
        }
        return Level.WARNING;
    }

    static class NettyPseudoLogger
    implements InternalLogger {
        NettyPseudoLogger() {
        }

        @Override
        public void trace(String format, Object argA, Object argB) {
        }

        @Override
        public void trace(String format, Object ... arguments) {
        }

        @Override
        public void trace(String msg, Throwable t) {
        }

        @Override
        public void trace(Throwable t) {
        }

        @Override
        public boolean isDebugEnabled() {
            return false;
        }

        @Override
        public void debug(String msg) {
        }

        @Override
        public void debug(String format, Object arg) {
        }

        @Override
        public void debug(String format, Object argA, Object argB) {
        }

        @Override
        public void debug(String format, Object ... arguments) {
        }

        @Override
        public void debug(String msg, Throwable t) {
        }

        @Override
        public void debug(Throwable t) {
        }

        @Override
        public boolean isInfoEnabled() {
            return false;
        }

        @Override
        public void info(String msg) {
        }

        @Override
        public void info(String format, Object arg) {
        }

        @Override
        public void info(String format, Object argA, Object argB) {
        }

        @Override
        public void info(String format, Object ... arguments) {
        }

        @Override
        public void info(String msg, Throwable t) {
        }

        @Override
        public void info(Throwable t) {
        }

        @Override
        public boolean isWarnEnabled() {
            return false;
        }

        @Override
        public void warn(String msg) {
        }

        @Override
        public void warn(String format, Object arg) {
        }

        @Override
        public void warn(String format, Object ... arguments) {
        }

        @Override
        public void warn(String format, Object argA, Object argB) {
        }

        @Override
        public void warn(String msg, Throwable t) {
        }

        @Override
        public void warn(Throwable t) {
        }

        @Override
        public boolean isErrorEnabled() {
            return false;
        }

        @Override
        public void error(String msg) {
        }

        @Override
        public void error(String format, Object arg) {
        }

        @Override
        public void error(String format, Object argA, Object argB) {
        }

        @Override
        public void error(String format, Object ... arguments) {
        }

        @Override
        public void error(String msg, Throwable t) {
        }

        @Override
        public void error(Throwable t) {
        }

        @Override
        public boolean isEnabled(InternalLogLevel level) {
            return false;
        }

        @Override
        public void log(InternalLogLevel level, String msg) {
        }

        @Override
        public void log(InternalLogLevel level, String format, Object arg) {
        }

        @Override
        public void log(InternalLogLevel level, String format, Object argA, Object argB) {
        }

        @Override
        public void log(InternalLogLevel level, String format, Object ... arguments) {
        }

        @Override
        public void log(InternalLogLevel level, String msg, Throwable t) {
        }

        @Override
        public void log(InternalLogLevel level, Throwable t) {
        }

        @Override
        public String name() {
            return "";
        }

        @Override
        public boolean isTraceEnabled() {
            return false;
        }

        @Override
        public void trace(String msg) {
        }

        @Override
        public void trace(String msg, Object afd) {
        }
    }

    public static interface LogHandler {
        public void call(LogRecord var1);
    }
}

