/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.ComWs;

import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import rook.io.netty.buffer.ByteBuf;
import rook.io.netty.buffer.Unpooled;
import rook.io.netty.channel.ChannelHandlerContext;
import rook.io.netty.channel.ChannelPromise;
import rook.io.netty.channel.SimpleChannelInboundHandler;
import rook.io.netty.handler.codec.base64.Base64;
import rook.io.netty.handler.codec.http.DefaultFullHttpRequest;
import rook.io.netty.handler.codec.http.FullHttpRequest;
import rook.io.netty.handler.codec.http.FullHttpResponse;
import rook.io.netty.handler.codec.http.HttpClientCodec;
import rook.io.netty.handler.codec.http.HttpHeaderNames;
import rook.io.netty.handler.codec.http.HttpHeaderValues;
import rook.io.netty.handler.codec.http.HttpHeaders;
import rook.io.netty.handler.codec.http.HttpMethod;
import rook.io.netty.handler.codec.http.HttpObjectAggregator;
import rook.io.netty.handler.codec.http.HttpResponseStatus;
import rook.io.netty.handler.codec.http.HttpScheme;
import rook.io.netty.handler.codec.http.HttpVersion;
import rook.io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import rook.io.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import rook.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import rook.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import rook.io.netty.handler.codec.http.websocketx.WebSocketScheme;
import rook.io.netty.util.CharsetUtil;
import rook.io.netty.util.NetUtil;
import rook.io.netty.util.ReferenceCountUtil;
import rook.io.netty.util.internal.PlatformDependent;

public class WebSocketHandler
extends SimpleChannelInboundHandler<Object> {
    ChannelPromise handshakeFuture;
    private URI uri;
    private HttpHeaders headers;
    private String expectedChallengeResponseString;

    WebSocketHandler(URI uri, HttpHeaders headers) {
        this.uri = uri;
        this.headers = headers;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.handshakeFuture = ctx.newPromise();
        super.handlerAdded(ctx);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.pipeline().addBefore(ctx.name(), "handshake-http-codec", new HttpClientCodec());
        ctx.pipeline().addBefore(ctx.name(), "handshake-http-agg", new HttpObjectAggregator(65536));
        FullHttpRequest r = this.createHandshakeRequest();
        ctx.writeAndFlush(r);
        super.channelActive(ctx);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse response = (FullHttpResponse)msg;
            if (this.handshakeFuture.isDone()) {
                throw new Exception("Unexpected FullHttpResponse (getStatus=" + response.getStatus() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ')');
            }
            this.finishHandshake(ctx, response);
        } else {
            ctx.fireChannelRead(ReferenceCountUtil.retain(msg));
        }
    }

    private void finishHandshake(ChannelHandlerContext ctx, FullHttpResponse response) {
        if (!this.verify(response)) {
            return;
        }
        ctx.pipeline().remove("handshake-http-codec");
        ctx.pipeline().remove("handshake-http-agg");
        ctx.pipeline().addAfter(ctx.name(), "ws-decoder", new WebSocket13FrameDecoder(false, true, 65663, false));
        ctx.pipeline().addAfter(ctx.name(), "ws-encoder", new WebSocket13FrameEncoder(true));
        this.handshakeFuture.setSuccess();
        ctx.fireUserEventTriggered((Object)WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE);
    }

    private FullHttpRequest createHandshakeRequest() throws NoSuchAlgorithmException {
        byte[] nonce = new byte[16];
        PlatformDependent.threadLocalRandom().nextBytes(nonce);
        String key = WebSocketHandler.base64(nonce);
        String acceptSeed = key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        this.expectedChallengeResponseString = WebSocketHandler.base64(WebSocketHandler.sha1(acceptSeed.getBytes(CharsetUtil.US_ASCII)));
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.uri.getPath());
        HttpHeaders requestHeaders = request.headers();
        requestHeaders.add(this.headers);
        requestHeaders.set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (Object)key).set((CharSequence)HttpHeaderNames.HOST, (Object)WebSocketHandler.websocketHostValue(this.uri)).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)"13");
        return request;
    }

    private static String base64(byte[] data) {
        ByteBuf encodedData = Unpooled.wrappedBuffer(data);
        ByteBuf encoded = Base64.encode(encodedData);
        String encodedString = encoded.toString(CharsetUtil.UTF_8);
        encoded.release();
        return encodedString;
    }

    private static byte[] sha1(byte[] input) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA1");
        return digest.digest(input);
    }

    private static CharSequence websocketHostValue(URI wsURL) {
        int port = wsURL.getPort();
        if (port == -1) {
            return wsURL.getHost();
        }
        String host = wsURL.getHost();
        if (port == HttpScheme.HTTP.port()) {
            return HttpScheme.HTTP.name().contentEquals(wsURL.getScheme()) || WebSocketScheme.WS.name().contentEquals(wsURL.getScheme()) ? host : NetUtil.toSocketAddressString(host, port);
        }
        if (port == HttpScheme.HTTPS.port()) {
            return HttpScheme.HTTPS.name().contentEquals(wsURL.getScheme()) || WebSocketScheme.WSS.name().contentEquals(wsURL.getScheme()) ? host : NetUtil.toSocketAddressString(host, port);
        }
        return NetUtil.toSocketAddressString(host, port);
    }

    private boolean verify(FullHttpResponse response) {
        HttpResponseStatus status = HttpResponseStatus.SWITCHING_PROTOCOLS;
        HttpHeaders headers = response.headers();
        if (!response.status().equals(status)) {
            throw new WebSocketHandshakeException("Invalid handshake response getStatus: " + response.status());
        }
        String upgrade = headers.get(HttpHeaderNames.UPGRADE);
        if (!HttpHeaderValues.WEBSOCKET.contentEqualsIgnoreCase(upgrade)) {
            throw new WebSocketHandshakeException("Invalid handshake response upgrade: " + upgrade);
        }
        if (!headers.containsValue(HttpHeaderNames.CONNECTION, HttpHeaderValues.UPGRADE, true)) {
            throw new WebSocketHandshakeException("Invalid handshake response connection: " + headers.get(HttpHeaderNames.CONNECTION));
        }
        String accept = headers.get(HttpHeaderNames.SEC_WEBSOCKET_ACCEPT);
        if (accept == null || !accept.equals(this.expectedChallengeResponseString)) {
            throw new WebSocketHandshakeException(String.format("Invalid challenge. Actual: %s. Expected: %s", accept, this.expectedChallengeResponseString));
        }
        return true;
    }
}

