/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.ComWs;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import rook.io.netty.channel.ChannelHandlerContext;
import rook.io.netty.channel.SimpleChannelInboundHandler;
import rook.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import rook.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import rook.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import rook.io.netty.handler.timeout.IdleState;
import rook.io.netty.handler.timeout.IdleStateEvent;

public class KeepaliveHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private ScheduledFuture future;
    private long timeout;

    KeepaliveHandler(long timeout) {
        this.timeout = timeout;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame msg) {
        if (this.future != null && !this.future.isCancelled()) {
            this.future.cancel(false);
        }
        if (msg instanceof PingWebSocketFrame) {
            PingWebSocketFrame ping = (PingWebSocketFrame)msg;
            ctx.writeAndFlush(new PongWebSocketFrame(ping.content().retain()));
            return;
        }
        ctx.fireChannelRead(msg.retain());
    }

    @Override
    public void userEventTriggered(final ChannelHandlerContext ctx, Object evt) {
        IdleStateEvent idleEvent;
        if (evt instanceof IdleStateEvent && (idleEvent = (IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
            ctx.writeAndFlush(new PingWebSocketFrame());
            this.future = ctx.channel().eventLoop().schedule(new Runnable(){

                @Override
                public void run() {
                    ctx.channel().close();
                }
            }, this.timeout, TimeUnit.SECONDS);
        }
        ctx.fireUserEventTriggered(evt);
    }
}

