/*
 * Decompiled with CFR 0.152.
 */
package org.rookout.java_websocket;

import org.rookout.java_websocket.WebSocket;
import org.rookout.java_websocket.WebSocketListener;
import org.rookout.java_websocket.drafts.Draft;
import org.rookout.java_websocket.exceptions.InvalidDataException;
import org.rookout.java_websocket.framing.Framedata;
import org.rookout.java_websocket.framing.PingFrame;
import org.rookout.java_websocket.framing.PongFrame;
import org.rookout.java_websocket.handshake.ClientHandshake;
import org.rookout.java_websocket.handshake.HandshakeImpl1Server;
import org.rookout.java_websocket.handshake.ServerHandshake;
import org.rookout.java_websocket.handshake.ServerHandshakeBuilder;

public abstract class WebSocketAdapter
implements WebSocketListener {
    private PingFrame pingFrame;

    @Override
    public ServerHandshakeBuilder onWebsocketHandshakeReceivedAsServer(WebSocket conn, Draft draft, ClientHandshake request) throws InvalidDataException {
        return new HandshakeImpl1Server();
    }

    @Override
    public void onWebsocketHandshakeReceivedAsClient(WebSocket conn, ClientHandshake request, ServerHandshake response) throws InvalidDataException {
    }

    @Override
    public void onWebsocketHandshakeSentAsClient(WebSocket conn, ClientHandshake request) throws InvalidDataException {
    }

    @Override
    public void onWebsocketPing(WebSocket conn, Framedata f) {
        try {
            conn.sendFrame(new PongFrame((PingFrame)f));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void onWebsocketPong(WebSocket conn, Framedata f) {
    }

    @Override
    public PingFrame onPreparePing(WebSocket conn) {
        if (this.pingFrame == null) {
            this.pingFrame = new PingFrame();
        }
        return this.pingFrame;
    }
}

