/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services;

import com.rookout.rook.Exceptions;
import com.rookout.rook.PlatformUtils;
import com.rookout.rook.Services.StackTrace.StackTrace;
import java.util.HashMap;

public class Frame {
    public HashMap<String, Object> locals;
    public StackTrace stackTrace;
    static final boolean java9OrAbove = PlatformUtils.isJava9OrAbove();

    public Frame(StackTrace stackTrace, HashMap<String, Object> locals) {
        this.stackTrace = stackTrace;
        this.locals = locals;
    }

    public Frame(Throwable throwable, HashMap<String, Object> locals) {
        this(new StackTrace(throwable), locals);
    }

    public Frame(HashMap<String, Object> locals) throws Exceptions.RookFailedToCollectStacktrace {
        this.stackTrace = new StackTrace(new Throwable());
        this.locals = locals;
        StackTraceElement[] traceback = this.stackTrace.getTraceback();
        for (int i = 0; i < traceback.length; ++i) {
            if (!Frame.isCallbackFrame(traceback[i])) continue;
            this.stackTrace.setBaseFrameIndex(i + 1);
            break;
        }
    }

    public static boolean isCallbackFrame(StackTraceElement frame) {
        if (java9OrAbove) {
            return frame.getClassName().equals("java.security.AccessController") && frame.getMethodName().equals("doPrivileged");
        }
        return frame.getClassName().equals("com.rookout.agent.StaticCallback") && frame.getMethodName().equals("Callback");
    }
}

