/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor.Namespaces;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.FrameNamespace;
import com.rookout.rook.Processor.Namespaces.ListNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.Namespaces.TracebackNamespace;
import com.rookout.rook.Services.Frame;
import com.rookout.rook.Services.StackTrace.StackTrace;
import java.util.ArrayList;
import java.util.HashMap;

public class StackNamespace
extends Namespace {
    private static final int DEFAULT_TRACEBACK_DEPTH = 1000;
    private static final int DEFAULT_FRAMES_DEPTH = 100;
    HashMap<String, Object> locals;
    StackTrace stackTrace;
    StackTraceElement[] stackTraceElements = null;

    public StackNamespace(Frame frame) {
        this.locals = frame.locals;
        this.stackTrace = frame.stackTrace;
    }

    public StackNamespace(StackTrace stackTrace) {
        this.locals = new HashMap();
        this.stackTrace = stackTrace;
    }

    public StackNamespace(StackTraceElement[] stackTraceElements) {
        this.stackTraceElements = stackTraceElements;
        this.locals = new HashMap();
    }

    public StackNamespace(HashMap<String, Object> locals, StackTrace stackTrace) {
        this.locals = locals;
        this.stackTrace = stackTrace;
    }

    @Override
    public Namespace ReadKey(Object key) throws Exceptions.RookFailedToCollectStacktrace {
        return new FrameNamespace(new HashMap<String, Object>(), this.SlowGetFrame((Integer)key));
    }

    @Override
    public Namespace CallMethod(String name, String args) throws Exceptions.ToolException {
        switch (name) {
            case "traceback": {
                return this.Traceback(args);
            }
            case "frames": {
                return this.Frames(args);
            }
        }
        return super.CallMethod(name, args);
    }

    public Namespace Traceback(String args) throws Exceptions.ToolException {
        int depth = 0;
        if (args.length() > 0) {
            try {
                depth = Integer.parseInt(args);
            }
            catch (NumberFormatException e) {
                throw new Exceptions.RookInvalidMethodArguments("traceback()", args);
            }
        } else {
            depth = 1000;
        }
        if (this.stackTraceElements != null) {
            return new TracebackNamespace(this.stackTraceElements, depth);
        }
        return new TracebackNamespace(this.stackTrace, depth);
    }

    public Namespace Frames(String args) throws Exceptions.ToolException {
        int depth = 0;
        if (args.length() > 0) {
            try {
                depth = Integer.parseInt(args);
            }
            catch (NumberFormatException e) {
                throw new Exceptions.RookInvalidMethodArguments("frames()", args);
            }
        } else {
            depth = 100;
        }
        ArrayList<Namespace> result = new ArrayList<Namespace>();
        if (depth > 0) {
            StackTraceElement[] frames = this.GetFrameList(depth);
            result.add(new FrameNamespace(this.locals, frames[0]).CallMethod("dump", ""));
            for (int i = 1; i < frames.length; ++i) {
                result.add(new FrameNamespace(new HashMap<String, Object>(), frames[i]).CallMethod("dump", ""));
            }
        }
        return new ListNamespace(result);
    }

    private StackTraceElement[] GetFrameList(int userMaxDepth) throws Exceptions.RookFailedToCollectStacktrace {
        if (this.stackTraceElements != null) {
            return this.stackTraceElements;
        }
        return this.stackTrace.getTraceback(userMaxDepth);
    }

    private StackTraceElement SlowGetFrame(int i) throws Exceptions.RookFailedToCollectStacktrace {
        if (this.stackTraceElements != null) {
            return this.stackTraceElements[i];
        }
        return this.stackTrace.slowGetFrame(i);
    }
}

