/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.RookLogger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Git {
    private static final String GIT_FOLDER = ".git";
    private static final String GIT_HEAD = "HEAD";
    private static final String GIT_CONFIG = "config";
    private static final Pattern p = Pattern.compile("\\[remote \"origin\"\\]\\s*url\\s*=\\s(\\S*)");

    private static Boolean IsGit(Path path) {
        Path filePath = Paths.get(path.toString(), GIT_FOLDER);
        return Files.exists(filePath, new LinkOption[0]);
    }

    public static String FindRoot(String strPath) {
        Path path = Paths.get(strPath, new String[0]);
        if (Git.IsGit(path).booleanValue()) {
            return path.toString();
        }
        Path parentPath = path.getParent();
        if (parentPath == null || parentPath.equals(path)) {
            return null;
        }
        return Git.FindRoot(parentPath.toString());
    }

    private static String FollowSymLinks(Path root, String link) {
        String[] splitContent;
        String content = "";
        try {
            content = new String(Files.readAllBytes(Paths.get(root.toString(), link)));
        }
        catch (Exception e) {
            RookLogger.Instance().debug("Error reading git information from file system: %s", e.toString());
        }
        if (content.startsWith("ref:") && (splitContent = content.split(" ")).length > 1) {
            String nextLink = splitContent[1].trim();
            return Git.FollowSymLinks(root, nextLink);
        }
        return content.trim();
    }

    public static String GetRevision(String path) {
        return Git.FollowSymLinks(Paths.get(path, GIT_FOLDER), GIT_HEAD);
    }

    public static String GetRemoteOrigin(String path) {
        String content = "";
        try {
            content = new String(Files.readAllBytes(Paths.get(path, GIT_FOLDER, GIT_CONFIG)));
        }
        catch (Exception e) {
            RookLogger.Instance().debug("Error reading git config from file system: %s", e.toString());
        }
        Matcher m = p.matcher(content);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }
}

