/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.ComWs;

import java.util.Date;

public class TokenBucket {
    long lastReset;
    int initialValue;
    int remaining;
    int intervalInSeconds;
    Callable doOnceWhenExhausted;
    boolean doOnceWhenExhaustedPerformed;

    public TokenBucket(int limit, int intervalInSeconds, Callable doOnceWhenExhausted) {
        this.remaining = limit;
        this.initialValue = limit;
        this.intervalInSeconds = intervalInSeconds;
        this.doOnceWhenExhausted = doOnceWhenExhausted;
        this.doOnceWhenExhaustedPerformed = false;
        this.lastReset = new Date().getTime();
    }

    synchronized boolean isExhausted() {
        if (new Date().getTime() - this.lastReset >= (long)(this.intervalInSeconds * 1000)) {
            this.lastReset = new Date().getTime();
            this.remaining = this.initialValue;
            this.doOnceWhenExhaustedPerformed = false;
        }
        return this.remaining < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIfAvailable(Callable func) {
        TokenBucket tokenBucket = this;
        synchronized (tokenBucket) {
            --this.remaining;
            if (this.isExhausted()) {
                if (this.doOnceWhenExhausted != null && !this.doOnceWhenExhaustedPerformed) {
                    this.doOnceWhenExhaustedPerformed = true;
                    this.doOnceWhenExhausted.call();
                }
                return;
            }
        }
        func.call();
    }

    public static interface Callable {
        public void call();
    }
}

