/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Augs;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

class AugRateLimiter {
    private long window_size;
    private long window_quota;
    private final Map<Long, Long> windows = new LinkedHashMap<Long, Long>();

    AugRateLimiter(long window_quota, long window_size) {
        this.window_quota = window_quota;
        this.window_size = window_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Long allow() {
        if (this.window_size == 0L) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        Map<Long, Long> map = this.windows;
        synchronized (map) {
            this.cleanup(now);
        }
        long current_window_key = AugRateLimiter.floorDiv(now, this.window_size) * this.window_size;
        long prev_window_key = current_window_key - this.window_size;
        Long current_window_usage = null;
        Long prev_window_usage = null;
        Map<Long, Long> map2 = this.windows;
        synchronized (map2) {
            current_window_usage = this.windows.get(current_window_key);
            if (current_window_usage == null) {
                current_window_usage = 0L;
                this.windows.put(current_window_key, 0L);
            }
            prev_window_usage = this.windows.get(prev_window_key);
        }
        if (prev_window_usage == null) {
            if (current_window_usage > this.window_quota) {
                return null;
            }
        } else {
            double prev_window_weight = 1.0 - (double)(now - current_window_key) / (double)this.window_size;
            double weighted_usage = (double)prev_window_usage.longValue() * prev_window_weight + (double)current_window_usage.longValue();
            if (weighted_usage > (double)this.window_quota) {
                return null;
            }
        }
        return current_window_key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void record(Long key, long duration) {
        if (this.window_size == 0L || key == null) {
            return;
        }
        Map<Long, Long> map = this.windows;
        synchronized (map) {
            Long total_usage = this.windows.get(key);
            if (total_usage != null) {
                this.windows.put(key, total_usage + duration);
            }
        }
    }

    private void cleanup(long now) {
        if (this.windows.size() > 10) {
            Iterator<Map.Entry<Long, Long>> it = this.windows.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, Long> entry = it.next();
                Long key = entry.getKey();
                if (key >= now - this.window_size * 5L) continue;
                it.remove();
            }
        }
    }

    private static long floorDiv(long x, long y) {
        long r = x / y;
        if ((x ^ y) < 0L && r * y != x) {
            --r;
        }
        return r;
    }
}

