/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.psc.io;

import com.rometools.modules.psc.modules.PodloveSimpleChapterModuleImpl;
import com.rometools.modules.psc.types.SimpleChapter;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleParser;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PodloveSimpleChapterParser
implements ModuleParser {
    private static final Namespace NS = Namespace.getNamespace((String)"http://podlove.org/simple-chapters");

    public String getNamespaceUri() {
        return "http://podlove.org/simple-chapters";
    }

    public Module parse(Element element, Locale locale) {
        Element chaptersElement = element.getChild("chapters", NS);
        if (chaptersElement != null) {
            PodloveSimpleChapterModuleImpl m = new PodloveSimpleChapterModuleImpl();
            List es = chaptersElement.getChildren("chapter", NS);
            if (!es.isEmpty()) {
                LinkedList<SimpleChapter> result = new LinkedList<SimpleChapter>();
                for (Element e : es) {
                    SimpleChapter c = this.parseChapter(e);
                    result.add(c);
                }
                m.setChapters(result);
                return m;
            }
        }
        return null;
    }

    private SimpleChapter parseChapter(Element eChapter) {
        String image;
        String href;
        String title;
        SimpleChapter chapter = new SimpleChapter();
        String start = this.getAttributeValue(eChapter, "start");
        if (start != null) {
            chapter.setStart(start);
        }
        if ((title = this.getAttributeValue(eChapter, "title")) != null) {
            chapter.setTitle(title);
        }
        if ((href = this.getAttributeValue(eChapter, "href")) != null) {
            chapter.setHref(href);
        }
        if ((image = this.getAttributeValue(eChapter, "image")) != null) {
            chapter.setImage(image);
        }
        return chapter;
    }

    protected String getAttributeValue(Element e, String attributeName) {
        Attribute attr = e.getAttribute(attributeName);
        if (attr == null) {
            attr = e.getAttribute(attributeName, NS);
        }
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }
}

