/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.mediarss.io;

import com.rometools.modules.mediarss.MediaEntryModule;
import com.rometools.modules.mediarss.MediaModule;
import com.rometools.modules.mediarss.types.Category;
import com.rometools.modules.mediarss.types.Credit;
import com.rometools.modules.mediarss.types.MediaContent;
import com.rometools.modules.mediarss.types.MediaGroup;
import com.rometools.modules.mediarss.types.Metadata;
import com.rometools.modules.mediarss.types.PlayerReference;
import com.rometools.modules.mediarss.types.Rating;
import com.rometools.modules.mediarss.types.Restriction;
import com.rometools.modules.mediarss.types.Text;
import com.rometools.modules.mediarss.types.Thumbnail;
import com.rometools.modules.mediarss.types.UrlReference;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleGenerator;
import java.util.HashSet;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class MediaModuleGenerator
implements ModuleGenerator {
    private static final Namespace NS = Namespace.getNamespace((String)"media", (String)"http://search.yahoo.com/mrss/");
    private static final Set<Namespace> NAMESPACES = new HashSet<Namespace>();

    public String getNamespaceUri() {
        return "http://search.yahoo.com/mrss/";
    }

    public Set<Namespace> getNamespaces() {
        return NAMESPACES;
    }

    public void generate(Module module, Element element) {
        MediaModule m;
        if (module instanceof MediaModule) {
            m = (MediaModule)module;
            this.generateMetadata(m.getMetadata(), element);
            this.generatePlayer(m.getPlayer(), element);
        }
        if (module instanceof MediaEntryModule) {
            MediaContent[] c;
            MediaGroup[] g;
            m = (MediaEntryModule)module;
            for (MediaGroup element2 : g = m.getMediaGroups()) {
                this.generateGroup(element2, element);
            }
            for (MediaContent element2 : c = m.getMediaContents()) {
                this.generateContent(element2, element);
            }
        }
    }

    public void generateContent(MediaContent c, Element e) {
        Element mc = new Element("content", NS);
        this.addNotNullAttribute(mc, "medium", c.getMedium());
        this.addNotNullAttribute(mc, "channels", c.getAudioChannels());
        this.addNotNullAttribute(mc, "bitrate", c.getBitrate());
        this.addNotNullAttribute(mc, "duration", c.getDuration());
        this.addNotNullAttribute(mc, "expression", c.getExpression());
        this.addNotNullAttribute(mc, "fileSize", c.getFileSize());
        this.addNotNullAttribute(mc, "framerate", c.getFramerate());
        this.addNotNullAttribute(mc, "height", c.getHeight());
        this.addNotNullAttribute(mc, "lang", c.getLanguage());
        this.addNotNullAttribute(mc, "samplingrate", c.getSamplingrate());
        this.addNotNullAttribute(mc, "type", c.getType());
        this.addNotNullAttribute(mc, "width", c.getWidth());
        if (c.isDefaultContent()) {
            this.addNotNullAttribute(mc, "isDefault", "true");
        }
        if (c.getReference() instanceof UrlReference) {
            this.addNotNullAttribute(mc, "url", c.getReference());
            this.generatePlayer(c.getPlayer(), mc);
        } else {
            this.generatePlayer(c.getPlayer(), mc);
        }
        this.generateMetadata(c.getMetadata(), mc);
        e.addContent((Content)mc);
    }

    public void generateGroup(MediaGroup g, Element e) {
        MediaContent[] c;
        Element t = new Element("group", NS);
        for (MediaContent element : c = g.getContents()) {
            this.generateContent(element, t);
        }
        this.generateMetadata(g.getMetadata(), t);
        e.addContent((Content)t);
    }

    public void generateMetadata(Metadata m, Element e) {
        Restriction[] r;
        Thumbnail[] thumbs;
        Text[] text;
        Rating[] rats;
        String[] keywords;
        Credit[] creds;
        Category[] cats;
        if (m == null) {
            return;
        }
        for (Category cat : cats = m.getCategories()) {
            Element c = this.generateSimpleElement("category", cat.getValue());
            this.addNotNullAttribute(c, "scheme", cat.getScheme());
            this.addNotNullAttribute(c, "label", cat.getLabel());
            e.addContent((Content)c);
        }
        Element copyright = this.addNotNullElement(e, "copyright", m.getCopyright());
        this.addNotNullAttribute(copyright, "url", m.getCopyrightUrl());
        for (Credit cred : creds = m.getCredits()) {
            Element c = this.generateSimpleElement("credit", cred.getName());
            this.addNotNullAttribute(c, "role", cred.getRole());
            this.addNotNullAttribute(c, "scheme", cred.getScheme());
            e.addContent((Content)c);
        }
        Element desc = this.addNotNullElement(e, "description", m.getDescription());
        this.addNotNullAttribute(desc, "type", m.getDescriptionType());
        if (m.getHash() != null) {
            Element hash = this.addNotNullElement(e, "hash", m.getHash().getValue());
            this.addNotNullAttribute(hash, "algo", m.getHash().getAlgorithm());
        }
        if ((keywords = m.getKeywords()).length > 0) {
            String keyword = keywords[0];
            for (int i = 1; i < keywords.length; ++i) {
                keyword = keyword + ", " + keywords[i];
            }
            this.addNotNullElement(e, "keywords", keyword);
        }
        for (Rating rat2 : rats = m.getRatings()) {
            Element rat = this.addNotNullElement(e, "rating", rat2.getValue());
            this.addNotNullAttribute(rat, "scheme", rat2.getScheme());
            if (rat2.equals(Rating.ADULT)) {
                this.addNotNullElement(e, "adult", "true");
                continue;
            }
            if (!rat2.equals(Rating.NONADULT)) continue;
            this.addNotNullElement(e, "adult", "false");
        }
        for (Text element : text = m.getText()) {
            Element t = this.addNotNullElement(e, "text", element.getValue());
            this.addNotNullAttribute(t, "type", element.getType());
            this.addNotNullAttribute(t, "start", element.getStart());
            this.addNotNullAttribute(t, "end", element.getEnd());
        }
        for (Thumbnail thumb : thumbs = m.getThumbnail()) {
            Element t = new Element("thumbnail", NS);
            this.addNotNullAttribute(t, "url", thumb.getUrl());
            this.addNotNullAttribute(t, "width", thumb.getWidth());
            this.addNotNullAttribute(t, "height", thumb.getHeight());
            this.addNotNullAttribute(t, "time", thumb.getTime());
            e.addContent((Content)t);
        }
        Element title = this.addNotNullElement(e, "title", m.getTitle());
        this.addNotNullAttribute(title, "type", m.getTitleType());
        for (Restriction element : r = m.getRestrictions()) {
            Element res = this.addNotNullElement(e, "restriction", element.getValue());
            this.addNotNullAttribute(res, "type", element.getType());
            this.addNotNullAttribute(res, "relationship", element.getRelationship());
        }
    }

    public void generatePlayer(PlayerReference p, Element e) {
        if (p == null) {
            return;
        }
        Element t = new Element("player", NS);
        this.addNotNullAttribute(t, "url", p.getUrl());
        this.addNotNullAttribute(t, "width", p.getWidth());
        this.addNotNullAttribute(t, "height", p.getHeight());
        e.addContent((Content)t);
    }

    protected void addNotNullAttribute(Element target, String name, Object value) {
        if (target == null || value == null) {
            return;
        }
        target.setAttribute(name, value.toString());
    }

    protected Element addNotNullElement(Element target, String name, Object value) {
        if (value == null) {
            return null;
        }
        Element e = this.generateSimpleElement(name, value.toString());
        target.addContent((Content)e);
        return e;
    }

    protected Element generateSimpleElement(String name, String value) {
        Element element = new Element(name, NS);
        element.addContent(value);
        return element;
    }

    static {
        NAMESPACES.add(NS);
    }
}

