/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.sle.io;

import com.rometools.modules.sle.SleEntryImpl;
import com.rometools.modules.sle.io.ModuleParser;
import com.rometools.modules.sle.types.DateValue;
import com.rometools.modules.sle.types.EntryValue;
import com.rometools.modules.sle.types.NumberValue;
import com.rometools.modules.sle.types.StringValue;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.impl.DateParser;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ItemParser
implements com.rometools.rome.io.ModuleParser {
    public String getNamespaceUri() {
        return ModuleParser.TEMP.getURI();
    }

    public Module parse(Element element, Locale locale) {
        SleEntryImpl sle = new SleEntryImpl();
        ArrayList<EntryValue> values = new ArrayList<EntryValue>();
        List groups = element.getChildren("group", ModuleParser.TEMP);
        for (Element group : groups) {
            StringValue value = new StringValue();
            value.setElement(group.getAttributeValue("element"));
            value.setLabel(group.getAttributeValue("label"));
            value.setValue(group.getAttributeValue("value"));
            if (group.getAttributeValue("ns") != null) {
                value.setNamespace(Namespace.getNamespace((String)group.getAttributeValue("ns")));
            } else {
                value.setNamespace(element.getDocument().getRootElement().getNamespace());
            }
            values.add(value);
            element.removeContent((Content)group);
        }
        sle.setGroupValues(values.toArray(new EntryValue[values.size()]));
        values = values.size() == 0 ? values : new ArrayList<EntryValue>();
        ArrayList sorts = new ArrayList(element.getChildren("sort", ModuleParser.TEMP));
        for (Element sort : sorts) {
            EntryValue value;
            String dataType = sort.getAttributeValue("data-type");
            if (dataType == null || dataType.equals("text")) {
                value = new StringValue();
                ((StringValue)value).setElement(sort.getAttributeValue("element"));
                ((StringValue)value).setLabel(sort.getAttributeValue("label"));
                ((StringValue)value).setValue(sort.getAttributeValue("value"));
                if (sort.getAttributeValue("ns") != null) {
                    ((StringValue)value).setNamespace(Namespace.getNamespace((String)sort.getAttributeValue("ns")));
                } else {
                    ((StringValue)value).setNamespace(element.getDocument().getRootElement().getNamespace());
                }
                values.add(value);
                element.removeContent((Content)sort);
                continue;
            }
            if (dataType.equals("date")) {
                value = new DateValue();
                ((DateValue)value).setElement(sort.getAttributeValue("element"));
                ((DateValue)value).setLabel(sort.getAttributeValue("label"));
                if (sort.getAttributeValue("ns") != null) {
                    ((DateValue)value).setNamespace(Namespace.getNamespace((String)sort.getAttributeValue("ns")));
                } else {
                    ((DateValue)value).setNamespace(element.getDocument().getRootElement().getNamespace());
                }
                Date dateValue = null;
                try {
                    dateValue = DateParser.parseRFC822((String)sort.getAttributeValue("value"), (Locale)locale);
                    if (dateValue == null) {
                        dateValue = DateParser.parseW3CDateTime((String)sort.getAttributeValue("value"), (Locale)locale);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ((DateValue)value).setValue(dateValue);
                values.add(value);
                element.removeContent((Content)sort);
                continue;
            }
            if (dataType.equals("number")) {
                value = new NumberValue();
                ((NumberValue)value).setElement(sort.getAttributeValue("element"));
                ((NumberValue)value).setLabel(sort.getAttributeValue("label"));
                if (sort.getAttributeValue("ns") != null) {
                    ((NumberValue)value).setNamespace(Namespace.getNamespace((String)sort.getAttributeValue("ns")));
                } else {
                    ((NumberValue)value).setNamespace(element.getDocument().getRootElement().getNamespace());
                }
                try {
                    ((NumberValue)value).setValue(new BigDecimal(sort.getAttributeValue("value")));
                }
                catch (NumberFormatException nfe) {
                    values.add(value);
                    element.removeContent((Content)sort);
                }
                continue;
            }
            throw new RuntimeException("Unknown datatype");
        }
        sle.setSortValues(values.toArray(new EntryValue[values.size()]));
        return sle;
    }
}

