/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.sse;

import com.rometools.modules.sse.modules.Conflict;
import com.rometools.modules.sse.modules.History;
import com.rometools.modules.sse.modules.Related;
import com.rometools.modules.sse.modules.SSEModule;
import com.rometools.modules.sse.modules.Sharing;
import com.rometools.modules.sse.modules.Sync;
import com.rometools.modules.sse.modules.Update;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.feed.rss.Item;
import com.rometools.rome.io.DelegatingModuleParser;
import com.rometools.rome.io.WireFeedParser;
import com.rometools.rome.io.impl.DateParser;
import com.rometools.rome.io.impl.RSS20Parser;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jdom2.Attribute;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.jdom2.filter.AbstractFilter;
import org.jdom2.filter.Filter;

public class SSE091Parser
implements DelegatingModuleParser {
    private RSS20Parser rssParser;

    public void setFeedParser(WireFeedParser feedParser) {
        this.rssParser = (RSS20Parser)feedParser;
    }

    public String getNamespaceUri() {
        return "http://www.microsoft.com/schemas/rss/sse";
    }

    public Module parse(Element element, Locale locale) {
        SSEModule sseModule = null;
        String name = element.getName();
        if (name.equals("rss")) {
            sseModule = this.parseSharing(element, locale);
        } else if (name.equals("item")) {
            sseModule = this.parseSync(element, locale);
        }
        return sseModule;
    }

    private Sharing parseSharing(Element element, Locale locale) {
        Element root = this.getRoot(element);
        Sharing sharing = null;
        Element sharingChild = root.getChild("sharing", SSEModule.SSE_NS);
        if (sharingChild != null) {
            sharing = new Sharing();
            sharing.setOrdered(this.parseBooleanAttr(sharingChild, "ordered"));
            sharing.setSince(this.parseDateAttribute(sharingChild, "since", locale));
            sharing.setUntil(this.parseDateAttribute(sharingChild, "until", locale));
            sharing.setWindow(this.parseIntegerAttribute(sharingChild, "window"));
            sharing.setVersion(this.parseStringAttribute(sharingChild, "version"));
            this.parseRelated(root, sharing, locale);
        }
        return sharing;
    }

    private void parseRelated(Element root, Sharing sharing, Locale locale) {
        Element relatedChild = root.getChild("related", SSEModule.SSE_NS);
        if (relatedChild != null) {
            Related related = new Related();
            related.setLink(this.parseStringAttribute(relatedChild, "link"));
            related.setSince(this.parseDateAttribute(relatedChild, "since", locale));
            related.setTitle(this.parseStringAttribute(relatedChild, "title"));
            related.setType(this.parseIntegerAttribute(relatedChild, "type"));
            related.setUntil(this.parseDateAttribute(relatedChild, "until", locale));
            sharing.setRelated(related);
        }
    }

    private Sync parseSync(Element element, Locale locale) {
        Element syncChild = element.getChild("sync", SSEModule.SSE_NS);
        Sync sync = null;
        if (syncChild != null) {
            sync = new Sync();
            sync.setId(this.parseStringAttribute(syncChild, "id"));
            sync.setVersion(this.parseIntegerAttribute(syncChild, "version"));
            sync.setDeleted(this.parseBooleanAttr(syncChild, "deleted"));
            sync.setConflict(this.parseBooleanAttr(syncChild, "conflict"));
            sync.setHistory(this.parseHistory(syncChild, locale));
            sync.setConflicts(this.parseConflicts(syncChild, locale));
        }
        return sync;
    }

    private List<Conflict> parseConflicts(Element syncElement, Locale locale) {
        ArrayList<Conflict> conflicts = null;
        List conflictsContent = syncElement.getContent((Filter)new ContentFilter("conflicts"));
        for (Element conflictsElement : conflictsContent) {
            List conflictContent = conflictsElement.getContent((Filter)new ContentFilter("conflict"));
            Iterator iterator = conflictContent.iterator();
            while (iterator.hasNext()) {
                Element element;
                Element conflictElement = element = (Element)iterator.next();
                Conflict conflict = new Conflict();
                conflict.setBy(this.parseStringAttribute(conflictElement, "by"));
                conflict.setWhen(this.parseDateAttribute(conflictElement, "when", locale));
                conflict.setVersion(this.parseIntegerAttribute(conflictElement, "version"));
                List conflictItemContent = conflictElement.getContent((Filter)new ContentFilter("item"));
                Iterator iterator2 = conflictItemContent.iterator();
                while (iterator2.hasNext()) {
                    Element element2;
                    Element conflictItemElement = element2 = (Element)iterator2.next();
                    Element root = this.getRoot(conflictItemElement);
                    Item conflictItem = this.rssParser.parseItem(root, conflictItemElement, locale);
                    conflict.setItem(conflictItem);
                    if (conflicts == null) {
                        conflicts = new ArrayList<Conflict>();
                    }
                    conflicts.add(conflict);
                }
            }
        }
        return conflicts;
    }

    private Element getRoot(Element start) {
        Element root = start;
        while (root.getParent() != null && root.getParent() instanceof Element) {
            root = (Element)root.getParent();
        }
        return root;
    }

    private History parseHistory(Element historyElement, Locale locale) {
        Element historyContent = this.getFirstContent(historyElement, "history");
        History history = null;
        if (historyContent != null) {
            history = new History();
            history.setBy(this.parseStringAttribute(historyContent, "by"));
            history.setWhen(this.parseDateAttribute(historyContent, "when", locale));
            this.parseUpdates(historyContent, history, locale);
        }
        return history;
    }

    private Element getFirstContent(Element element, String name) {
        List filterList = element.getContent((Filter)new ContentFilter(name));
        Element firstContent = null;
        if (filterList != null && !filterList.isEmpty()) {
            firstContent = (Element)filterList.get(0);
        }
        return firstContent;
    }

    private void parseUpdates(Element historyChild, History history, Locale locale) {
        List updatedChildren = historyChild.getContent((Filter)new ContentFilter("update"));
        for (Element updateChild : updatedChildren) {
            Update update = new Update();
            update.setBy(this.parseStringAttribute(updateChild, "by"));
            update.setWhen(this.parseDateAttribute(updateChild, "when", locale));
            history.addUpdate(update);
        }
    }

    private String parseStringAttribute(Element syncChild, String attrName) {
        Attribute idAttribute = syncChild.getAttribute(attrName);
        return idAttribute != null ? idAttribute.getValue().trim() : null;
    }

    private Integer parseIntegerAttribute(Element sharingChild, String attrName) {
        Attribute integerAttribute = sharingChild.getAttribute(attrName);
        Integer integerAttr = null;
        if (integerAttribute != null) {
            try {
                integerAttr = new Integer(integerAttribute.getIntValue());
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        return integerAttr;
    }

    private Boolean parseBooleanAttr(Element sharingChild, String attrName) {
        Attribute attribute = sharingChild.getAttribute(attrName);
        Boolean attrValue = null;
        if (attribute != null) {
            try {
                attrValue = attribute.getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        return attrValue;
    }

    private Date parseDateAttribute(Element childElement, String attrName, Locale locale) {
        Attribute dateAttribute = childElement.getAttribute(attrName);
        Date date = null;
        if (dateAttribute != null) {
            String dateAttr = dateAttribute.getValue().trim();
            return DateParser.parseRFC822((String)dateAttr, (Locale)locale);
        }
        return date;
    }

    private static class ContentFilter
    extends AbstractFilter<Element> {
        private static final long serialVersionUID = 1L;
        private final String name;

        private ContentFilter(String name) {
            this.name = name;
        }

        public Element filter(Object content) {
            Element returnValue = content instanceof Element && this.name.equals(((Element)content).getName()) ? (Element)content : null;
            return returnValue;
        }
    }
}

