/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.photocast.io;

import com.rometools.modules.photocast.PhotocastModuleImpl;
import com.rometools.modules.photocast.types.Metadata;
import com.rometools.modules.photocast.types.PhotoDate;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleParser;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser
implements ModuleParser {
    private static final Logger LOG = LoggerFactory.getLogger(Parser.class);
    private static final Namespace NS = Namespace.getNamespace((String)"http://www.apple.com/ilife/wallpapers");
    static final DateFormat PHOTO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    static final DateFormat CROP_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");

    public Module parse(Element element, Locale locale) {
        if (element.getName().equals("channel") || element.getName().equals("feed")) {
            return new PhotocastModuleImpl();
        }
        if (element.getChild("metadata", NS) == null && element.getChild("image", NS) == null) {
            return null;
        }
        PhotocastModuleImpl pm = new PhotocastModuleImpl();
        List children = element.getChildren();
        for (Element e : children) {
            if (!e.getNamespace().equals((Object)NS)) continue;
            if (e.getName().equals("photoDate")) {
                try {
                    pm.setPhotoDate(PHOTO_DATE_FORMAT.parse(e.getText()));
                }
                catch (Exception ex) {
                    LOG.warn("Unable to parse photoDate: " + e.getText(), (Throwable)ex);
                }
                continue;
            }
            if (e.getName().equals("cropDate")) {
                try {
                    pm.setCropDate(CROP_DATE_FORMAT.parse(e.getText()));
                }
                catch (Exception ex) {
                    LOG.warn("Unable to parse cropDate: " + e.getText(), (Throwable)ex);
                }
                continue;
            }
            if (e.getName().equals("thumbnail")) {
                try {
                    pm.setThumbnailUrl(new URL(e.getText()));
                }
                catch (Exception ex) {
                    LOG.warn("Unable to parse thumnail: " + e.getText(), (Throwable)ex);
                }
                continue;
            }
            if (e.getName().equals("image")) {
                try {
                    pm.setImageUrl(new URL(e.getText()));
                }
                catch (Exception ex) {
                    LOG.warn("Unable to parse image: " + e.getText(), (Throwable)ex);
                }
                continue;
            }
            if (!e.getName().equals("metadata")) continue;
            String comments = "";
            PhotoDate photoDate = null;
            if (e.getChildText("PhotoDate") != null) {
                try {
                    photoDate = new PhotoDate(Double.parseDouble(e.getChildText("PhotoDate")));
                }
                catch (Exception ex) {
                    LOG.warn("Unable to parse PhotoDate: " + e.getText(), (Throwable)ex);
                }
            }
            if (e.getChildText("Comments") != null) {
                comments = e.getChildText("Comments");
            }
            pm.setMetadata(new Metadata(photoDate, comments));
        }
        return pm;
    }

    public String getNamespaceUri() {
        return "http://www.apple.com/ilife/wallpapers";
    }
}

