/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.georss;

import com.rometools.modules.georss.GeoRSSModule;
import com.rometools.modules.georss.geometries.AbstractGeometry;
import com.rometools.modules.georss.geometries.AbstractRing;
import com.rometools.modules.georss.geometries.Envelope;
import com.rometools.modules.georss.geometries.LineString;
import com.rometools.modules.georss.geometries.LinearRing;
import com.rometools.modules.georss.geometries.Point;
import com.rometools.modules.georss.geometries.Polygon;
import com.rometools.modules.georss.geometries.Position;
import com.rometools.modules.georss.geometries.PositionList;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class GMLGenerator
implements ModuleGenerator {
    private static final Set<Namespace> NAMESPACES;

    private Element createPosListElement(PositionList posList) {
        Element posElement = new Element("posList", GeoRSSModule.GML_NS);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < posList.size(); ++i) {
            sb.append(posList.getLatitude(i)).append(" ").append(posList.getLongitude(i)).append(" ");
        }
        posElement.addContent(sb.toString());
        return posElement;
    }

    public String getNamespaceUri() {
        return "http://www.opengis.net/gml";
    }

    public Set<Namespace> getNamespaces() {
        return NAMESPACES;
    }

    public void generate(Module module, Element element) {
        Element root = element;
        while (root.getParent() != null && root.getParent() instanceof Element) {
            root = (Element)element.getParent();
        }
        root.addNamespaceDeclaration(GeoRSSModule.SIMPLE_NS);
        root.addNamespaceDeclaration(GeoRSSModule.GML_NS);
        Element whereElement = new Element("where", GeoRSSModule.SIMPLE_NS);
        element.addContent((Content)whereElement);
        GeoRSSModule geoRSSModule = (GeoRSSModule)module;
        AbstractGeometry geometry = geoRSSModule.getGeometry();
        if (geometry instanceof Point) {
            Position pos = ((Point)geometry).getPosition();
            Element pointElement = new Element("Point", GeoRSSModule.GML_NS);
            whereElement.addContent((Content)pointElement);
            Element posElement = new Element("pos", GeoRSSModule.GML_NS);
            posElement.addContent(String.valueOf(pos.getLatitude()) + " " + String.valueOf(pos.getLongitude()));
            pointElement.addContent((Content)posElement);
        } else if (geometry instanceof LineString) {
            PositionList posList = ((LineString)geometry).getPositionList();
            Element lineElement = new Element("LineString", GeoRSSModule.GML_NS);
            lineElement.addContent((Content)this.createPosListElement(posList));
            whereElement.addContent((Content)lineElement);
        } else if (geometry instanceof Polygon) {
            Element polygonElement = new Element("Polygon", GeoRSSModule.GML_NS);
            AbstractRing ring = ((Polygon)geometry).getExterior();
            if (ring instanceof LinearRing) {
                Element exteriorElement = new Element("exterior", GeoRSSModule.GML_NS);
                polygonElement.addContent((Content)exteriorElement);
                Element ringElement = new Element("LinearRing", GeoRSSModule.GML_NS);
                exteriorElement.addContent((Content)ringElement);
                ringElement.addContent((Content)this.createPosListElement(((LinearRing)ring).getPositionList()));
            } else {
                System.err.println("GeoRSS GML format can't handle rings of type: " + ring.getClass().getName());
            }
            List<AbstractRing> interiorList = ((Polygon)geometry).getInterior();
            for (AbstractRing ring2 : interiorList) {
                if (ring2 instanceof LinearRing) {
                    Element interiorElement = new Element("interior", GeoRSSModule.GML_NS);
                    polygonElement.addContent((Content)interiorElement);
                    Element ringElement = new Element("LinearRing", GeoRSSModule.GML_NS);
                    interiorElement.addContent((Content)ringElement);
                    ringElement.addContent((Content)this.createPosListElement(((LinearRing)ring2).getPositionList()));
                    continue;
                }
                System.err.println("GeoRSS GML format can't handle rings of type: " + ring2.getClass().getName());
            }
            whereElement.addContent((Content)polygonElement);
        } else if (geometry instanceof Envelope) {
            Envelope envelope = (Envelope)geometry;
            Element envelopeElement = new Element("Envelope", GeoRSSModule.GML_NS);
            whereElement.addContent((Content)envelopeElement);
            Element lowerElement = new Element("lowerCorner", GeoRSSModule.GML_NS);
            lowerElement.addContent(String.valueOf(envelope.getMinLatitude()) + " " + String.valueOf(envelope.getMinLongitude()));
            envelopeElement.addContent((Content)lowerElement);
            Element upperElement = new Element("upperCorner", GeoRSSModule.GML_NS);
            upperElement.addContent(String.valueOf(envelope.getMaxLatitude()) + " " + String.valueOf(envelope.getMaxLongitude()));
            envelopeElement.addContent((Content)upperElement);
        } else {
            System.err.println("GeoRSS GML format can't handle geometries of type: " + geometry.getClass().getName());
        }
    }

    static {
        HashSet<Namespace> nss = new HashSet<Namespace>();
        nss.add(GeoRSSModule.GML_NS);
        NAMESPACES = Collections.unmodifiableSet(nss);
    }
}

