/*
 * Decompiled with CFR 0.152.
 */
package com.rmkrishna.mediapicker;

import android.content.ClipData;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.content.ContextCompat;
import androidx.core.content.FileProvider;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.rmkrishna.imagepicker.R;
import com.rmkrishna.mediapicker.MediaPickerListener;
import com.yalantis.ucrop.UCrop;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0017H\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\rH\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\rH\u0002J \u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0016H\u0002J\"\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0016J&\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u001a\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u00020'2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\b\u00100\u001a\u00020 H\u0002J\u0010\u00101\u001a\u00020\u00002\b\b\u0001\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/rmkrishna/mediapicker/MFragment;", "Landroidx/fragment/app/Fragment;", "()V", "aspectRatioHeight", "", "aspectRatioWidth", "compressPercentage", "", "listener", "Lcom/rmkrishna/mediapicker/MediaPickerListener;", "maxResultHeight", "maxResultWidth", "outputCameraUri", "Landroid/net/Uri;", "getOutputCameraUri", "()Landroid/net/Uri;", "setOutputCameraUri", "(Landroid/net/Uri;)V", "primaryColor", "primaryColorDark", "getCameraIntents", "Ljava/util/ArrayList;", "Landroid/content/Intent;", "Lkotlin/collections/ArrayList;", "getCaptureUri", "getCropUri", "getGalleryIntents", "action", "", "getPickImageResultUri", "data", "onActivityResult", "", "requestCode", "resultCode", "onAttach", "context", "Landroid/content/Context;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onViewCreated", "view", "openCamera", "setListener", "mediapicker_release"})
public final class MFragment
extends Fragment {
    private MediaPickerListener listener;
    private int primaryColor = -1;
    private int primaryColorDark = -1;
    private int compressPercentage = -1;
    private int maxResultWidth = -1;
    private int maxResultHeight = -1;
    private float aspectRatioWidth = -1.0f;
    private float aspectRatioHeight = -1.0f;
    @Nullable
    private Uri outputCameraUri;

    @Nullable
    public final Uri getOutputCameraUri() {
        return this.outputCameraUri;
    }

    public final void setOutputCameraUri(@Nullable Uri uri) {
        this.outputCameraUri = uri;
    }

    public void onAttach(@NotNull Context context) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super.onAttach(context);
            Bundle bundle = this.getArguments();
            if (bundle == null) break block0;
            Bundle bundle2 = bundle;
            boolean bl = false;
            boolean bl2 = false;
            Bundle it = bundle2;
            boolean bl3 = false;
            this.primaryColor = it.getInt("primary_color", -1);
            this.primaryColorDark = it.getInt("primary_dark_color", -1);
            this.compressPercentage = it.getInt("compress_percentage", -1);
            this.maxResultWidth = it.getInt("max_result_width", -1);
            this.maxResultHeight = it.getInt("max_result_height", -1);
            this.aspectRatioWidth = it.getFloat("aspect_ratio_width", -1.0f);
            this.aspectRatioHeight = it.getFloat("aspect_ratio_height", -1.0f);
        }
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        return inflater.inflate(R.layout.fragment_m, container, false);
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        this.openCamera();
    }

    @NotNull
    public final MFragment setListener(@androidx.annotation.Nullable @NotNull MediaPickerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
        return this;
    }

    private final void openCamera() {
        ArrayList allIntents = new ArrayList();
        ArrayList<Intent> galleryIntents = this.getGalleryIntents("android.intent.action.PICK");
        if (galleryIntents.isEmpty()) {
            galleryIntents.addAll((Collection<Intent>)this.getGalleryIntents("android.intent.action.GET_CONTENT"));
        }
        allIntents.addAll(CollectionsKt.take((Iterable)this.getCameraIntents(), (int)2));
        allIntents.addAll(galleryIntents);
        Intent target = null;
        if (allIntents.isEmpty()) {
            target = new Intent();
        } else {
            Object e = allIntents.get(allIntents.size() - 1);
            Intrinsics.checkNotNullExpressionValue(e, (String)"allIntents[allIntents.size - 1]");
            target = (Intent)e;
            Intrinsics.checkNotNullExpressionValue(allIntents.remove(allIntents.size() - 1), (String)"allIntents.removeAt(allIntents.size - 1)");
        }
        Intent chooserIntent = Intent.createChooser((Intent)target, (CharSequence)"Choose app to get Image");
        Collection $this$toTypedArray$iv = allIntents;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Parcelable[] parcelableArray = thisCollection$iv.toArray(new Parcelable[0]);
        if (parcelableArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", parcelableArray);
        this.startActivityForResult(chooserIntent, 4883);
    }

    private final ArrayList<Intent> getCameraIntents() {
        List listCam;
        ArrayList<Intent> allIntents = new ArrayList<Intent>();
        Intent captureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        this.outputCameraUri = this.getCaptureUri();
        FragmentActivity fragmentActivity = this.getActivity();
        List list = listCam = fragmentActivity != null && (fragmentActivity = fragmentActivity.getPackageManager()) != null ? fragmentActivity.queryIntentActivities(captureIntent, 0) : null;
        if (list != null) {
            List list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List it = list2;
            boolean bl3 = false;
            Iterator iterator = it.iterator();
            boolean bl4 = false;
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                ResolveInfo res = (ResolveInfo)iterator2.next();
                Intent intent = new Intent(captureIntent);
                intent.setComponent(new ComponentName(res.activityInfo.packageName, res.activityInfo.name));
                intent.setPackage(res.activityInfo.packageName);
                if (this.outputCameraUri != null) {
                    intent.putExtra("output", (Parcelable)this.outputCameraUri);
                }
                allIntents.add(intent);
            }
        }
        return allIntents;
    }

    private final ArrayList<Intent> getGalleryIntents(String action) {
        List listGallery;
        ArrayList<Intent> galleryIntents = new ArrayList<Intent>();
        Intent galleryIntent = action == "android.intent.action.GET_CONTENT" ? new Intent(action) : new Intent(action, MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        galleryIntent.setType("image/*");
        FragmentActivity fragmentActivity = this.getActivity();
        List list = listGallery = fragmentActivity != null && (fragmentActivity = fragmentActivity.getPackageManager()) != null ? fragmentActivity.queryIntentActivities(galleryIntent, 0) : null;
        if (list != null) {
            List list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List it = list2;
            boolean bl3 = false;
            for (ResolveInfo res : it) {
                Intent intent = new Intent(galleryIntent);
                intent.setComponent(new ComponentName(res.activityInfo.packageName, res.activityInfo.name));
                intent.setPackage(res.activityInfo.packageName);
                galleryIntents.add(intent);
            }
        }
        Iterator iterator = galleryIntents.iterator();
        while (iterator.hasNext()) {
            Intent intent;
            Intent intent2 = intent = (Intent)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"intent");
            ComponentName componentName = intent2.getComponent();
            Intrinsics.checkNotNull((Object)componentName);
            Intrinsics.checkNotNullExpressionValue((Object)componentName, (String)"intent.component!!");
            if (!Intrinsics.areEqual((Object)componentName.getClassName(), (Object)"com.android.documentsui.DocumentsActivity")) continue;
            galleryIntents.remove(intent);
            break;
        }
        return galleryIntents;
    }

    private final Uri getCaptureUri() {
        Uri outputFileUri;
        block1: {
            File getImage2;
            outputFileUri = null;
            FragmentActivity fragmentActivity = this.getActivity();
            if (fragmentActivity == null) break block1;
            FragmentActivity fragmentActivity2 = fragmentActivity;
            boolean bl = false;
            boolean bl2 = false;
            FragmentActivity activity = fragmentActivity2;
            boolean bl3 = false;
            FragmentActivity fragmentActivity3 = activity;
            Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity3, (String)"activity");
            File file = getImage2 = fragmentActivity3.getExternalCacheDir();
            if (file != null) {
                Uri imageUri;
                File file2 = file;
                boolean bl4 = false;
                boolean bl5 = false;
                File it = file2;
                boolean bl6 = false;
                outputFileUri = imageUri = FileProvider.getUriForFile((Context)((Context)activity), (String)activity.getPackageName(), (File)new File(getImage2.getPath(), System.currentTimeMillis() + ".jpeg"));
            }
        }
        return outputFileUri;
    }

    private final Uri getPickImageResultUri(Intent data) {
        Uri uri;
        boolean isCamera = true;
        if (data != null && data.getData() != null) {
            String action = data.getAction();
            isCamera = action != null && Intrinsics.areEqual((Object)action, (Object)"android.media.action.IMAGE_CAPTURE");
        }
        if (isCamera) {
            uri = this.outputCameraUri;
        } else {
            Intent intent = data;
            Intrinsics.checkNotNull((Object)intent);
            if (intent.getClipData() != null) {
                ClipData clipData = data.getClipData();
                Intrinsics.checkNotNull((Object)clipData);
                ClipData.Item item = clipData.getItemAt(0);
                Intrinsics.checkNotNullExpressionValue((Object)item, (String)"data.clipData!!.getItemAt(0)");
                uri = item.getUri();
            } else {
                uri = data.getData() != null ? data.getData() : this.outputCameraUri;
            }
        }
        return uri;
    }

    private final Uri getCropUri() {
        Uri outputFileUri;
        block0: {
            File getImage2;
            outputFileUri = null;
            Context context = this.getContext();
            File file = getImage2 = context != null ? context.getExternalCacheDir() : null;
            if (file == null) break block0;
            File file2 = file;
            boolean bl = false;
            boolean bl2 = false;
            File it = file2;
            boolean bl3 = false;
            outputFileUri = Uri.fromFile((File)new File(getImage2.getPath(), System.currentTimeMillis() + ".jpeg"));
        }
        return outputFileUri;
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        block12: {
            FragmentManager fragmentManager;
            block11: {
                Uri resultUri;
                super.onActivityResult(requestCode, resultCode, data);
                if (resultCode == 0) {
                    FragmentManager fragmentManager2 = this.getFragmentManager();
                    if (fragmentManager2 != null && (fragmentManager2 = fragmentManager2.beginTransaction()) != null && (fragmentManager2 = fragmentManager2.remove((Fragment)this)) != null) {
                        fragmentManager2.commitAllowingStateLoss();
                    }
                    MediaPickerListener mediaPickerListener = this.listener;
                    if (mediaPickerListener == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"listener");
                    }
                    mediaPickerListener.onFileReceivedFailed();
                    return;
                }
                if (resultCode != -1 || requestCode != 4883) break block11;
                Uri uri = resultUri = this.getPickImageResultUri(data);
                if (uri == null) break block12;
                Uri uri2 = uri;
                boolean bl = false;
                boolean bl2 = false;
                Uri it = uri2;
                boolean bl3 = false;
                UCrop.Options options = new UCrop.Options();
                if (this.compressPercentage > 0) {
                    options.setCompressionQuality(this.compressPercentage);
                }
                String string = "aspectRatioHeight " + this.aspectRatioHeight + ", aspectRatioWidth " + this.aspectRatioWidth;
                boolean bl4 = false;
                System.out.println((Object)string);
                if (this.aspectRatioHeight > 0.0f && this.aspectRatioWidth > 0.0f) {
                    options.withAspectRatio(this.aspectRatioWidth, this.aspectRatioHeight);
                }
                if (this.maxResultWidth > 0 && this.maxResultHeight > 0) {
                    options.withMaxResultSize(this.maxResultWidth, this.maxResultWidth);
                }
                if (this.primaryColor == -1) {
                    this.primaryColor = ContextCompat.getColor((Context)((Context)this.requireActivity()), (int)R.color.colorPrimary);
                }
                if (this.primaryColorDark == -1) {
                    this.primaryColorDark = ContextCompat.getColor((Context)((Context)this.requireActivity()), (int)R.color.colorPrimaryDark);
                }
                options.setToolbarColor(this.primaryColor);
                options.setStatusBarColor(this.primaryColorDark);
                Uri uri3 = this.getCropUri();
                Intrinsics.checkNotNull((Object)uri3);
                UCrop.of((Uri)resultUri, (Uri)uri3).withOptions(options).start((Context)this.requireActivity(), (Fragment)this, 69);
                break block12;
            }
            if (resultCode != -1 || requestCode != 69) break block12;
            Intent intent = data;
            if (intent != null) {
                Intent intent2 = intent;
                boolean bl = false;
                boolean bl5 = false;
                Intent it = intent2;
                boolean bl6 = false;
                Uri resultUri = UCrop.getOutput((Intent)it);
                boolean bl7 = false;
                ArrayList<Uri> list = new ArrayList<Uri>();
                list.add(resultUri);
                MediaPickerListener mediaPickerListener = this.listener;
                if (mediaPickerListener == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"listener");
                }
                mediaPickerListener.onFileReceived((List<? extends Uri>)list);
            }
            if ((fragmentManager = this.getFragmentManager()) != null && (fragmentManager = fragmentManager.beginTransaction()) != null && (fragmentManager = fragmentManager.remove((Fragment)this)) != null) {
                fragmentManager.commitAllowingStateLoss();
            }
        }
    }
}

