/*
 * Decompiled with CFR 0.152.
 */
package com.rmkrishna.mediapicker;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.rmkrishna.imagepicker.R;
import com.rmkrishna.mediapicker.MediaPickerListener;
import com.yalantis.ucrop.UCrop;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bJ\b\u0010\t\u001a\u0004\u0018\u00010\nJ\b\u0010\u000b\u001a\u0004\u0018\u00010\nJ\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b2\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0016J&\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u001a\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00172\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0006\u0010 \u001a\u00020\u0012J\u0010\u0010!\u001a\u00020\u00002\b\b\u0001\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/rmkrishna/mediapicker/MFragment;", "Landroidx/fragment/app/Fragment;", "()V", "listener", "Lcom/rmkrishna/mediapicker/MediaPickerListener;", "getCameraIntents", "Ljava/util/ArrayList;", "Landroid/content/Intent;", "Lkotlin/collections/ArrayList;", "getCaptureUri", "Landroid/net/Uri;", "getCropUri", "getGalleryIntents", "action", "", "getPickImageResultUri", "data", "onActivityResult", "", "requestCode", "", "resultCode", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onViewCreated", "view", "openCamera", "setListener", "mediapicker_release"})
public final class MFragment
extends Fragment {
    private MediaPickerListener listener;
    private HashMap _$_findViewCache;

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)inflater, (String)"inflater");
        return inflater.inflate(R.layout.fragment_m, container, false);
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        this.openCamera();
    }

    @NotNull
    public final MFragment setListener(@androidx.annotation.Nullable @NotNull MediaPickerListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listener = listener;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final void openCamera() {
        void $receiver$iv;
        Intent target;
        ArrayList allIntents = new ArrayList();
        ArrayList<Intent> galleryIntents = this.getGalleryIntents("android.intent.action.GET_CONTENT");
        if (galleryIntents.isEmpty()) {
            galleryIntents.addAll((Collection<Intent>)this.getGalleryIntents("android.intent.action.PICK"));
        }
        allIntents.addAll(this.getCameraIntents());
        allIntents.addAll(galleryIntents);
        if (allIntents.isEmpty()) {
            target = new Intent();
        } else {
            Object e = allIntents.get(allIntents.size() - 1);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"allIntents[allIntents.size - 1]");
            target = (Intent)e;
            Intrinsics.checkExpressionValueIsNotNull(allIntents.remove(allIntents.size() - 1), (String)"allIntents.removeAt(allIntents.size - 1)");
        }
        Intent chooserIntent = Intent.createChooser((Intent)target, (CharSequence)"Choose app to get Image");
        Collection collection = allIntents;
        String string = "android.intent.extra.INITIAL_INTENTS";
        Intent intent = chooserIntent;
        void thisCollection$iv = $receiver$iv;
        Parcelable[] parcelableArray = thisCollection$iv.toArray(new Parcelable[0]);
        if (parcelableArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Parcelable[] parcelableArray2 = parcelableArray;
        intent.putExtra(string, parcelableArray2);
        this.startActivityForResult(chooserIntent, 4883);
    }

    @NotNull
    public final ArrayList<Intent> getCameraIntents() {
        List listCam;
        ArrayList<Intent> allIntents = new ArrayList<Intent>();
        Intent captureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        Uri outputFileUri = this.getCaptureUri();
        FragmentActivity fragmentActivity = this.getActivity();
        List list = listCam = fragmentActivity != null && (fragmentActivity = fragmentActivity.getPackageManager()) != null ? fragmentActivity.queryIntentActivities(captureIntent, 0) : null;
        if (list != null) {
            Iterator iterator;
            List list2;
            List it = list2 = list;
            Iterator iterator2 = iterator = it.iterator();
            while (iterator2.hasNext()) {
                ResolveInfo res = (ResolveInfo)iterator2.next();
                Intent intent = new Intent(captureIntent);
                intent.setComponent(new ComponentName(res.activityInfo.packageName, res.activityInfo.name));
                intent.setPackage(res.activityInfo.packageName);
                if (outputFileUri != null) {
                    intent.putExtra("output", (Parcelable)outputFileUri);
                }
                allIntents.add(intent);
            }
        }
        return allIntents;
    }

    @NotNull
    public final ArrayList<Intent> getGalleryIntents(@NotNull String action) {
        List listGallery;
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        ArrayList<Intent> galleryIntents = new ArrayList<Intent>();
        Intent galleryIntent = action == "android.intent.action.GET_CONTENT" ? new Intent(action) : new Intent(action, MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        galleryIntent.setType("image/*");
        FragmentActivity fragmentActivity = this.getActivity();
        List list = listGallery = fragmentActivity != null && (fragmentActivity = fragmentActivity.getPackageManager()) != null ? fragmentActivity.queryIntentActivities(galleryIntent, 0) : null;
        if (list != null) {
            List list2;
            List it = list2 = list;
            for (ResolveInfo res : it) {
                Intent intent = new Intent(galleryIntent);
                intent.setComponent(new ComponentName(res.activityInfo.packageName, res.activityInfo.name));
                intent.setPackage(res.activityInfo.packageName);
                galleryIntents.add(intent);
            }
        }
        for (Intent intent : galleryIntents) {
            ComponentName componentName = intent.getComponent();
            if (componentName == null) {
                Intrinsics.throwNpe();
            }
            if (!Intrinsics.areEqual((Object)componentName.getClassName(), (Object)"com.android.documentsui.DocumentsActivity")) continue;
            galleryIntents.remove(intent);
            break;
        }
        return galleryIntents;
    }

    @Nullable
    public final Uri getCaptureUri() {
        Uri outputFileUri;
        block0: {
            File file;
            File getImage2;
            outputFileUri = null;
            FragmentActivity fragmentActivity = this.getActivity();
            File file2 = getImage2 = fragmentActivity != null ? fragmentActivity.getExternalCacheDir() : null;
            if (file2 == null) break block0;
            File it = file = file2;
            outputFileUri = Uri.fromFile((File)new File(getImage2.getPath(), "vmsImage.jpeg"));
        }
        return outputFileUri;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final Uri getPickImageResultUri(@Nullable Intent data) {
        Uri uri;
        boolean isCamera = true;
        if (data != null && data.getData() != null) {
            String action = data.getAction();
            boolean bl = isCamera = action != null && Intrinsics.areEqual((Object)action, (Object)"android.media.action.IMAGE_CAPTURE");
        }
        if (!isCamera) {
            Intent intent = data;
            if (intent == null) {
                Intrinsics.throwNpe();
            }
            if (intent.getData() != null) {
                uri = data.getData();
                return uri;
            }
        }
        uri = this.getCaptureUri();
        return uri;
    }

    @Nullable
    public final Uri getCropUri() {
        Uri outputFileUri;
        block0: {
            File file;
            File getImage2;
            outputFileUri = null;
            Context context = this.getContext();
            File file2 = getImage2 = context != null ? context.getExternalCacheDir() : null;
            if (file2 == null) break block0;
            File it = file = file2;
            outputFileUri = Uri.fromFile((File)new File(getImage2.getPath(), "vmsCropImage.jpeg"));
        }
        return outputFileUri;
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        block11: {
            FragmentManager fragmentManager;
            block10: {
                Uri uri;
                Uri resultUri;
                super.onActivityResult(requestCode, resultCode, data);
                if (resultCode == 0) {
                    FragmentManager fragmentManager2 = this.getFragmentManager();
                    if (fragmentManager2 != null && (fragmentManager2 = fragmentManager2.beginTransaction()) != null && (fragmentManager2 = fragmentManager2.remove((Fragment)this)) != null) {
                        fragmentManager2.commitAllowingStateLoss();
                    }
                    MediaPickerListener mediaPickerListener = this.listener;
                    if (mediaPickerListener == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"listener");
                    }
                    mediaPickerListener.onFileReceivedFailed();
                    return;
                }
                if (resultCode != -1 || requestCode != 4883) break block10;
                Uri uri2 = resultUri = this.getPickImageResultUri(data);
                if (uri2 == null) break block11;
                Uri it = uri = uri2;
                UCrop.Options options = new UCrop.Options();
                options.setCompressionQuality(50);
                options.withMaxResultSize(1024, 1024);
                FragmentActivity fragmentActivity = this.getActivity();
                if (fragmentActivity == null) {
                    Intrinsics.throwNpe();
                }
                options.setToolbarColor(ContextCompat.getColor((Context)((Context)fragmentActivity), (int)R.color.colorPrimary));
                FragmentActivity fragmentActivity2 = this.getActivity();
                if (fragmentActivity2 == null) {
                    Intrinsics.throwNpe();
                }
                options.setStatusBarColor(ContextCompat.getColor((Context)((Context)fragmentActivity2), (int)R.color.colorPrimaryDark));
                Uri uri3 = this.getCropUri();
                if (uri3 == null) {
                    Intrinsics.throwNpe();
                }
                UCrop uCrop = UCrop.of((Uri)resultUri, (Uri)uri3).withOptions(options);
                FragmentActivity fragmentActivity3 = this.getActivity();
                if (fragmentActivity3 == null) {
                    Intrinsics.throwNpe();
                }
                uCrop.start((Context)fragmentActivity3, (Fragment)this, 69);
                break block11;
            }
            if (resultCode != -1 || requestCode != 69) break block11;
            Intent intent = data;
            if (intent != null) {
                Intent intent2;
                Intent it = intent2 = intent;
                Uri resultUri = UCrop.getOutput((Intent)it);
                ArrayList<Uri> list = new ArrayList<Uri>();
                list.add(resultUri);
                MediaPickerListener mediaPickerListener = this.listener;
                if (mediaPickerListener == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"listener");
                }
                mediaPickerListener.onFileReceived((List<? extends Uri>)list);
            }
            if ((fragmentManager = this.getFragmentManager()) != null && (fragmentManager = fragmentManager.beginTransaction()) != null && (fragmentManager = fragmentManager.remove((Fragment)this)) != null) {
                fragmentManager.commitAllowingStateLoss();
            }
        }
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            View view2 = this.getView();
            if (view2 == null) {
                return null;
            }
            view = view2.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    public /* synthetic */ void onDestroyView() {
        super.onDestroyView();
        this._$_clearFindViewByIdCache();
    }
}

