package com.rmkrishna.mediapicker

import android.app.Activity
import android.content.ComponentName
import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.os.Parcelable
import android.provider.MediaStore
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.annotation.Nullable
import androidx.core.content.ContextCompat
import androidx.fragment.app.Fragment
import com.rmkrishna.imagepicker.R
import com.yalantis.ucrop.UCrop
import java.io.File


private const val ARG_PERMISSIONS = "permissions"
private const val PERMISSION_REQUEST_CODE = 4883

/***
 * Transparent Fragment help to get the permission and send back the result back to UI using callbacks
 */
class MFragment : Fragment() {

    private lateinit var listener: MediaPickerListener

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.fragment_m, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        openCamera()
    }

    /**
     * To set the {@link MPermissionListener} to the fragment
     */
    fun setListener(@Nullable listener: MediaPickerListener): MFragment {

        this.listener = listener

        return this
    }

    fun openCamera() {
        val allIntents = ArrayList<Intent>()

        val galleryIntents = getGalleryIntents(Intent.ACTION_GET_CONTENT)
        if (galleryIntents.isEmpty()) {
            galleryIntents.addAll(getGalleryIntents(Intent.ACTION_PICK))
        }

        allIntents.addAll(getCameraIntents())
        allIntents.addAll(galleryIntents)

        val target: Intent
        if (allIntents.isEmpty()) {
            target = Intent()
        } else {
            target = allIntents[allIntents.size - 1]
            allIntents.removeAt(allIntents.size - 1)
        }

        // Create a chooser from the main  intent
        val chooserIntent = Intent.createChooser(target, "Choose app to get Image")

        // Add all other intents
        chooserIntent.putExtra(
            Intent.EXTRA_INITIAL_INTENTS, allIntents.toTypedArray<Parcelable>()
        )

        startActivityForResult(chooserIntent, 4883)
    }

    fun getCameraIntents(): ArrayList<Intent> {
        val allIntents = ArrayList<Intent>()

        val captureIntent = Intent(MediaStore.ACTION_IMAGE_CAPTURE)

        val outputFileUri = getCaptureUri()

        val listCam = activity?.packageManager?.queryIntentActivities(captureIntent, 0)

        listCam?.let {
            for (res in it.iterator()) {
                val intent = Intent(captureIntent)
                intent.component =
                        ComponentName(res.activityInfo.packageName, res.activityInfo.name)
                intent.setPackage(res.activityInfo.packageName)
                if (outputFileUri != null) {
                    intent.putExtra(MediaStore.EXTRA_OUTPUT, outputFileUri)
                }
                allIntents.add(intent)
            }
        }

        return allIntents
    }

    fun getGalleryIntents(action: String): ArrayList<Intent> {
        val galleryIntents = ArrayList<Intent>()

        val galleryIntent = if (action === Intent.ACTION_GET_CONTENT)
            Intent(action)
        else
            Intent(action, MediaStore.Images.Media.EXTERNAL_CONTENT_URI)

        galleryIntent.type = "image/*"
        val listGallery = activity?.packageManager?.queryIntentActivities(galleryIntent, 0)
        listGallery?.let {
            for (res in it) {
                val intent = Intent(galleryIntent)
                intent.component =
                        ComponentName(res.activityInfo.packageName, res.activityInfo.name)
                intent.setPackage(res.activityInfo.packageName)
                galleryIntents.add(intent)
            }
        }

        for (intent in galleryIntents) {
            if (intent
                    .getComponent()!!
                    .getClassName() == "com.android.documentsui.DocumentsActivity"
            ) {
                galleryIntents.remove(intent)
                break
            }
        }

        return galleryIntents
    }

    fun getCaptureUri(): Uri? {
        var outputFileUri: Uri? = null

        val getImage = activity?.getExternalCacheDir()
        getImage?.let {
            outputFileUri = Uri.fromFile(File(getImage.path, "vmsImage.jpeg"))
        }

        return outputFileUri
    }

    /**
     * Get the URI of the selected image from [.getPickImageChooserIntent].<br></br>
     * Will return the correct URI for camera and gallery image.
     *
     * @param context used to access Android APIs, like content resolve, it is your
     * activity/fragment/widget.
     * @param data the returned data of the activity result
     */
    fun getPickImageResultUri(data: Intent?): Uri? {
        var isCamera = true
        if (data != null && data.data != null) {
            val action = data.action
            isCamera = action != null && action == MediaStore.ACTION_IMAGE_CAPTURE
        }
        return if (isCamera || data!!.data == null) getCaptureUri() else data.data
    }

    fun getCropUri(): Uri? {
        var outputFileUri: Uri? = null

        val getImage = context?.getExternalCacheDir()
        getImage?.let {
            outputFileUri = Uri.fromFile(File(getImage.path, "vmsCropImage.jpeg"))
        }

        return outputFileUri
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)

        if (resultCode == Activity.RESULT_CANCELED) {
            // User cancelled the picker. No need to handle
            fragmentManager?.beginTransaction()?.remove(this)?.commitAllowingStateLoss()
            listener.onFileReceivedFailed()
            return
        }
        if (resultCode == Activity.RESULT_OK && requestCode == 4883) {
            val resultUri = getPickImageResultUri(data)

            resultUri?.let {


                var options = UCrop.Options()
                options.setCompressionQuality(50)
                options.withMaxResultSize(1024, 1024)
                options.setToolbarColor(
                    ContextCompat.getColor(
                        activity!!,
                        R.color.colorPrimary
                    )
                );
                options.setStatusBarColor(
                    ContextCompat.getColor(
                        activity!!,
                        R.color.colorPrimaryDark
                    )
                );

                UCrop.of(resultUri, getCropUri()!!)
                    .withOptions(options)
                    .start(activity!!, this, UCrop.REQUEST_CROP);
            }
        } else if (resultCode == Activity.RESULT_OK && requestCode == UCrop.REQUEST_CROP) {
            data?.let {
                var resultUri: Uri? = UCrop.getOutput(it)
                var list = arrayListOf<Uri?>()
                list.add(resultUri)

                listener.onFileReceived(list)
            }
            fragmentManager?.beginTransaction()?.remove(this)?.commitAllowingStateLoss()
        }
    }


//    override fun onRequestPermissionsResult(
//        requestCode: Int,
//        permissions: Array<out String>,
//        grantResults: IntArray
//    ) {
//
//        if (requestCode == PERMISSION_REQUEST_CODE) {
//
//            var grantedAllPermissions = true
//
//            val neverAskAgainPermissionList = mutableListOf<String>()
//            val deniedPermissionList = arrayListOf<String>()
//
//            permissions.forEachIndexed { index, permission ->
//                if (grantResults[index] == PackageManager.PERMISSION_DENIED) {
//                    // Some permissions are not granted
//                    grantedAllPermissions = false
//
//                    if (!ActivityCompat.shouldShowRequestPermissionRationale(
//                            activity!!,
//                            permission
//                        )
//                    ) {
//                        neverAskAgainPermissionList.add(permission)
//                    } else {
//                        deniedPermissionList.add(permission)
//                    }
//                }
//            }
//
//            if (grantedAllPermissions) { //All permissions are granted
//                listener.granted()
//            } else {
//                if (deniedPermissionList.isNotEmpty()) {
//                    listener.denied(deniedPermissionList)
//                }
//                if (neverAskAgainPermissionList.isNotEmpty()) {
//                    listener.neverAskAgain(neverAskAgainPermissionList)
//                }
//            }
//
//            fragmentManager?.beginTransaction()?.remove(this)?.commitAllowingStateLoss()
//        }
//    }
}


