/*
 * Decompiled with CFR 0.152.
 */
package com.rm.freedrawview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.os.AsyncTask;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.rm.freedrawview.FreeDrawHelper;
import com.rm.freedrawview.FreeDrawSavedState;
import com.rm.freedrawview.FreeDrawSerializableState;
import com.rm.freedrawview.HistoryPath;
import com.rm.freedrawview.PathDrawnListener;
import com.rm.freedrawview.PathRedoUndoCountChangeListener;
import com.rm.freedrawview.Point;
import com.rm.freedrawview.R;
import com.rm.freedrawview.ResizeBehaviour;
import java.util.ArrayList;
import java.util.Collections;

public class FreeDrawView
extends View
implements View.OnTouchListener {
    private static final String TAG = FreeDrawView.class.getSimpleName();
    private static final float DEFAULT_STROKE_WIDTH = 4.0f;
    private static final int DEFAULT_COLOR = -16777216;
    private static final int DEFAULT_ALPHA = 255;
    private Paint mCurrentPaint;
    private Path mCurrentPath;
    private ResizeBehaviour mResizeBehaviour;
    private ArrayList<Point> mPoints = new ArrayList();
    private ArrayList<HistoryPath> mPaths = new ArrayList();
    private ArrayList<HistoryPath> mCanceledPaths = new ArrayList();
    @ColorInt
    private int mPaintColor = -16777216;
    @IntRange(from=0L, to=255L)
    private int mPaintAlpha = 255;
    private int mLastDimensionW = -1;
    private int mLastDimensionH = -1;
    private boolean mFinishPath = false;
    private PathDrawnListener mPathDrawnListener;
    private PathRedoUndoCountChangeListener mPathRedoUndoCountChangeListener;

    public FreeDrawView(Context context) {
        this(context, null);
    }

    public FreeDrawView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FreeDrawView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOnTouchListener(this);
        TypedArray a = null;
        try {
            a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.FreeDrawView, defStyleAttr, 0);
            this.initPaints(a);
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.mPoints.size() > 0) {
            this.createHistoryPathFromPoints();
        }
        return new FreeDrawSavedState(superState, this.mPaths, this.mCanceledPaths, this.getPaintWidth(), this.getPaintColor(), this.getPaintAlpha(), this.getResizeBehaviour(), this.mLastDimensionW, this.mLastDimensionH);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof FreeDrawSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        FreeDrawSavedState savedState = (FreeDrawSavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mPaths = savedState.getPaths();
        this.mCanceledPaths = savedState.getCanceledPaths();
        this.mCurrentPaint = savedState.getCurrentPaint();
        this.setPaintWidthPx(savedState.getCurrentPaintWidth());
        this.setPaintColor(savedState.getPaintColor());
        this.setPaintAlpha(savedState.getPaintAlpha());
        this.setResizeBehaviour(savedState.getResizeBehaviour());
        this.mLastDimensionW = savedState.getLastDimensionW();
        this.mLastDimensionH = savedState.getLastDimensionH();
        this.notifyRedoUndoCountChanged();
    }

    public void setPaintColor(@ColorInt int color) {
        this.invalidate();
        this.mPaintColor = color;
        this.mCurrentPaint.setColor(this.mPaintColor);
        this.mCurrentPaint.setAlpha(this.mPaintAlpha);
    }

    @ColorInt
    public int getPaintColor() {
        return this.mPaintColor;
    }

    @ColorInt
    public int getPaintColorWithAlpha() {
        return this.mCurrentPaint.getColor();
    }

    public void setPaintWidthPx(@FloatRange(from=0.0) float widthPx) {
        if (widthPx > 0.0f) {
            this.invalidate();
            this.mCurrentPaint.setStrokeWidth(widthPx);
        }
    }

    public void setPaintWidthDp(float dp) {
        this.setPaintWidthPx(FreeDrawHelper.convertDpToPixels(dp));
    }

    @FloatRange(from=0.0)
    public float getPaintWidth() {
        return this.getPaintWidth(false);
    }

    @FloatRange(from=0.0)
    public float getPaintWidth(boolean inDp) {
        if (inDp) {
            return FreeDrawHelper.convertPixelsToDp(this.mCurrentPaint.getStrokeWidth());
        }
        return this.mCurrentPaint.getStrokeWidth();
    }

    public void setPaintAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.invalidate();
        this.mPaintAlpha = alpha;
        this.mCurrentPaint.setAlpha(this.mPaintAlpha);
    }

    @IntRange(from=0L, to=255L)
    public int getPaintAlpha() {
        return this.mPaintAlpha;
    }

    public void setResizeBehaviour(ResizeBehaviour newBehaviour) {
        this.mResizeBehaviour = newBehaviour;
    }

    public ResizeBehaviour getResizeBehaviour() {
        return this.mResizeBehaviour;
    }

    public void undoLast() {
        if (this.mPaths.size() > 0) {
            this.mFinishPath = true;
            this.invalidate();
            this.mCanceledPaths.add(this.mPaths.get(this.mPaths.size() - 1));
            this.mPaths.remove(this.mPaths.size() - 1);
            this.invalidate();
            this.notifyRedoUndoCountChanged();
        }
    }

    public void redoLast() {
        if (this.mCanceledPaths.size() > 0) {
            this.mPaths.add(this.mCanceledPaths.get(this.mCanceledPaths.size() - 1));
            this.mCanceledPaths.remove(this.mCanceledPaths.size() - 1);
            this.invalidate();
            this.notifyRedoUndoCountChanged();
        }
    }

    public void undoAll() {
        Collections.reverse(this.mPaths);
        this.mCanceledPaths.addAll(this.mPaths);
        this.mPaths = new ArrayList();
        this.invalidate();
        this.notifyRedoUndoCountChanged();
    }

    public void redoAll() {
        if (this.mCanceledPaths.size() > 0) {
            this.mPaths.addAll(this.mCanceledPaths);
            this.mCanceledPaths = new ArrayList();
            this.invalidate();
            this.notifyRedoUndoCountChanged();
        }
    }

    public int getUndoCount() {
        return this.mPaths.size();
    }

    public int getRedoCount() {
        return this.mCanceledPaths.size();
    }

    public int getPathCount(boolean includeCurrentlyDrawingPath) {
        int size = this.mPaths.size();
        if (includeCurrentlyDrawingPath && this.mPoints.size() > 0) {
            ++size;
        }
        return size;
    }

    public void setOnPathDrawnListener(PathDrawnListener listener) {
        this.mPathDrawnListener = listener;
    }

    public void removePathDrawnListener() {
        this.mPathDrawnListener = null;
    }

    public void clearDrawAndHistory() {
        this.clearDraw(false);
        this.clearHistory(true);
    }

    public void clearDraw() {
        this.clearDraw(true);
    }

    private void clearDraw(boolean invalidate) {
        this.mPoints = new ArrayList();
        this.mPaths = new ArrayList();
        this.notifyRedoUndoCountChanged();
        if (invalidate) {
            this.invalidate();
        }
    }

    public void clearHistory() {
        this.clearHistory(true);
    }

    private void clearHistory(boolean invalidate) {
        this.mCanceledPaths = new ArrayList();
        this.notifyRedoUndoCountChanged();
        if (invalidate) {
            this.invalidate();
        }
    }

    public void setPathRedoUndoCountChangeListener(PathRedoUndoCountChangeListener listener) {
        this.mPathRedoUndoCountChangeListener = listener;
    }

    public void removePathRedoUndoCountChangeListener() {
        this.mPathRedoUndoCountChangeListener = null;
    }

    public FreeDrawSerializableState getCurrentViewStateAsSerializable() {
        return new FreeDrawSerializableState(this.mCanceledPaths, this.mPaths, this.getPaintColor(), this.getPaintAlpha(), this.getPaintWidth(), this.getResizeBehaviour(), this.mLastDimensionW, this.mLastDimensionH);
    }

    public void restoreStateFromSerializable(FreeDrawSerializableState state) {
        if (state != null) {
            if (state.getCanceledPaths() != null) {
                this.mCanceledPaths = state.getCanceledPaths();
            }
            if (state.getPaths() != null) {
                this.mPaths = state.getPaths();
            }
            this.mPaintColor = state.getPaintColor();
            this.mPaintAlpha = state.getPaintAlpha();
            this.mCurrentPaint.setColor(state.getPaintColor());
            this.mCurrentPaint.setAlpha(state.getPaintAlpha());
            this.setPaintWidthPx(state.getPaintWidth());
            this.mResizeBehaviour = state.getResizeBehaviour();
            if (state.getLastDimensionW() >= 0) {
                this.mLastDimensionW = state.getLastDimensionW();
            }
            if (state.getLastDimensionH() >= 0) {
                this.mLastDimensionH = state.getLastDimensionH();
            }
            this.notifyRedoUndoCountChanged();
            this.invalidate();
        }
    }

    public void getDrawScreenshot(@NonNull DrawCreatorListener listener) {
        new TakeScreenShotAsyncTask(listener).execute(new Void[0]);
    }

    private void notifyPathStart() {
        if (this.mPathDrawnListener != null) {
            this.mPathDrawnListener.onPathStart();
        }
    }

    private void notifyPathDrawn() {
        if (this.mPathDrawnListener != null) {
            this.mPathDrawnListener.onNewPathDrawn();
        }
    }

    private void notifyRedoUndoCountChanged() {
        if (this.mPathRedoUndoCountChangeListener != null) {
            this.mPathRedoUndoCountChangeListener.onRedoCountChanged(this.getRedoCount());
            this.mPathRedoUndoCountChangeListener.onUndoCountChanged(this.getUndoCount());
        }
    }

    private void initPaints(TypedArray a) {
        this.mCurrentPaint = FreeDrawHelper.createPaint();
        this.mCurrentPaint.setColor(a != null ? a.getColor(R.styleable.FreeDrawView_paintColor, this.mPaintColor) : this.mPaintColor);
        this.mCurrentPaint.setAlpha(a != null ? a.getInt(R.styleable.FreeDrawView_paintAlpha, this.mPaintAlpha) : this.mPaintAlpha);
        this.mCurrentPaint.setStrokeWidth(a != null ? (float)a.getDimensionPixelSize(R.styleable.FreeDrawView_paintWidth, (int)FreeDrawHelper.convertDpToPixels(4.0f)) : FreeDrawHelper.convertDpToPixels(4.0f));
        FreeDrawHelper.setupStrokePaint(this.mCurrentPaint);
        if (a != null) {
            int resizeBehaviour = a.getInt(R.styleable.FreeDrawView_resizeBehaviour, -1);
            this.mResizeBehaviour = resizeBehaviour == 0 ? ResizeBehaviour.CLEAR : (resizeBehaviour == 1 ? ResizeBehaviour.FIT_XY : (resizeBehaviour == 2 ? ResizeBehaviour.CROP : ResizeBehaviour.CROP));
        }
    }

    private Paint createAndCopyColorAndAlphaForFillPaint(Paint from, boolean copyWidth) {
        Paint paint = FreeDrawHelper.createPaint();
        FreeDrawHelper.setupFillPaint(paint);
        paint.setColor(from.getColor());
        paint.setAlpha(from.getAlpha());
        if (copyWidth) {
            paint.setStrokeWidth(from.getStrokeWidth());
        }
        return paint;
    }

    protected synchronized void onDraw(Canvas canvas) {
        if (this.mPaths.size() == 0 && this.mPoints.size() == 0) {
            return;
        }
        boolean finishedPath = this.mFinishPath;
        this.mFinishPath = false;
        for (HistoryPath currentPath : this.mPaths) {
            if (currentPath.isPoint()) {
                canvas.drawCircle(currentPath.getOriginX(), currentPath.getOriginY(), currentPath.getPaint().getStrokeWidth() / 2.0f, currentPath.getPaint());
                continue;
            }
            canvas.drawPath(currentPath.getPath(), currentPath.getPaint());
        }
        if (this.mCurrentPath == null) {
            this.mCurrentPath = new Path();
        } else {
            this.mCurrentPath.rewind();
        }
        if (this.mPoints.size() == 1 || FreeDrawHelper.isAPoint(this.mPoints)) {
            canvas.drawCircle(this.mPoints.get((int)0).x, this.mPoints.get((int)0).y, this.mCurrentPaint.getStrokeWidth() / 2.0f, this.createAndCopyColorAndAlphaForFillPaint(this.mCurrentPaint, false));
        } else if (this.mPoints.size() != 0) {
            boolean first = true;
            for (Point point : this.mPoints) {
                if (first) {
                    this.mCurrentPath.moveTo(point.x, point.y);
                    first = false;
                    continue;
                }
                this.mCurrentPath.lineTo(point.x, point.y);
            }
            canvas.drawPath(this.mCurrentPath, this.mCurrentPaint);
        }
        if (finishedPath && this.mPoints.size() > 0) {
            this.createHistoryPathFromPoints();
        }
    }

    private void createHistoryPathFromPoints() {
        this.mPaths.add(new HistoryPath(this.mPoints, new Paint(this.mCurrentPaint)));
        this.mPoints = new ArrayList();
        this.notifyPathDrawn();
        this.notifyRedoUndoCountChanged();
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (motionEvent.getAction() == 0) {
            this.notifyPathStart();
        }
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
        }
        this.mCanceledPaths = new ArrayList();
        if (motionEvent.getAction() != 1 && motionEvent.getAction() != 3) {
            Point point;
            for (int i = 0; i < motionEvent.getHistorySize(); ++i) {
                point = new Point();
                point.x = motionEvent.getHistoricalX(i);
                point.y = motionEvent.getHistoricalY(i);
                this.mPoints.add(point);
            }
            point = new Point();
            point.x = motionEvent.getX();
            point.y = motionEvent.getY();
            this.mPoints.add(point);
            this.mFinishPath = false;
        } else {
            this.mFinishPath = true;
        }
        this.invalidate();
        return true;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        float xMultiplyFactor = 1.0f;
        float yMultiplyFactor = 1.0f;
        if (this.mLastDimensionW == -1) {
            this.mLastDimensionW = w;
        }
        if (this.mLastDimensionH == -1) {
            this.mLastDimensionH = h;
        }
        if (w >= 0 && w != oldw && w != this.mLastDimensionW) {
            xMultiplyFactor = (float)w / (float)this.mLastDimensionW;
            this.mLastDimensionW = w;
        }
        if (h >= 0 && h != oldh && h != this.mLastDimensionH) {
            yMultiplyFactor = (float)h / (float)this.mLastDimensionH;
            this.mLastDimensionH = h;
        }
        this.multiplyPathsAndPoints(xMultiplyFactor, yMultiplyFactor);
    }

    private void multiplyPathsAndPoints(float xMultiplyFactor, float yMultiplyFactor) {
        if (xMultiplyFactor == 1.0f && yMultiplyFactor == 1.0f || xMultiplyFactor <= 0.0f || yMultiplyFactor <= 0.0f || this.mPaths.size() == 0 && this.mCanceledPaths.size() == 0 && this.mPoints.size() == 0) {
            return;
        }
        if (this.mResizeBehaviour == ResizeBehaviour.CLEAR) {
            this.mPaths = new ArrayList();
            this.mCanceledPaths = new ArrayList();
            this.mPoints = new ArrayList();
            return;
        }
        if (this.mResizeBehaviour == ResizeBehaviour.CROP) {
            yMultiplyFactor = 1.0f;
            xMultiplyFactor = 1.0f;
        }
        for (HistoryPath historyPath : this.mPaths) {
            if (historyPath.isPoint()) {
                historyPath.setOriginX(historyPath.getOriginX() * xMultiplyFactor);
                historyPath.setOriginY(historyPath.getOriginY() * yMultiplyFactor);
            } else {
                for (Point point : historyPath.getPoints()) {
                    point.x *= xMultiplyFactor;
                    point.y *= yMultiplyFactor;
                }
            }
            historyPath.generatePath();
        }
        for (HistoryPath historyPath : this.mCanceledPaths) {
            if (historyPath.isPoint()) {
                historyPath.setOriginX(historyPath.getOriginX() * xMultiplyFactor);
                historyPath.setOriginY(historyPath.getOriginY() * yMultiplyFactor);
            } else {
                for (Point point : historyPath.getPoints()) {
                    point.x *= xMultiplyFactor;
                    point.y *= yMultiplyFactor;
                }
            }
            historyPath.generatePath();
        }
        for (Point point : this.mPoints) {
            point.x *= xMultiplyFactor;
            point.y *= yMultiplyFactor;
        }
    }

    private class TakeScreenShotAsyncTask
    extends AsyncTask<Void, Void, Void> {
        private int mWidth;
        private int mHeight;
        private Canvas mCanvas;
        private Bitmap mBitmap;
        private DrawCreatorListener mListener;

        public TakeScreenShotAsyncTask(DrawCreatorListener listener) {
            this.mListener = listener;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.mWidth = FreeDrawView.this.getWidth();
            this.mHeight = FreeDrawView.this.getHeight();
        }

        protected Void doInBackground(Void ... params) {
            try {
                this.mBitmap = Bitmap.createBitmap((int)this.mWidth, (int)this.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mCanvas = new Canvas(this.mBitmap);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.cancel(true);
            }
            return null;
        }

        protected void onCancelled() {
            super.onCancelled();
            if (this.mListener != null) {
                this.mListener.onDrawCreationError();
            }
        }

        protected void onPostExecute(Void aVoid) {
            super.onPostExecute((Object)aVoid);
            FreeDrawView.this.draw(this.mCanvas);
            if (this.mListener != null) {
                this.mListener.onDrawCreated(this.mBitmap);
            }
        }
    }

    public static interface DrawCreatorListener {
        public void onDrawCreated(Bitmap var1);

        public void onDrawCreationError();
    }
}

