/*
 * Decompiled with CFR 0.152.
 */
package com.rm.freedrawview;

import android.graphics.Paint;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.view.View;
import com.rm.freedrawview.FreeDrawHelper;
import com.rm.freedrawview.HistoryPath;
import com.rm.freedrawview.ResizeBehaviour;
import java.io.Serializable;
import java.util.ArrayList;

class FreeDrawSavedState
extends View.BaseSavedState {
    private ArrayList<HistoryPath> mPaths = new ArrayList();
    private ArrayList<HistoryPath> mCanceledPaths = new ArrayList();
    private int mPaintColor;
    private int mPaintAlpha;
    private float mPaintWidth;
    private ResizeBehaviour mResizeBehaviour;
    private int mLastDimensionW;
    private int mLastDimensionH;
    public static final Parcelable.Creator<FreeDrawSavedState> CREATOR = new Parcelable.Creator<FreeDrawSavedState>(){

        public FreeDrawSavedState createFromParcel(Parcel in) {
            return new FreeDrawSavedState(in);
        }

        public FreeDrawSavedState[] newArray(int size) {
            return new FreeDrawSavedState[size];
        }
    };

    FreeDrawSavedState(Parcelable superState, ArrayList<HistoryPath> paths, ArrayList<HistoryPath> canceledPaths, float paintWidth, int paintColor, int paintAlpha, ResizeBehaviour resizeBehaviour, int lastDimensionW, int lastDimensionH) {
        super(superState);
        this.mPaths = paths;
        this.mCanceledPaths = canceledPaths;
        this.mPaintWidth = paintWidth;
        this.mPaintColor = paintColor;
        this.mPaintAlpha = paintAlpha;
        this.mResizeBehaviour = resizeBehaviour;
        this.mLastDimensionW = lastDimensionW;
        this.mLastDimensionH = lastDimensionH;
    }

    ArrayList<HistoryPath> getPaths() {
        return this.mPaths;
    }

    ArrayList<HistoryPath> getCanceledPaths() {
        return this.mCanceledPaths;
    }

    @ColorInt
    int getPaintColor() {
        return this.mPaintColor;
    }

    @IntRange(from=0L, to=255L)
    int getPaintAlpha() {
        return this.mPaintAlpha;
    }

    float getCurrentPaintWidth() {
        return this.mPaintWidth;
    }

    Paint getCurrentPaint() {
        Paint paint = FreeDrawHelper.createPaint();
        FreeDrawHelper.setupStrokePaint(paint);
        FreeDrawHelper.copyFromValues(paint, this.mPaintColor, this.mPaintAlpha, this.mPaintWidth, true);
        return paint;
    }

    ResizeBehaviour getResizeBehaviour() {
        return this.mResizeBehaviour;
    }

    int getLastDimensionW() {
        return this.mLastDimensionW;
    }

    int getLastDimensionH() {
        return this.mLastDimensionH;
    }

    private FreeDrawSavedState(Parcel in) {
        super(in);
        in.readTypedList(this.mPaths, HistoryPath.CREATOR);
        in.readTypedList(this.mCanceledPaths, HistoryPath.CREATOR);
        this.mPaintColor = in.readInt();
        this.mPaintAlpha = in.readInt();
        this.mPaintWidth = in.readFloat();
        this.mResizeBehaviour = (ResizeBehaviour)((Object)in.readSerializable());
        this.mLastDimensionW = in.readInt();
        this.mLastDimensionH = in.readInt();
    }

    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeTypedList(this.mPaths);
        out.writeTypedList(this.mCanceledPaths);
        out.writeInt(this.mPaintColor);
        out.writeInt(this.mPaintAlpha);
        out.writeFloat(this.mPaintWidth);
        out.writeSerializable((Serializable)((Object)this.mResizeBehaviour));
        out.writeInt(this.mLastDimensionW);
        out.writeInt(this.mLastDimensionH);
    }
}

