/*
 * Decompiled with CFR 0.152.
 */
package com.riningan.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.text.Layout;
import android.util.AttributeSet;
import android.widget.TextView;
import com.riningan.widget.glowtextview.R;
import java.util.ArrayList;

@SuppressLint(value={"AppCompatCustomView"})
public class GlowTextView
extends TextView {
    private Paint mTextPaint;
    private Paint mCirclePaint;
    private Paint mAlphaPaint;
    private float mGlowRadius;
    private int mGlowColor;
    private Rect mBounds = new Rect();
    private ArrayList<String> mRows = new ArrayList();

    public GlowTextView(Context context) {
        super(context);
        this.init(null);
    }

    public GlowTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public GlowTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public void setTextSize(float size) {
        if (this.mTextPaint != null) {
            this.mTextPaint.setTextSize(size);
        }
        super.setTextSize(size);
    }

    public void setTextSize(int unit, float size) {
        if (this.mTextPaint != null) {
            this.mTextPaint.setTextSize(size);
        }
        super.setTextSize(unit, size);
    }

    public void setTypeface(Typeface tf) {
        if (this.mTextPaint != null) {
            this.mTextPaint.setTypeface(tf);
        }
        super.setTypeface(tf);
    }

    public void setTypeface(Typeface tf, int style) {
        if (this.mTextPaint != null) {
            this.mTextPaint.setTypeface(tf);
        }
        super.setTypeface(tf, style);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        Bitmap circleBitmap = Bitmap.createBitmap((int)canvas.getWidth(), (int)canvas.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas circleCanvas = new Canvas(circleBitmap);
        Layout layout = this.getLayout();
        String text = this.getText().toString();
        int start = 0;
        this.mRows.clear();
        for (int i = 0; i < this.getLineCount(); ++i) {
            int end = layout.getLineEnd(i);
            this.mRows.add(text.substring(start, end));
            start = end;
        }
        Paint.FontMetrics fm = this.mTextPaint.getFontMetrics();
        float top = (float)this.getPaddingTop() + fm.descent - fm.ascent * 0.9f;
        for (String row : this.mRows) {
            if (row.length() == 0) continue;
            float left = this.getPaddingLeft();
            for (int i = 0; i < row.length(); ++i) {
                String curChar = String.valueOf(row.charAt(i));
                float curCharWidth = this.mTextPaint.measureText(curChar);
                if (!curChar.equals(" ")) {
                    this.mTextPaint.getTextBounds(curChar, 0, 1, this.mBounds);
                    circleCanvas.drawCircle(left + (float)((this.mBounds.right + this.mBounds.left) / 2), top + (float)((this.mBounds.bottom + this.mBounds.top) / 2), this.mGlowRadius, this.mCirclePaint);
                }
                left += curCharWidth;
            }
            top += (float)this.getLineHeight();
        }
        Bitmap alphaBitmap = circleBitmap.extractAlpha();
        circleBitmap.recycle();
        canvas.drawBitmap(alphaBitmap, 0.0f, 0.0f, this.mAlphaPaint);
        alphaBitmap.recycle();
        super.onDraw(canvas);
    }

    public float getGlowRadius() {
        return this.mGlowRadius;
    }

    public void setGlowRadius(float glowRadius) {
        this.mGlowRadius = glowRadius;
        this.postInvalidate();
    }

    @ColorInt
    public int getGlowColor() {
        return this.mGlowColor;
    }

    public void setGlowColor(@ColorInt int glowColor) {
        this.mGlowColor = glowColor;
        this.mAlphaPaint.setColor(this.mGlowColor);
        this.postInvalidate();
    }

    private void init(@Nullable AttributeSet attrs) {
        this.setLayerType(1, null);
        if (attrs == null) {
            this.mGlowRadius = 60.0f;
            this.mGlowColor = -1;
        } else {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.GlowTextView);
            this.mGlowRadius = a.getDimension(R.styleable.GlowTextView_glowRadius, 60.0f);
            this.mGlowColor = a.getColor(R.styleable.GlowTextView_glowColor, -1);
        }
        this.mTextPaint = new Paint(1);
        this.mTextPaint.setTextSize(this.getTextSize());
        this.mTextPaint.setTypeface(this.getTypeface());
        this.mCirclePaint = new Paint(1);
        this.mAlphaPaint = new Paint(1);
        this.mAlphaPaint.setColor(this.mGlowColor);
        this.mAlphaPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(this.mGlowRadius, BlurMaskFilter.Blur.NORMAL));
    }
}

