/*
 * Decompiled with CFR 0.152.
 */
package com.riningan.util;

import android.os.Process;
import android.util.Pair;
import com.riningan.util.LoggerConfig;
import com.riningan.util.MessageType;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;

public class Log {
    private final LoggerConfig mConfig;
    private final Semaphore mSemaphore = new Semaphore(1, true);
    private final LinkedList<Pair<MessageType, String>> mLogQueue = new LinkedList();
    private Object mThis = null;

    Log(LoggerConfig config) {
        this.mConfig = config;
    }

    void forThis(Object object) {
        if (this.mConfig.isEnabled()) {
            try {
                this.mSemaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mThis = object;
        }
    }

    public void debug() {
        if (this.mConfig.isEnabled()) {
            String msg = this.getClassAndMethod();
            this.addDebug(msg);
            this.mThis = null;
            this.mSemaphore.release();
        }
    }

    public void debug(String message) {
        if (this.mConfig.isEnabled()) {
            String msg = this.getClassAndMethod() + " - " + message;
            this.addDebug(msg);
            this.mThis = null;
            this.mSemaphore.release();
        }
    }

    public void debug(String param, String value) {
        if (this.mConfig.isEnabled()) {
            String msg = this.getClassAndMethod() + "(" + param + " = " + value + ")";
            this.addDebug(msg);
            this.mThis = null;
            this.mSemaphore.release();
        }
    }

    public void debug(String param, boolean value) {
        if (this.mConfig.isEnabled()) {
            String msg = this.getClassAndMethod() + "(" + param + " = " + value + ")";
            this.addDebug(msg);
            this.mThis = null;
            this.mSemaphore.release();
        }
    }

    public void debug(String param, int value) {
        if (this.mConfig.isEnabled()) {
            String msg = this.getClassAndMethod() + "(" + param + " = " + value + ")";
            this.addDebug(msg);
            this.mThis = null;
            this.mSemaphore.release();
        }
    }

    public void debug(String param, long value) {
        if (this.mConfig.isEnabled()) {
            String msg = this.getClassAndMethod() + "(" + param + " = " + value + ")";
            this.addDebug(msg);
            this.mThis = null;
            this.mSemaphore.release();
        }
    }

    public void debug(String param, float value) {
        if (this.mConfig.isEnabled()) {
            String msg = this.getClassAndMethod() + "(" + param + " = " + value + ")";
            this.addDebug(msg);
            this.mThis = null;
            this.mSemaphore.release();
        }
    }

    public void debug(String param, double value) {
        if (this.mConfig.isEnabled()) {
            String msg = this.getClassAndMethod() + "(" + param + " = " + value + ")";
            this.addDebug(msg);
            this.mThis = null;
            this.mSemaphore.release();
        }
    }

    public void debug(String param, String value, String ... params) {
        if (this.mConfig.isEnabled()) {
            StringBuilder msg = new StringBuilder(this.getClassAndMethod() + "(" + param + " = " + value);
            for (int i = 0; i < params.length - 1; i += 2) {
                msg.append(", ").append(params[i]).append(" = ").append(params[i + 1]);
            }
            if (params.length % 2 == 0) {
                msg.append(")");
            } else {
                msg.append(") - ").append(params[params.length - 1]);
            }
            this.addDebug(msg.toString());
            this.mThis = null;
            this.mSemaphore.release();
        }
    }

    public void error(String message) {
        if (this.mConfig.isEnabled()) {
            int line = Thread.currentThread().getStackTrace()[4].getLineNumber();
            String msg = this.getClassAndMethod() + "(" + Integer.toString(line) + ") - " + message;
            this.addError(msg);
            this.mThis = null;
            this.mSemaphore.release();
        }
    }

    public void error(Throwable throwable) {
        if (this.mConfig.isEnabled()) {
            int line = Thread.currentThread().getStackTrace()[4].getLineNumber();
            String msg = this.getClassAndMethod() + "(" + Integer.toString(line) + ") - " + throwable.getMessage();
            this.addError(msg);
            this.mThis = null;
            this.mSemaphore.release();
        }
    }

    public void info() {
        if (this.mConfig.isEnabled()) {
            String msg = this.getClassAndMethod();
            this.addInfo(msg);
            this.mThis = null;
            this.mSemaphore.release();
        }
    }

    public void info(String message) {
        if (this.mConfig.isEnabled()) {
            String msg = this.getClassAndMethod() + " - " + message;
            this.addInfo(msg);
            this.mThis = null;
            this.mSemaphore.release();
        }
    }

    private synchronized void addDebug(String message) {
        String fullMessage = this.getPrefix() + ": " + message;
        android.util.Log.d((String)MessageType.DEBUG.name(), (String)fullMessage);
        this.addToQueue(MessageType.DEBUG, fullMessage);
        this.mConfig.onNewMessage(MessageType.DEBUG, fullMessage);
    }

    private synchronized void addError(String message) {
        String fullMessage = this.getPrefix() + ": " + message;
        android.util.Log.e((String)MessageType.ERROR.name(), (String)fullMessage);
        this.addToQueue(MessageType.ERROR, fullMessage);
        this.mConfig.onNewMessage(MessageType.ERROR, fullMessage);
    }

    private synchronized void addInfo(String message) {
        String fullMessage = this.getPrefix() + ": " + message;
        android.util.Log.i((String)MessageType.INFO.name(), (String)fullMessage);
        this.addToQueue(MessageType.INFO, fullMessage);
        this.mConfig.onNewMessage(MessageType.INFO, fullMessage);
    }

    private String getClassAndMethod() {
        String methodName;
        String className;
        if (this.mThis == null) {
            className = Thread.currentThread().getStackTrace()[5].getClassName();
            methodName = Thread.currentThread().getStackTrace()[5].getMethodName();
        } else {
            className = this.mThis.getClass().getName();
            methodName = Thread.currentThread().getStackTrace()[4].getMethodName();
        }
        return className.substring(this.mConfig.getApplicationIdLength()) + "." + methodName;
    }

    private String getPrefix() {
        return this.mConfig.getPreffix() + "time(" + this.mConfig.getDateTime() + "): process(" + Process.myPid() + "): thread(" + Thread.currentThread().getId() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToQueue(MessageType type, String msg) {
        LinkedList<Pair<MessageType, String>> linkedList = this.mLogQueue;
        synchronized (linkedList) {
            if (this.mLogQueue.size() > 100) {
                this.mLogQueue.removeFirst();
            }
            this.mLogQueue.add((Pair<MessageType, String>)new Pair((Object)type, (Object)msg));
        }
    }
}

