/*
 * Decompiled with CFR 0.152.
 */
package com.riningan.util;

import android.annotation.SuppressLint;
import com.riningan.util.MessageType;
import com.riningan.util.OnMessageListener;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LoggerConfig {
    private int mApplicationIdLength = 0;
    private String mPreffix = "";
    @SuppressLint(value={"SimpleDateFormat"})
    private SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd: HH:mm:ss");
    private OnMessageListener mListener = null;

    LoggerConfig() {
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public LoggerConfig setDateFormat(String format) {
        this.dt = new SimpleDateFormat(format);
        return this;
    }

    public LoggerConfig removeApplicationId(String applicationId) {
        this.mApplicationIdLength = applicationId.length() + 1;
        return this;
    }

    public LoggerConfig addPreffix(String preffix) {
        this.mPreffix = preffix + ": ";
        return this;
    }

    public LoggerConfig setOnMessageListener(OnMessageListener listener) {
        this.mListener = listener;
        return this;
    }

    String getDateTime() {
        return this.dt.format(new Date());
    }

    int getApplicationIdLength() {
        return this.mApplicationIdLength;
    }

    String getPreffix() {
        return this.mPreffix;
    }

    void onNewMessage(MessageType type, String message) {
        if (this.mListener != null) {
            this.mListener.onNewMessage(type, message);
        }
    }
}

