/*
 * Decompiled with CFR 0.152.
 */
package com.rexsl.w3c;

import com.jcabi.aspects.Loggable;
import com.jcabi.http.Request;
import com.jcabi.http.request.JdkRequest;
import com.jcabi.log.Logger;
import com.jcabi.manifests.Manifests;
import com.jcabi.xml.XML;
import com.rexsl.w3c.DefaultValidationResponse;
import com.rexsl.w3c.Defect;
import com.rexsl.w3c.ValidationResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.Charsets;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;

@Loggable(value=1)
class BaseValidator {
    protected static final String USER_AGENT = String.format("ReXSL-W3C %s %s %s", Manifests.read((String)"ReXSL-Version"), Manifests.read((String)"ReXSL-Build"), Manifests.read((String)"ReXSL-Date"));
    protected static final String BOUNDARY = "vV9olNqRj00PC4OIlM7";

    BaseValidator() {
    }

    protected final Request request(String uri, String entity) {
        return new JdkRequest(uri).method("POST").body().set(entity).back().header("User-Agent", (Object)USER_AGENT).header("Accept", (Object)"application/soap+xml").header("Content-Type", (Object)Logger.format((String)"%s; boundary=%s", (Object[])new Object[]{"multipart/form-data", BOUNDARY}));
    }

    protected final String entity(String name, String content, String type) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MultipartEntityBuilder.create().setStrictMode().setCharset(Charsets.UTF_8).setBoundary(BOUNDARY).addBinaryBody(name, content.getBytes(Charsets.UTF_8), ContentType.create((String)type, (Charset)Charsets.UTF_8), "file").addTextBody("output", "soap12").build().writeTo((OutputStream)baos);
        return baos.toString("UTF-8");
    }

    protected final ValidationResponse build(XML soap) {
        DefaultValidationResponse resp = new DefaultValidationResponse("true".equals(BaseValidator.textOf(soap.xpath("//m:validity/text()"))), UriBuilder.fromUri((String)BaseValidator.textOf(soap.xpath("//m:checkedby/text()"))).build(new Object[0]), BaseValidator.textOf(soap.xpath("//m:doctype/text()")), BaseValidator.charset(BaseValidator.textOf(soap.xpath("//m:charset/text()"))));
        for (XML node : soap.nodes("//m:error")) {
            resp.addError(this.defect(node));
        }
        for (XML node : soap.nodes("//m:warning")) {
            resp.addWarning(this.defect(node));
        }
        return resp;
    }

    protected final ValidationResponse failure(Throwable error) {
        DefaultValidationResponse resp = new DefaultValidationResponse(false, URI.create("http://localhost/failure"), "unknown-doctype", Charset.defaultCharset());
        String message = error.getMessage();
        if (message == null) {
            message = "";
        }
        resp.addError(new Defect(0, 0, "", Logger.format((String)"%[exception]s", (Object[])new Object[]{error}), "", message));
        return resp;
    }

    protected final ValidationResponse success(String type) {
        DefaultValidationResponse resp = new DefaultValidationResponse(true, URI.create("http://localhost/success"), type, Charset.defaultCharset());
        return resp;
    }

    private Defect defect(XML node) {
        return new Defect(BaseValidator.intOf(node.xpath("m:line/text()")), BaseValidator.intOf(node.xpath("m:col/text()")), BaseValidator.textOf(node.xpath("m:source/text()")), BaseValidator.textOf(node.xpath("m:explanation/text()")), BaseValidator.textOf(node.xpath("m:messageid/text()")), BaseValidator.textOf(node.xpath("m:message/text()")));
    }

    private static String textOf(List<String> lines) {
        String text = lines.isEmpty() ? "" : lines.get(0);
        return text;
    }

    private static int intOf(List<String> lines) {
        int value = lines.isEmpty() ? 0 : Integer.parseInt(lines.get(0));
        return value;
    }

    private static Charset charset(String text) {
        Charset charset = text.isEmpty() ? Charset.defaultCharset() : Charset.forName(text);
        return charset;
    }

    public String toString() {
        return "BaseValidator()";
    }
}

