/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.variance.swaps;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.Underlyer;
import fpml.consolidated.eq.shared.DirectionalLegUnderlyerValuation;
import fpml.consolidated.eq.shared.EquityValuation;
import fpml.consolidated.option.shared.FxFeature;
import fpml.consolidated.option.shared.OptionSettlementModel;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.LegIdentifier;
import fpml.consolidated.shared.PayerReceiverModel;
import fpml.consolidated.variance.swaps.VarianceAmount;
import fpml.consolidated.variance.swaps.meta.VarianceLegMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="VarianceLeg", builder=VarianceLegBuilderImpl.class, version="1.2.2")
@RuneDataType(value="VarianceLeg", model="fpml", builder=VarianceLegBuilderImpl.class, version="1.2.2")
public interface VarianceLeg
extends DirectionalLegUnderlyerValuation {
    public static final VarianceLegMeta metaData = new VarianceLegMeta();

    public VarianceAmount getAmount();

    @Override
    public VarianceLeg build();

    @Override
    public VarianceLegBuilder toBuilder();

    public static VarianceLegBuilder builder() {
        return new VarianceLegBuilderImpl();
    }

    default public RosettaMetaData<? extends VarianceLeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends VarianceLeg> getType() {
        return VarianceLeg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legIdentifier"), processor, LegIdentifier.class, this.getLegIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.class, this.getEffectiveDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.class, this.getTerminationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.class, this.getUnderlyer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionSettlementModel"), processor, OptionSettlementModel.class, this.getOptionSettlementModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxFeature"), processor, FxFeature.class, this.getFxFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuation"), processor, EquityValuation.class, this.getValuation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, VarianceAmount.class, this.getAmount(), new AttributeMeta[0]);
    }

    public static class VarianceLegBuilderImpl
    extends DirectionalLegUnderlyerValuation.DirectionalLegUnderlyerValuationBuilderImpl
    implements VarianceLegBuilder {
        protected VarianceAmount.VarianceAmountBuilder amount;

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public VarianceAmount.VarianceAmountBuilder getAmount() {
            return this.amount;
        }

        @Override
        public VarianceAmount.VarianceAmountBuilder getOrCreateAmount() {
            VarianceAmount.VarianceAmountBuilder result = this.amount != null ? this.amount : (this.amount = VarianceAmount.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public VarianceLegBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="legIdentifier")
        @RuneAttribute(value="legIdentifier")
        public VarianceLegBuilder addLegIdentifier(LegIdentifier _legIdentifier) {
            if (_legIdentifier != null) {
                this.legIdentifier.add(_legIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public VarianceLegBuilder addLegIdentifier(LegIdentifier _legIdentifier, int idx) {
            this.getIndex(this.legIdentifier, idx, () -> _legIdentifier.toBuilder());
            return this;
        }

        @Override
        public VarianceLegBuilder addLegIdentifier(List<? extends LegIdentifier> legIdentifiers) {
            if (legIdentifiers != null) {
                for (LegIdentifier legIdentifier : legIdentifiers) {
                    this.legIdentifier.add(legIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="legIdentifier")
        public VarianceLegBuilder setLegIdentifier(List<? extends LegIdentifier> legIdentifiers) {
            this.legIdentifier = legIdentifiers == null ? new ArrayList() : (List)legIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public VarianceLegBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public VarianceLegBuilder setEffectiveDate(AdjustableOrRelativeDate _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="terminationDate")
        @RuneAttribute(value="terminationDate")
        public VarianceLegBuilder setTerminationDate(AdjustableOrRelativeDate _terminationDate) {
            this.terminationDate = _terminationDate == null ? null : _terminationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyer", isRequired=true)
        @RuneAttribute(value="underlyer", isRequired=true)
        public VarianceLegBuilder setUnderlyer(Underlyer _underlyer) {
            this.underlyer = _underlyer == null ? null : _underlyer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionSettlementModel", isRequired=true)
        @RuneAttribute(value="optionSettlementModel", isRequired=true)
        public VarianceLegBuilder setOptionSettlementModel(OptionSettlementModel _optionSettlementModel) {
            this.optionSettlementModel = _optionSettlementModel == null ? null : _optionSettlementModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxFeature")
        @RuneAttribute(value="fxFeature")
        public VarianceLegBuilder setFxFeature(FxFeature _fxFeature) {
            this.fxFeature = _fxFeature == null ? null : _fxFeature.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="valuation", isRequired=true)
        @RuneAttribute(value="valuation", isRequired=true)
        public VarianceLegBuilder setValuation(EquityValuation _valuation) {
            this.valuation = _valuation == null ? null : _valuation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public VarianceLegBuilder setAmount(VarianceAmount _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        public VarianceLeg build() {
            return new VarianceLegImpl(this);
        }

        @Override
        public VarianceLegBuilder toBuilder() {
            return this;
        }

        @Override
        public VarianceLegBuilder prune() {
            super.prune();
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getAmount() != null && this.getAmount().hasData();
        }

        @Override
        public VarianceLegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            VarianceLegBuilder o = (VarianceLegBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VarianceLeg _that = (VarianceLeg)this.getType().cast(o);
            return Objects.equals(this.amount, _that.getAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VarianceLegBuilder {amount=" + String.valueOf(this.amount) + "} " + super.toString();
        }
    }

    public static interface VarianceLegBuilder
    extends VarianceLeg,
    DirectionalLegUnderlyerValuation.DirectionalLegUnderlyerValuationBuilder {
        public VarianceAmount.VarianceAmountBuilder getOrCreateAmount();

        @Override
        public VarianceAmount.VarianceAmountBuilder getAmount();

        @Override
        public VarianceLegBuilder setId(String var1);

        @Override
        public VarianceLegBuilder addLegIdentifier(LegIdentifier var1);

        @Override
        public VarianceLegBuilder addLegIdentifier(LegIdentifier var1, int var2);

        @Override
        public VarianceLegBuilder addLegIdentifier(List<? extends LegIdentifier> var1);

        @Override
        public VarianceLegBuilder setLegIdentifier(List<? extends LegIdentifier> var1);

        @Override
        public VarianceLegBuilder setPayerReceiverModel(PayerReceiverModel var1);

        @Override
        public VarianceLegBuilder setEffectiveDate(AdjustableOrRelativeDate var1);

        @Override
        public VarianceLegBuilder setTerminationDate(AdjustableOrRelativeDate var1);

        @Override
        public VarianceLegBuilder setUnderlyer(Underlyer var1);

        @Override
        public VarianceLegBuilder setOptionSettlementModel(OptionSettlementModel var1);

        @Override
        public VarianceLegBuilder setFxFeature(FxFeature var1);

        @Override
        public VarianceLegBuilder setValuation(EquityValuation var1);

        public VarianceLegBuilder setAmount(VarianceAmount var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legIdentifier"), processor, LegIdentifier.LegIdentifierBuilder.class, this.getLegIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getEffectiveDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getTerminationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.UnderlyerBuilder.class, (RosettaModelObjectBuilder)this.getUnderlyer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionSettlementModel"), processor, OptionSettlementModel.OptionSettlementModelBuilder.class, (RosettaModelObjectBuilder)this.getOptionSettlementModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxFeature"), processor, FxFeature.FxFeatureBuilder.class, (RosettaModelObjectBuilder)this.getFxFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuation"), processor, EquityValuation.EquityValuationBuilder.class, (RosettaModelObjectBuilder)this.getValuation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, VarianceAmount.VarianceAmountBuilder.class, this.getAmount(), new AttributeMeta[0]);
        }

        @Override
        public VarianceLegBuilder prune();
    }

    public static class VarianceLegImpl
    extends DirectionalLegUnderlyerValuation.DirectionalLegUnderlyerValuationImpl
    implements VarianceLeg {
        private final VarianceAmount amount;

        protected VarianceLegImpl(VarianceLegBuilder builder) {
            super(builder);
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public VarianceAmount getAmount() {
            return this.amount;
        }

        @Override
        public VarianceLeg build() {
            return this;
        }

        @Override
        public VarianceLegBuilder toBuilder() {
            VarianceLegBuilder builder = VarianceLeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(VarianceLegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VarianceLeg _that = (VarianceLeg)this.getType().cast(o);
            return Objects.equals(this.amount, _that.getAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VarianceLeg {amount=" + String.valueOf(this.amount) + "} " + super.toString();
        }
    }
}

