/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.valuation.fpmlreporting;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.PartyTradeIdentifier;
import fpml.consolidated.doc.PartyTradeInformationSimple;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrelationAndOptionalSequenceModel;
import fpml.consolidated.msg.NotificationMessage;
import fpml.consolidated.msg.NotificationMessageHeader;
import fpml.consolidated.msg.ReportIdentification;
import fpml.consolidated.shared.IdentifiedDate;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import fpml.consolidated.valuation.fpmlreporting.ReportContents;
import fpml.consolidated.valuation.fpmlreporting.meta.ValuationReportRetractedMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ValuationReportRetracted", builder=ValuationReportRetractedBuilderImpl.class, version="1.2.2")
@RuneDataType(value="ValuationReportRetracted", model="fpml", builder=ValuationReportRetractedBuilderImpl.class, version="1.2.2")
public interface ValuationReportRetracted
extends NotificationMessage {
    public static final ValuationReportRetractedMeta metaData = new ValuationReportRetractedMeta();

    public ReportIdentification getReportIdentification();

    public ReportContents getReportContents();

    public IdentifiedDate getAsOfDate();

    public List<? extends PartyTradeIdentifier> getPartyTradeIdentifier();

    public List<? extends PartyTradeInformationSimple> getPartyTradeInformation();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public ValuationReportRetracted build();

    @Override
    public ValuationReportRetractedBuilder toBuilder();

    public static ValuationReportRetractedBuilder builder() {
        return new ValuationReportRetractedBuilderImpl();
    }

    default public RosettaMetaData<? extends ValuationReportRetracted> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ValuationReportRetracted> getType() {
        return ValuationReportRetracted.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, NotificationMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.class, this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportIdentification"), processor, ReportIdentification.class, this.getReportIdentification(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportContents"), processor, ReportContents.class, this.getReportContents(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("asOfDate"), processor, IdentifiedDate.class, this.getAsOfDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyTradeIdentifier"), processor, PartyTradeIdentifier.class, this.getPartyTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyTradeInformation"), processor, PartyTradeInformationSimple.class, this.getPartyTradeInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class ValuationReportRetractedBuilderImpl
    extends NotificationMessage.NotificationMessageBuilderImpl
    implements ValuationReportRetractedBuilder {
        protected ReportIdentification.ReportIdentificationBuilder reportIdentification;
        protected ReportContents.ReportContentsBuilder reportContents;
        protected IdentifiedDate.IdentifiedDateBuilder asOfDate;
        protected List<PartyTradeIdentifier.PartyTradeIdentifierBuilder> partyTradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
        protected List<PartyTradeInformationSimple.PartyTradeInformationSimpleBuilder> partyTradeInformation = new ArrayList<PartyTradeInformationSimple.PartyTradeInformationSimpleBuilder>();
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="reportIdentification")
        @RuneAttribute(value="reportIdentification")
        public ReportIdentification.ReportIdentificationBuilder getReportIdentification() {
            return this.reportIdentification;
        }

        @Override
        public ReportIdentification.ReportIdentificationBuilder getOrCreateReportIdentification() {
            ReportIdentification.ReportIdentificationBuilder result = this.reportIdentification != null ? this.reportIdentification : (this.reportIdentification = ReportIdentification.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportContents")
        @RuneAttribute(value="reportContents")
        public ReportContents.ReportContentsBuilder getReportContents() {
            return this.reportContents;
        }

        @Override
        public ReportContents.ReportContentsBuilder getOrCreateReportContents() {
            ReportContents.ReportContentsBuilder result = this.reportContents != null ? this.reportContents : (this.reportContents = ReportContents.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="asOfDate")
        @RuneAttribute(value="asOfDate")
        public IdentifiedDate.IdentifiedDateBuilder getAsOfDate() {
            return this.asOfDate;
        }

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getOrCreateAsOfDate() {
            IdentifiedDate.IdentifiedDateBuilder result = this.asOfDate != null ? this.asOfDate : (this.asOfDate = IdentifiedDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partyTradeIdentifier")
        @RuneAttribute(value="partyTradeIdentifier")
        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getPartyTradeIdentifier() {
            return this.partyTradeIdentifier;
        }

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreatePartyTradeIdentifier(int index) {
            if (this.partyTradeIdentifier == null) {
                this.partyTradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
            }
            return (PartyTradeIdentifier.PartyTradeIdentifierBuilder)this.getIndex(this.partyTradeIdentifier, index, () -> {
                PartyTradeIdentifier.PartyTradeIdentifierBuilder newPartyTradeIdentifier = PartyTradeIdentifier.builder();
                return newPartyTradeIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="partyTradeInformation")
        @RuneAttribute(value="partyTradeInformation")
        public List<? extends PartyTradeInformationSimple.PartyTradeInformationSimpleBuilder> getPartyTradeInformation() {
            return this.partyTradeInformation;
        }

        @Override
        public PartyTradeInformationSimple.PartyTradeInformationSimpleBuilder getOrCreatePartyTradeInformation(int index) {
            if (this.partyTradeInformation == null) {
                this.partyTradeInformation = new ArrayList<PartyTradeInformationSimple.PartyTradeInformationSimpleBuilder>();
            }
            return (PartyTradeInformationSimple.PartyTradeInformationSimpleBuilder)this.getIndex(this.partyTradeInformation, index, () -> {
                PartyTradeInformationSimple.PartyTradeInformationSimpleBuilder newPartyTradeInformation = PartyTradeInformationSimple.builder();
                return newPartyTradeInformation;
            });
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public ValuationReportRetractedBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public ValuationReportRetractedBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public ValuationReportRetractedBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public ValuationReportRetractedBuilder setHeader(NotificationMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public ValuationReportRetractedBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndOptionalSequenceModel")
        @RuneAttribute(value="correlationAndOptionalSequenceModel")
        public ValuationReportRetractedBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel _correlationAndOptionalSequenceModel) {
            this.correlationAndOptionalSequenceModel = _correlationAndOptionalSequenceModel == null ? null : _correlationAndOptionalSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public ValuationReportRetractedBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportIdentification")
        @RuneAttribute(value="reportIdentification")
        public ValuationReportRetractedBuilder setReportIdentification(ReportIdentification _reportIdentification) {
            this.reportIdentification = _reportIdentification == null ? null : _reportIdentification.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportContents")
        @RuneAttribute(value="reportContents")
        public ValuationReportRetractedBuilder setReportContents(ReportContents _reportContents) {
            this.reportContents = _reportContents == null ? null : _reportContents.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="asOfDate")
        @RuneAttribute(value="asOfDate")
        public ValuationReportRetractedBuilder setAsOfDate(IdentifiedDate _asOfDate) {
            this.asOfDate = _asOfDate == null ? null : _asOfDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partyTradeIdentifier")
        @RuneAttribute(value="partyTradeIdentifier")
        public ValuationReportRetractedBuilder addPartyTradeIdentifier(PartyTradeIdentifier _partyTradeIdentifier) {
            if (_partyTradeIdentifier != null) {
                this.partyTradeIdentifier.add(_partyTradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public ValuationReportRetractedBuilder addPartyTradeIdentifier(PartyTradeIdentifier _partyTradeIdentifier, int idx) {
            this.getIndex(this.partyTradeIdentifier, idx, () -> _partyTradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public ValuationReportRetractedBuilder addPartyTradeIdentifier(List<? extends PartyTradeIdentifier> partyTradeIdentifiers) {
            if (partyTradeIdentifiers != null) {
                for (PartyTradeIdentifier partyTradeIdentifier : partyTradeIdentifiers) {
                    this.partyTradeIdentifier.add(partyTradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyTradeIdentifier")
        public ValuationReportRetractedBuilder setPartyTradeIdentifier(List<? extends PartyTradeIdentifier> partyTradeIdentifiers) {
            this.partyTradeIdentifier = partyTradeIdentifiers == null ? new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>() : (List)partyTradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partyTradeInformation")
        @RuneAttribute(value="partyTradeInformation")
        public ValuationReportRetractedBuilder addPartyTradeInformation(PartyTradeInformationSimple _partyTradeInformation) {
            if (_partyTradeInformation != null) {
                this.partyTradeInformation.add(_partyTradeInformation.toBuilder());
            }
            return this;
        }

        @Override
        public ValuationReportRetractedBuilder addPartyTradeInformation(PartyTradeInformationSimple _partyTradeInformation, int idx) {
            this.getIndex(this.partyTradeInformation, idx, () -> _partyTradeInformation.toBuilder());
            return this;
        }

        @Override
        public ValuationReportRetractedBuilder addPartyTradeInformation(List<? extends PartyTradeInformationSimple> partyTradeInformations) {
            if (partyTradeInformations != null) {
                for (PartyTradeInformationSimple partyTradeInformationSimple : partyTradeInformations) {
                    this.partyTradeInformation.add(partyTradeInformationSimple.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyTradeInformation")
        public ValuationReportRetractedBuilder setPartyTradeInformation(List<? extends PartyTradeInformationSimple> partyTradeInformations) {
            this.partyTradeInformation = partyTradeInformations == null ? new ArrayList<PartyTradeInformationSimple.PartyTradeInformationSimpleBuilder>() : (List)partyTradeInformations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public ValuationReportRetractedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public ValuationReportRetracted build() {
            return new ValuationReportRetractedImpl(this);
        }

        @Override
        public ValuationReportRetractedBuilder toBuilder() {
            return this;
        }

        @Override
        public ValuationReportRetractedBuilder prune() {
            super.prune();
            if (this.reportIdentification != null && !this.reportIdentification.prune().hasData()) {
                this.reportIdentification = null;
            }
            if (this.reportContents != null && !this.reportContents.prune().hasData()) {
                this.reportContents = null;
            }
            if (this.asOfDate != null && !this.asOfDate.prune().hasData()) {
                this.asOfDate = null;
            }
            this.partyTradeIdentifier = this.partyTradeIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.partyTradeInformation = this.partyTradeInformation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getReportIdentification() != null && this.getReportIdentification().hasData()) {
                return true;
            }
            if (this.getReportContents() != null && this.getReportContents().hasData()) {
                return true;
            }
            if (this.getAsOfDate() != null && this.getAsOfDate().hasData()) {
                return true;
            }
            if (this.getPartyTradeIdentifier() != null && this.getPartyTradeIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPartyTradeInformation() != null && this.getPartyTradeInformation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public ValuationReportRetractedBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ValuationReportRetractedBuilder o = (ValuationReportRetractedBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportIdentification(), (RosettaModelObjectBuilder)o.getReportIdentification(), this::setReportIdentification);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportContents(), (RosettaModelObjectBuilder)o.getReportContents(), this::setReportContents);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAsOfDate(), (RosettaModelObjectBuilder)o.getAsOfDate(), this::setAsOfDate);
            merger.mergeRosetta(this.getPartyTradeIdentifier(), o.getPartyTradeIdentifier(), this::getOrCreatePartyTradeIdentifier);
            merger.mergeRosetta(this.getPartyTradeInformation(), o.getPartyTradeInformation(), this::getOrCreatePartyTradeInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ValuationReportRetracted _that = (ValuationReportRetracted)this.getType().cast(o);
            if (!Objects.equals(this.reportIdentification, _that.getReportIdentification())) {
                return false;
            }
            if (!Objects.equals(this.reportContents, _that.getReportContents())) {
                return false;
            }
            if (!Objects.equals(this.asOfDate, _that.getAsOfDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyTradeIdentifier, _that.getPartyTradeIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyTradeInformation, _that.getPartyTradeInformation())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.reportIdentification != null ? this.reportIdentification.hashCode() : 0);
            _result = 31 * _result + (this.reportContents != null ? this.reportContents.hashCode() : 0);
            _result = 31 * _result + (this.asOfDate != null ? this.asOfDate.hashCode() : 0);
            _result = 31 * _result + (this.partyTradeIdentifier != null ? this.partyTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.partyTradeInformation != null ? this.partyTradeInformation.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ValuationReportRetractedBuilder {reportIdentification=" + String.valueOf(this.reportIdentification) + ", reportContents=" + String.valueOf(this.reportContents) + ", asOfDate=" + String.valueOf(this.asOfDate) + ", partyTradeIdentifier=" + String.valueOf(this.partyTradeIdentifier) + ", partyTradeInformation=" + String.valueOf(this.partyTradeInformation) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + "} " + super.toString();
        }
    }

    public static interface ValuationReportRetractedBuilder
    extends ValuationReportRetracted,
    NotificationMessage.NotificationMessageBuilder {
        public ReportIdentification.ReportIdentificationBuilder getOrCreateReportIdentification();

        @Override
        public ReportIdentification.ReportIdentificationBuilder getReportIdentification();

        public ReportContents.ReportContentsBuilder getOrCreateReportContents();

        @Override
        public ReportContents.ReportContentsBuilder getReportContents();

        public IdentifiedDate.IdentifiedDateBuilder getOrCreateAsOfDate();

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getAsOfDate();

        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreatePartyTradeIdentifier(int var1);

        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getPartyTradeIdentifier();

        public PartyTradeInformationSimple.PartyTradeInformationSimpleBuilder getOrCreatePartyTradeInformation(int var1);

        public List<? extends PartyTradeInformationSimple.PartyTradeInformationSimpleBuilder> getPartyTradeInformation();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public ValuationReportRetractedBuilder setFpmlVersion(String var1);

        @Override
        public ValuationReportRetractedBuilder setExpectedBuild(Integer var1);

        @Override
        public ValuationReportRetractedBuilder setActualBuild(Integer var1);

        @Override
        public ValuationReportRetractedBuilder setHeader(NotificationMessageHeader var1);

        @Override
        public ValuationReportRetractedBuilder setValidationModel(ValidationModel var1);

        @Override
        public ValuationReportRetractedBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel var1);

        @Override
        public ValuationReportRetractedBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public ValuationReportRetractedBuilder setReportIdentification(ReportIdentification var1);

        public ValuationReportRetractedBuilder setReportContents(ReportContents var1);

        public ValuationReportRetractedBuilder setAsOfDate(IdentifiedDate var1);

        public ValuationReportRetractedBuilder addPartyTradeIdentifier(PartyTradeIdentifier var1);

        public ValuationReportRetractedBuilder addPartyTradeIdentifier(PartyTradeIdentifier var1, int var2);

        public ValuationReportRetractedBuilder addPartyTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public ValuationReportRetractedBuilder setPartyTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public ValuationReportRetractedBuilder addPartyTradeInformation(PartyTradeInformationSimple var1);

        public ValuationReportRetractedBuilder addPartyTradeInformation(PartyTradeInformationSimple var1, int var2);

        public ValuationReportRetractedBuilder addPartyTradeInformation(List<? extends PartyTradeInformationSimple> var1);

        public ValuationReportRetractedBuilder setPartyTradeInformation(List<? extends PartyTradeInformationSimple> var1);

        public ValuationReportRetractedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, NotificationMessageHeader.NotificationMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.CorrelationAndOptionalSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportIdentification"), processor, ReportIdentification.ReportIdentificationBuilder.class, this.getReportIdentification(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportContents"), processor, ReportContents.ReportContentsBuilder.class, this.getReportContents(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("asOfDate"), processor, IdentifiedDate.IdentifiedDateBuilder.class, this.getAsOfDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyTradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getPartyTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyTradeInformation"), processor, PartyTradeInformationSimple.PartyTradeInformationSimpleBuilder.class, this.getPartyTradeInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public ValuationReportRetractedBuilder prune();
    }

    public static class ValuationReportRetractedImpl
    extends NotificationMessage.NotificationMessageImpl
    implements ValuationReportRetracted {
        private final ReportIdentification reportIdentification;
        private final ReportContents reportContents;
        private final IdentifiedDate asOfDate;
        private final List<? extends PartyTradeIdentifier> partyTradeIdentifier;
        private final List<? extends PartyTradeInformationSimple> partyTradeInformation;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected ValuationReportRetractedImpl(ValuationReportRetractedBuilder builder) {
            super(builder);
            this.reportIdentification = Optional.ofNullable(builder.getReportIdentification()).map(f -> f.build()).orElse(null);
            this.reportContents = Optional.ofNullable(builder.getReportContents()).map(f -> f.build()).orElse(null);
            this.asOfDate = Optional.ofNullable(builder.getAsOfDate()).map(f -> f.build()).orElse(null);
            this.partyTradeIdentifier = Optional.ofNullable(builder.getPartyTradeIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partyTradeInformation = Optional.ofNullable(builder.getPartyTradeInformation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="reportIdentification")
        @RuneAttribute(value="reportIdentification")
        public ReportIdentification getReportIdentification() {
            return this.reportIdentification;
        }

        @Override
        @RosettaAttribute(value="reportContents")
        @RuneAttribute(value="reportContents")
        public ReportContents getReportContents() {
            return this.reportContents;
        }

        @Override
        @RosettaAttribute(value="asOfDate")
        @RuneAttribute(value="asOfDate")
        public IdentifiedDate getAsOfDate() {
            return this.asOfDate;
        }

        @Override
        @RosettaAttribute(value="partyTradeIdentifier")
        @RuneAttribute(value="partyTradeIdentifier")
        public List<? extends PartyTradeIdentifier> getPartyTradeIdentifier() {
            return this.partyTradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="partyTradeInformation")
        @RuneAttribute(value="partyTradeInformation")
        public List<? extends PartyTradeInformationSimple> getPartyTradeInformation() {
            return this.partyTradeInformation;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public ValuationReportRetracted build() {
            return this;
        }

        @Override
        public ValuationReportRetractedBuilder toBuilder() {
            ValuationReportRetractedBuilder builder = ValuationReportRetracted.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ValuationReportRetractedBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getReportIdentification()).ifPresent(builder::setReportIdentification);
            Optional.ofNullable(this.getReportContents()).ifPresent(builder::setReportContents);
            Optional.ofNullable(this.getAsOfDate()).ifPresent(builder::setAsOfDate);
            Optional.ofNullable(this.getPartyTradeIdentifier()).ifPresent(builder::setPartyTradeIdentifier);
            Optional.ofNullable(this.getPartyTradeInformation()).ifPresent(builder::setPartyTradeInformation);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ValuationReportRetracted _that = (ValuationReportRetracted)this.getType().cast(o);
            if (!Objects.equals(this.reportIdentification, _that.getReportIdentification())) {
                return false;
            }
            if (!Objects.equals(this.reportContents, _that.getReportContents())) {
                return false;
            }
            if (!Objects.equals(this.asOfDate, _that.getAsOfDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyTradeIdentifier, _that.getPartyTradeIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyTradeInformation, _that.getPartyTradeInformation())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.reportIdentification != null ? this.reportIdentification.hashCode() : 0);
            _result = 31 * _result + (this.reportContents != null ? this.reportContents.hashCode() : 0);
            _result = 31 * _result + (this.asOfDate != null ? this.asOfDate.hashCode() : 0);
            _result = 31 * _result + (this.partyTradeIdentifier != null ? this.partyTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.partyTradeInformation != null ? this.partyTradeInformation.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ValuationReportRetracted {reportIdentification=" + String.valueOf(this.reportIdentification) + ", reportContents=" + String.valueOf(this.reportContents) + ", asOfDate=" + String.valueOf(this.asOfDate) + ", partyTradeIdentifier=" + String.valueOf(this.partyTradeIdentifier) + ", partyTradeInformation=" + String.valueOf(this.partyTradeInformation) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + "} " + super.toString();
        }
    }
}

