/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.shared.SettlementInformation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="SettlementInformationChoice")
@ImplementedBy(value=Default.class)
public interface SettlementInformationChoice
extends Validator<SettlementInformation> {
    public static final String NAME = "SettlementInformationChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements SettlementInformationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SettlementInformation settlementInformation) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements SettlementInformationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SettlementInformation settlementInformation) {
            ComparisonResult result = this.executeDataRule(settlementInformation);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)SettlementInformationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SettlementInformation", (RosettaPath)path, (String)SettlementInformationChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)SettlementInformationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SettlementInformation", (RosettaPath)path, (String)SettlementInformationChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(SettlementInformation settlementInformation) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)settlementInformation), Arrays.asList("standardSettlementStyle", "settlementInstruction"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

