/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.shared.Documentation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="DocumentationChoice")
@ImplementedBy(value=Default.class)
public interface DocumentationChoice
extends Validator<Documentation> {
    public static final String NAME = "DocumentationChoice";
    public static final String DEFINITION = "optional choice masterConfirmation, brokerConfirmation";

    public static class NoOp
    implements DocumentationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Documentation documentation) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements DocumentationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Documentation documentation) {
            ComparisonResult result = this.executeDataRule(documentation);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)DocumentationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Documentation", (RosettaPath)path, (String)DocumentationChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)DocumentationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Documentation", (RosettaPath)path, (String)DocumentationChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Documentation documentation) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)documentation), Arrays.asList("masterConfirmation", "brokerConfirmation"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

