/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.DirectionalLeg;
import fpml.consolidated.shared.LegIdentifier;
import fpml.consolidated.shared.PayerReceiverModel;
import fpml.consolidated.shared.SpreadSchedule;
import fpml.consolidated.shared.meta.UnderlyerInterestLegMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="UnderlyerInterestLeg", builder=UnderlyerInterestLegBuilderImpl.class, version="1.2.2")
@RuneDataType(value="UnderlyerInterestLeg", model="fpml", builder=UnderlyerInterestLegBuilderImpl.class, version="1.2.2")
public interface UnderlyerInterestLeg
extends DirectionalLeg {
    public static final UnderlyerInterestLegMeta metaData = new UnderlyerInterestLegMeta();

    public BigDecimal getFixedRate();

    public List<? extends SpreadSchedule> getSpreadSchedule();

    @Override
    public UnderlyerInterestLeg build();

    @Override
    public UnderlyerInterestLegBuilder toBuilder();

    public static UnderlyerInterestLegBuilder builder() {
        return new UnderlyerInterestLegBuilderImpl();
    }

    default public RosettaMetaData<? extends UnderlyerInterestLeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends UnderlyerInterestLeg> getType() {
        return UnderlyerInterestLeg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legIdentifier"), processor, LegIdentifier.class, this.getLegIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.class, this.getEffectiveDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.class, this.getTerminationDate(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spreadSchedule"), processor, SpreadSchedule.class, this.getSpreadSchedule(), new AttributeMeta[0]);
    }

    public static class UnderlyerInterestLegBuilderImpl
    extends DirectionalLeg.DirectionalLegBuilderImpl
    implements UnderlyerInterestLegBuilder {
        protected BigDecimal fixedRate;
        protected List<SpreadSchedule.SpreadScheduleBuilder> spreadSchedule = new ArrayList<SpreadSchedule.SpreadScheduleBuilder>();

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public BigDecimal getFixedRate() {
            return this.fixedRate;
        }

        @Override
        @RosettaAttribute(value="spreadSchedule")
        @RuneAttribute(value="spreadSchedule")
        public List<? extends SpreadSchedule.SpreadScheduleBuilder> getSpreadSchedule() {
            return this.spreadSchedule;
        }

        @Override
        public SpreadSchedule.SpreadScheduleBuilder getOrCreateSpreadSchedule(int index) {
            if (this.spreadSchedule == null) {
                this.spreadSchedule = new ArrayList<SpreadSchedule.SpreadScheduleBuilder>();
            }
            return (SpreadSchedule.SpreadScheduleBuilder)this.getIndex(this.spreadSchedule, index, () -> {
                SpreadSchedule.SpreadScheduleBuilder newSpreadSchedule = SpreadSchedule.builder();
                return newSpreadSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public UnderlyerInterestLegBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="legIdentifier")
        @RuneAttribute(value="legIdentifier")
        public UnderlyerInterestLegBuilder addLegIdentifier(LegIdentifier _legIdentifier) {
            if (_legIdentifier != null) {
                this.legIdentifier.add(_legIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public UnderlyerInterestLegBuilder addLegIdentifier(LegIdentifier _legIdentifier, int idx) {
            this.getIndex(this.legIdentifier, idx, () -> _legIdentifier.toBuilder());
            return this;
        }

        @Override
        public UnderlyerInterestLegBuilder addLegIdentifier(List<? extends LegIdentifier> legIdentifiers) {
            if (legIdentifiers != null) {
                for (LegIdentifier legIdentifier : legIdentifiers) {
                    this.legIdentifier.add(legIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="legIdentifier")
        public UnderlyerInterestLegBuilder setLegIdentifier(List<? extends LegIdentifier> legIdentifiers) {
            this.legIdentifier = legIdentifiers == null ? new ArrayList() : (List)legIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public UnderlyerInterestLegBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public UnderlyerInterestLegBuilder setEffectiveDate(AdjustableOrRelativeDate _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="terminationDate")
        @RuneAttribute(value="terminationDate")
        public UnderlyerInterestLegBuilder setTerminationDate(AdjustableOrRelativeDate _terminationDate) {
            this.terminationDate = _terminationDate == null ? null : _terminationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public UnderlyerInterestLegBuilder setFixedRate(BigDecimal _fixedRate) {
            this.fixedRate = _fixedRate == null ? null : _fixedRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadSchedule")
        @RuneAttribute(value="spreadSchedule")
        public UnderlyerInterestLegBuilder addSpreadSchedule(SpreadSchedule _spreadSchedule) {
            if (_spreadSchedule != null) {
                this.spreadSchedule.add(_spreadSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public UnderlyerInterestLegBuilder addSpreadSchedule(SpreadSchedule _spreadSchedule, int idx) {
            this.getIndex(this.spreadSchedule, idx, () -> _spreadSchedule.toBuilder());
            return this;
        }

        @Override
        public UnderlyerInterestLegBuilder addSpreadSchedule(List<? extends SpreadSchedule> spreadSchedules) {
            if (spreadSchedules != null) {
                for (SpreadSchedule spreadSchedule : spreadSchedules) {
                    this.spreadSchedule.add(spreadSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="spreadSchedule")
        public UnderlyerInterestLegBuilder setSpreadSchedule(List<? extends SpreadSchedule> spreadSchedules) {
            this.spreadSchedule = spreadSchedules == null ? new ArrayList<SpreadSchedule.SpreadScheduleBuilder>() : (List)spreadSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public UnderlyerInterestLeg build() {
            return new UnderlyerInterestLegImpl(this);
        }

        @Override
        public UnderlyerInterestLegBuilder toBuilder() {
            return this;
        }

        @Override
        public UnderlyerInterestLegBuilder prune() {
            super.prune();
            this.spreadSchedule = this.spreadSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getFixedRate() != null) {
                return true;
            }
            return this.getSpreadSchedule() != null && this.getSpreadSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public UnderlyerInterestLegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            UnderlyerInterestLegBuilder o = (UnderlyerInterestLegBuilder)other;
            merger.mergeRosetta(this.getSpreadSchedule(), o.getSpreadSchedule(), this::getOrCreateSpreadSchedule);
            merger.mergeBasic((Object)this.getFixedRate(), (Object)o.getFixedRate(), this::setFixedRate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UnderlyerInterestLeg _that = (UnderlyerInterestLeg)this.getType().cast(o);
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            return ListEquals.listEquals(this.spreadSchedule, _that.getSpreadSchedule());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.spreadSchedule != null ? this.spreadSchedule.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "UnderlyerInterestLegBuilder {fixedRate=" + String.valueOf(this.fixedRate) + ", spreadSchedule=" + String.valueOf(this.spreadSchedule) + "} " + super.toString();
        }
    }

    public static interface UnderlyerInterestLegBuilder
    extends UnderlyerInterestLeg,
    DirectionalLeg.DirectionalLegBuilder {
        public SpreadSchedule.SpreadScheduleBuilder getOrCreateSpreadSchedule(int var1);

        public List<? extends SpreadSchedule.SpreadScheduleBuilder> getSpreadSchedule();

        @Override
        public UnderlyerInterestLegBuilder setId(String var1);

        @Override
        public UnderlyerInterestLegBuilder addLegIdentifier(LegIdentifier var1);

        @Override
        public UnderlyerInterestLegBuilder addLegIdentifier(LegIdentifier var1, int var2);

        @Override
        public UnderlyerInterestLegBuilder addLegIdentifier(List<? extends LegIdentifier> var1);

        @Override
        public UnderlyerInterestLegBuilder setLegIdentifier(List<? extends LegIdentifier> var1);

        @Override
        public UnderlyerInterestLegBuilder setPayerReceiverModel(PayerReceiverModel var1);

        @Override
        public UnderlyerInterestLegBuilder setEffectiveDate(AdjustableOrRelativeDate var1);

        @Override
        public UnderlyerInterestLegBuilder setTerminationDate(AdjustableOrRelativeDate var1);

        public UnderlyerInterestLegBuilder setFixedRate(BigDecimal var1);

        public UnderlyerInterestLegBuilder addSpreadSchedule(SpreadSchedule var1);

        public UnderlyerInterestLegBuilder addSpreadSchedule(SpreadSchedule var1, int var2);

        public UnderlyerInterestLegBuilder addSpreadSchedule(List<? extends SpreadSchedule> var1);

        public UnderlyerInterestLegBuilder setSpreadSchedule(List<? extends SpreadSchedule> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legIdentifier"), processor, LegIdentifier.LegIdentifierBuilder.class, this.getLegIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getEffectiveDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getTerminationDate(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spreadSchedule"), processor, SpreadSchedule.SpreadScheduleBuilder.class, this.getSpreadSchedule(), new AttributeMeta[0]);
        }

        @Override
        public UnderlyerInterestLegBuilder prune();
    }

    public static class UnderlyerInterestLegImpl
    extends DirectionalLeg.DirectionalLegImpl
    implements UnderlyerInterestLeg {
        private final BigDecimal fixedRate;
        private final List<? extends SpreadSchedule> spreadSchedule;

        protected UnderlyerInterestLegImpl(UnderlyerInterestLegBuilder builder) {
            super(builder);
            this.fixedRate = builder.getFixedRate();
            this.spreadSchedule = Optional.ofNullable(builder.getSpreadSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public BigDecimal getFixedRate() {
            return this.fixedRate;
        }

        @Override
        @RosettaAttribute(value="spreadSchedule")
        @RuneAttribute(value="spreadSchedule")
        public List<? extends SpreadSchedule> getSpreadSchedule() {
            return this.spreadSchedule;
        }

        @Override
        public UnderlyerInterestLeg build() {
            return this;
        }

        @Override
        public UnderlyerInterestLegBuilder toBuilder() {
            UnderlyerInterestLegBuilder builder = UnderlyerInterestLeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(UnderlyerInterestLegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFixedRate()).ifPresent(builder::setFixedRate);
            Optional.ofNullable(this.getSpreadSchedule()).ifPresent(builder::setSpreadSchedule);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UnderlyerInterestLeg _that = (UnderlyerInterestLeg)this.getType().cast(o);
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            return ListEquals.listEquals(this.spreadSchedule, _that.getSpreadSchedule());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.spreadSchedule != null ? this.spreadSchedule.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "UnderlyerInterestLeg {fixedRate=" + String.valueOf(this.fixedRate) + ", spreadSchedule=" + String.valueOf(this.spreadSchedule) + "} " + super.toString();
        }
    }
}

