/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.PayerReceiverModel;
import fpml.consolidated.shared.PaymentBaseExtended;
import fpml.consolidated.shared.meta.NonNegativePaymentMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="NonNegativePayment", builder=NonNegativePaymentBuilderImpl.class, version="1.2.2")
@RuneDataType(value="NonNegativePayment", model="fpml", builder=NonNegativePaymentBuilderImpl.class, version="1.2.2")
public interface NonNegativePayment
extends PaymentBaseExtended {
    public static final NonNegativePaymentMeta metaData = new NonNegativePaymentMeta();

    public NonNegativeMoney getPaymentAmount();

    @Override
    public NonNegativePayment build();

    @Override
    public NonNegativePaymentBuilder toBuilder();

    public static NonNegativePaymentBuilder builder() {
        return new NonNegativePaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends NonNegativePayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends NonNegativePayment> getType() {
        return NonNegativePayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.class, this.getPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.class, this.getPaymentAmount(), new AttributeMeta[0]);
    }

    public static class NonNegativePaymentBuilderImpl
    extends PaymentBaseExtended.PaymentBaseExtendedBuilderImpl
    implements NonNegativePaymentBuilder {
        protected NonNegativeMoney.NonNegativeMoneyBuilder paymentAmount;

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getPaymentAmount() {
            return this.paymentAmount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreatePaymentAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.paymentAmount != null ? this.paymentAmount : (this.paymentAmount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public NonNegativePaymentBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public NonNegativePaymentBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public NonNegativePaymentBuilder setPaymentDate(AdjustableOrRelativeDate _paymentDate) {
            this.paymentDate = _paymentDate == null ? null : _paymentDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public NonNegativePaymentBuilder setPaymentAmount(NonNegativeMoney _paymentAmount) {
            this.paymentAmount = _paymentAmount == null ? null : _paymentAmount.toBuilder();
            return this;
        }

        @Override
        public NonNegativePayment build() {
            return new NonNegativePaymentImpl(this);
        }

        @Override
        public NonNegativePaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public NonNegativePaymentBuilder prune() {
            super.prune();
            if (this.paymentAmount != null && !this.paymentAmount.prune().hasData()) {
                this.paymentAmount = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getPaymentAmount() != null && this.getPaymentAmount().hasData();
        }

        @Override
        public NonNegativePaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            NonNegativePaymentBuilder o = (NonNegativePaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentAmount(), (RosettaModelObjectBuilder)o.getPaymentAmount(), this::setPaymentAmount);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            NonNegativePayment _that = (NonNegativePayment)this.getType().cast(o);
            return Objects.equals(this.paymentAmount, _that.getPaymentAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentAmount != null ? this.paymentAmount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "NonNegativePaymentBuilder {paymentAmount=" + String.valueOf(this.paymentAmount) + "} " + super.toString();
        }
    }

    public static interface NonNegativePaymentBuilder
    extends NonNegativePayment,
    PaymentBaseExtended.PaymentBaseExtendedBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreatePaymentAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getPaymentAmount();

        @Override
        public NonNegativePaymentBuilder setId(String var1);

        @Override
        public NonNegativePaymentBuilder setPayerReceiverModel(PayerReceiverModel var1);

        @Override
        public NonNegativePaymentBuilder setPaymentDate(AdjustableOrRelativeDate var1);

        public NonNegativePaymentBuilder setPaymentAmount(NonNegativeMoney var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getPaymentAmount(), new AttributeMeta[0]);
        }

        @Override
        public NonNegativePaymentBuilder prune();
    }

    public static class NonNegativePaymentImpl
    extends PaymentBaseExtended.PaymentBaseExtendedImpl
    implements NonNegativePayment {
        private final NonNegativeMoney paymentAmount;

        protected NonNegativePaymentImpl(NonNegativePaymentBuilder builder) {
            super(builder);
            this.paymentAmount = Optional.ofNullable(builder.getPaymentAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public NonNegativeMoney getPaymentAmount() {
            return this.paymentAmount;
        }

        @Override
        public NonNegativePayment build() {
            return this;
        }

        @Override
        public NonNegativePaymentBuilder toBuilder() {
            NonNegativePaymentBuilder builder = NonNegativePayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(NonNegativePaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPaymentAmount()).ifPresent(builder::setPaymentAmount);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            NonNegativePayment _that = (NonNegativePayment)this.getType().cast(o);
            return Objects.equals(this.paymentAmount, _that.getPaymentAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentAmount != null ? this.paymentAmount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "NonNegativePayment {paymentAmount=" + String.valueOf(this.paymentAmount) + "} " + super.toString();
        }
    }
}

