/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.AdjustableDate;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.FxFixing;
import fpml.consolidated.shared.FxRateSourceFixing;
import fpml.consolidated.shared.PositiveMoney;
import fpml.consolidated.shared.meta.FxCashSettlementMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxCashSettlement", builder=FxCashSettlementBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FxCashSettlement", model="fpml", builder=FxCashSettlementBuilderImpl.class, version="1.2.2")
public interface FxCashSettlement
extends RosettaModelObject {
    public static final FxCashSettlementMeta metaData = new FxCashSettlementMeta();

    public Currency getSettlementCurrency();

    public Currency getReferenceCurrency();

    public PositiveMoney getNotionalAmount();

    public List<? extends FxFixing> getFixing();

    public List<? extends FxRateSourceFixing> getRateSourceFixing();

    public AdjustableDate getSettlementDate();

    public FxCashSettlement build();

    public FxCashSettlementBuilder toBuilder();

    public static FxCashSettlementBuilder builder() {
        return new FxCashSettlementBuilderImpl();
    }

    default public RosettaMetaData<? extends FxCashSettlement> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxCashSettlement> getType() {
        return FxCashSettlement.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("settlementCurrency"), processor, Currency.class, this.getSettlementCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("referenceCurrency"), processor, Currency.class, this.getReferenceCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmount"), processor, PositiveMoney.class, this.getNotionalAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixing"), processor, FxFixing.class, this.getFixing(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rateSourceFixing"), processor, FxRateSourceFixing.class, this.getRateSourceFixing(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableDate.class, this.getSettlementDate(), new AttributeMeta[0]);
    }

    public static class FxCashSettlementBuilderImpl
    implements FxCashSettlementBuilder {
        protected Currency.CurrencyBuilder settlementCurrency;
        protected Currency.CurrencyBuilder referenceCurrency;
        protected PositiveMoney.PositiveMoneyBuilder notionalAmount;
        protected List<FxFixing.FxFixingBuilder> fixing = new ArrayList<FxFixing.FxFixingBuilder>();
        protected List<FxRateSourceFixing.FxRateSourceFixingBuilder> rateSourceFixing = new ArrayList<FxRateSourceFixing.FxRateSourceFixingBuilder>();
        protected AdjustableDate.AdjustableDateBuilder settlementDate;

        @Override
        @RosettaAttribute(value="settlementCurrency", isRequired=true)
        @RuneAttribute(value="settlementCurrency", isRequired=true)
        public Currency.CurrencyBuilder getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateSettlementCurrency() {
            Currency.CurrencyBuilder result = this.settlementCurrency != null ? this.settlementCurrency : (this.settlementCurrency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="referenceCurrency")
        @RuneAttribute(value="referenceCurrency")
        public Currency.CurrencyBuilder getReferenceCurrency() {
            return this.referenceCurrency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateReferenceCurrency() {
            Currency.CurrencyBuilder result = this.referenceCurrency != null ? this.referenceCurrency : (this.referenceCurrency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public PositiveMoney.PositiveMoneyBuilder getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        public PositiveMoney.PositiveMoneyBuilder getOrCreateNotionalAmount() {
            PositiveMoney.PositiveMoneyBuilder result = this.notionalAmount != null ? this.notionalAmount : (this.notionalAmount = PositiveMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixing")
        @RuneAttribute(value="fixing")
        public List<? extends FxFixing.FxFixingBuilder> getFixing() {
            return this.fixing;
        }

        @Override
        public FxFixing.FxFixingBuilder getOrCreateFixing(int index) {
            if (this.fixing == null) {
                this.fixing = new ArrayList<FxFixing.FxFixingBuilder>();
            }
            return (FxFixing.FxFixingBuilder)this.getIndex(this.fixing, index, () -> {
                FxFixing.FxFixingBuilder newFixing = FxFixing.builder();
                return newFixing;
            });
        }

        @Override
        @RosettaAttribute(value="rateSourceFixing")
        @RuneAttribute(value="rateSourceFixing")
        public List<? extends FxRateSourceFixing.FxRateSourceFixingBuilder> getRateSourceFixing() {
            return this.rateSourceFixing;
        }

        @Override
        public FxRateSourceFixing.FxRateSourceFixingBuilder getOrCreateRateSourceFixing(int index) {
            if (this.rateSourceFixing == null) {
                this.rateSourceFixing = new ArrayList<FxRateSourceFixing.FxRateSourceFixingBuilder>();
            }
            return (FxRateSourceFixing.FxRateSourceFixingBuilder)this.getIndex(this.rateSourceFixing, index, () -> {
                FxRateSourceFixing.FxRateSourceFixingBuilder newRateSourceFixing = FxRateSourceFixing.builder();
                return newRateSourceFixing;
            });
        }

        @Override
        @RosettaAttribute(value="settlementDate")
        @RuneAttribute(value="settlementDate")
        public AdjustableDate.AdjustableDateBuilder getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        public AdjustableDate.AdjustableDateBuilder getOrCreateSettlementDate() {
            AdjustableDate.AdjustableDateBuilder result = this.settlementDate != null ? this.settlementDate : (this.settlementDate = AdjustableDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency", isRequired=true)
        @RuneAttribute(value="settlementCurrency", isRequired=true)
        public FxCashSettlementBuilder setSettlementCurrency(Currency _settlementCurrency) {
            this.settlementCurrency = _settlementCurrency == null ? null : _settlementCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="referenceCurrency")
        @RuneAttribute(value="referenceCurrency")
        public FxCashSettlementBuilder setReferenceCurrency(Currency _referenceCurrency) {
            this.referenceCurrency = _referenceCurrency == null ? null : _referenceCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public FxCashSettlementBuilder setNotionalAmount(PositiveMoney _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixing")
        @RuneAttribute(value="fixing")
        public FxCashSettlementBuilder addFixing(FxFixing _fixing) {
            if (_fixing != null) {
                this.fixing.add(_fixing.toBuilder());
            }
            return this;
        }

        @Override
        public FxCashSettlementBuilder addFixing(FxFixing _fixing, int idx) {
            this.getIndex(this.fixing, idx, () -> _fixing.toBuilder());
            return this;
        }

        @Override
        public FxCashSettlementBuilder addFixing(List<? extends FxFixing> fixings) {
            if (fixings != null) {
                for (FxFixing fxFixing : fixings) {
                    this.fixing.add(fxFixing.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="fixing")
        public FxCashSettlementBuilder setFixing(List<? extends FxFixing> fixings) {
            this.fixing = fixings == null ? new ArrayList<FxFixing.FxFixingBuilder>() : (List)fixings.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="rateSourceFixing")
        @RuneAttribute(value="rateSourceFixing")
        public FxCashSettlementBuilder addRateSourceFixing(FxRateSourceFixing _rateSourceFixing) {
            if (_rateSourceFixing != null) {
                this.rateSourceFixing.add(_rateSourceFixing.toBuilder());
            }
            return this;
        }

        @Override
        public FxCashSettlementBuilder addRateSourceFixing(FxRateSourceFixing _rateSourceFixing, int idx) {
            this.getIndex(this.rateSourceFixing, idx, () -> _rateSourceFixing.toBuilder());
            return this;
        }

        @Override
        public FxCashSettlementBuilder addRateSourceFixing(List<? extends FxRateSourceFixing> rateSourceFixings) {
            if (rateSourceFixings != null) {
                for (FxRateSourceFixing fxRateSourceFixing : rateSourceFixings) {
                    this.rateSourceFixing.add(fxRateSourceFixing.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="rateSourceFixing")
        public FxCashSettlementBuilder setRateSourceFixing(List<? extends FxRateSourceFixing> rateSourceFixings) {
            this.rateSourceFixing = rateSourceFixings == null ? new ArrayList<FxRateSourceFixing.FxRateSourceFixingBuilder>() : (List)rateSourceFixings.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementDate")
        @RuneAttribute(value="settlementDate")
        public FxCashSettlementBuilder setSettlementDate(AdjustableDate _settlementDate) {
            this.settlementDate = _settlementDate == null ? null : _settlementDate.toBuilder();
            return this;
        }

        @Override
        public FxCashSettlement build() {
            return new FxCashSettlementImpl(this);
        }

        @Override
        public FxCashSettlementBuilder toBuilder() {
            return this;
        }

        @Override
        public FxCashSettlementBuilder prune() {
            if (this.settlementCurrency != null && !this.settlementCurrency.prune().hasData()) {
                this.settlementCurrency = null;
            }
            if (this.referenceCurrency != null && !this.referenceCurrency.prune().hasData()) {
                this.referenceCurrency = null;
            }
            if (this.notionalAmount != null && !this.notionalAmount.prune().hasData()) {
                this.notionalAmount = null;
            }
            this.fixing = this.fixing.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.rateSourceFixing = this.rateSourceFixing.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.settlementDate != null && !this.settlementDate.prune().hasData()) {
                this.settlementDate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getSettlementCurrency() != null && this.getSettlementCurrency().hasData()) {
                return true;
            }
            if (this.getReferenceCurrency() != null && this.getReferenceCurrency().hasData()) {
                return true;
            }
            if (this.getNotionalAmount() != null && this.getNotionalAmount().hasData()) {
                return true;
            }
            if (this.getFixing() != null && this.getFixing().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getRateSourceFixing() != null && this.getRateSourceFixing().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getSettlementDate() != null && this.getSettlementDate().hasData();
        }

        public FxCashSettlementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxCashSettlementBuilder o = (FxCashSettlementBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementCurrency(), (RosettaModelObjectBuilder)o.getSettlementCurrency(), this::setSettlementCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReferenceCurrency(), (RosettaModelObjectBuilder)o.getReferenceCurrency(), this::setReferenceCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotionalAmount(), (RosettaModelObjectBuilder)o.getNotionalAmount(), this::setNotionalAmount);
            merger.mergeRosetta(this.getFixing(), o.getFixing(), this::getOrCreateFixing);
            merger.mergeRosetta(this.getRateSourceFixing(), o.getRateSourceFixing(), this::getOrCreateRateSourceFixing);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementDate(), (RosettaModelObjectBuilder)o.getSettlementDate(), this::setSettlementDate);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxCashSettlement _that = this.getType().cast(o);
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!Objects.equals(this.referenceCurrency, _that.getReferenceCurrency())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fixing, _that.getFixing())) {
                return false;
            }
            if (!ListEquals.listEquals(this.rateSourceFixing, _that.getRateSourceFixing())) {
                return false;
            }
            return Objects.equals(this.settlementDate, _that.getSettlementDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.referenceCurrency != null ? this.referenceCurrency.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.fixing != null ? this.fixing.hashCode() : 0);
            _result = 31 * _result + (this.rateSourceFixing != null ? this.rateSourceFixing.hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxCashSettlementBuilder {settlementCurrency=" + String.valueOf(this.settlementCurrency) + ", referenceCurrency=" + String.valueOf(this.referenceCurrency) + ", notionalAmount=" + String.valueOf(this.notionalAmount) + ", fixing=" + String.valueOf(this.fixing) + ", rateSourceFixing=" + String.valueOf(this.rateSourceFixing) + ", settlementDate=" + String.valueOf(this.settlementDate) + "}";
        }
    }

    public static interface FxCashSettlementBuilder
    extends FxCashSettlement,
    RosettaModelObjectBuilder {
        public Currency.CurrencyBuilder getOrCreateSettlementCurrency();

        @Override
        public Currency.CurrencyBuilder getSettlementCurrency();

        public Currency.CurrencyBuilder getOrCreateReferenceCurrency();

        @Override
        public Currency.CurrencyBuilder getReferenceCurrency();

        public PositiveMoney.PositiveMoneyBuilder getOrCreateNotionalAmount();

        @Override
        public PositiveMoney.PositiveMoneyBuilder getNotionalAmount();

        public FxFixing.FxFixingBuilder getOrCreateFixing(int var1);

        public List<? extends FxFixing.FxFixingBuilder> getFixing();

        public FxRateSourceFixing.FxRateSourceFixingBuilder getOrCreateRateSourceFixing(int var1);

        public List<? extends FxRateSourceFixing.FxRateSourceFixingBuilder> getRateSourceFixing();

        public AdjustableDate.AdjustableDateBuilder getOrCreateSettlementDate();

        @Override
        public AdjustableDate.AdjustableDateBuilder getSettlementDate();

        public FxCashSettlementBuilder setSettlementCurrency(Currency var1);

        public FxCashSettlementBuilder setReferenceCurrency(Currency var1);

        public FxCashSettlementBuilder setNotionalAmount(PositiveMoney var1);

        public FxCashSettlementBuilder addFixing(FxFixing var1);

        public FxCashSettlementBuilder addFixing(FxFixing var1, int var2);

        public FxCashSettlementBuilder addFixing(List<? extends FxFixing> var1);

        public FxCashSettlementBuilder setFixing(List<? extends FxFixing> var1);

        public FxCashSettlementBuilder addRateSourceFixing(FxRateSourceFixing var1);

        public FxCashSettlementBuilder addRateSourceFixing(FxRateSourceFixing var1, int var2);

        public FxCashSettlementBuilder addRateSourceFixing(List<? extends FxRateSourceFixing> var1);

        public FxCashSettlementBuilder setRateSourceFixing(List<? extends FxRateSourceFixing> var1);

        public FxCashSettlementBuilder setSettlementDate(AdjustableDate var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("settlementCurrency"), processor, Currency.CurrencyBuilder.class, this.getSettlementCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("referenceCurrency"), processor, Currency.CurrencyBuilder.class, this.getReferenceCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmount"), processor, PositiveMoney.PositiveMoneyBuilder.class, this.getNotionalAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixing"), processor, FxFixing.FxFixingBuilder.class, this.getFixing(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rateSourceFixing"), processor, FxRateSourceFixing.FxRateSourceFixingBuilder.class, this.getRateSourceFixing(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableDate.AdjustableDateBuilder.class, this.getSettlementDate(), new AttributeMeta[0]);
        }

        public FxCashSettlementBuilder prune();
    }

    public static class FxCashSettlementImpl
    implements FxCashSettlement {
        private final Currency settlementCurrency;
        private final Currency referenceCurrency;
        private final PositiveMoney notionalAmount;
        private final List<? extends FxFixing> fixing;
        private final List<? extends FxRateSourceFixing> rateSourceFixing;
        private final AdjustableDate settlementDate;

        protected FxCashSettlementImpl(FxCashSettlementBuilder builder) {
            this.settlementCurrency = Optional.ofNullable(builder.getSettlementCurrency()).map(f -> f.build()).orElse(null);
            this.referenceCurrency = Optional.ofNullable(builder.getReferenceCurrency()).map(f -> f.build()).orElse(null);
            this.notionalAmount = Optional.ofNullable(builder.getNotionalAmount()).map(f -> f.build()).orElse(null);
            this.fixing = Optional.ofNullable(builder.getFixing()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.rateSourceFixing = Optional.ofNullable(builder.getRateSourceFixing()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.settlementDate = Optional.ofNullable(builder.getSettlementDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="settlementCurrency", isRequired=true)
        @RuneAttribute(value="settlementCurrency", isRequired=true)
        public Currency getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        @RosettaAttribute(value="referenceCurrency")
        @RuneAttribute(value="referenceCurrency")
        public Currency getReferenceCurrency() {
            return this.referenceCurrency;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public PositiveMoney getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        @RosettaAttribute(value="fixing")
        @RuneAttribute(value="fixing")
        public List<? extends FxFixing> getFixing() {
            return this.fixing;
        }

        @Override
        @RosettaAttribute(value="rateSourceFixing")
        @RuneAttribute(value="rateSourceFixing")
        public List<? extends FxRateSourceFixing> getRateSourceFixing() {
            return this.rateSourceFixing;
        }

        @Override
        @RosettaAttribute(value="settlementDate")
        @RuneAttribute(value="settlementDate")
        public AdjustableDate getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        public FxCashSettlement build() {
            return this;
        }

        @Override
        public FxCashSettlementBuilder toBuilder() {
            FxCashSettlementBuilder builder = FxCashSettlement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxCashSettlementBuilder builder) {
            Optional.ofNullable(this.getSettlementCurrency()).ifPresent(builder::setSettlementCurrency);
            Optional.ofNullable(this.getReferenceCurrency()).ifPresent(builder::setReferenceCurrency);
            Optional.ofNullable(this.getNotionalAmount()).ifPresent(builder::setNotionalAmount);
            Optional.ofNullable(this.getFixing()).ifPresent(builder::setFixing);
            Optional.ofNullable(this.getRateSourceFixing()).ifPresent(builder::setRateSourceFixing);
            Optional.ofNullable(this.getSettlementDate()).ifPresent(builder::setSettlementDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxCashSettlement _that = this.getType().cast(o);
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!Objects.equals(this.referenceCurrency, _that.getReferenceCurrency())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fixing, _that.getFixing())) {
                return false;
            }
            if (!ListEquals.listEquals(this.rateSourceFixing, _that.getRateSourceFixing())) {
                return false;
            }
            return Objects.equals(this.settlementDate, _that.getSettlementDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.referenceCurrency != null ? this.referenceCurrency.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.fixing != null ? this.fixing.hashCode() : 0);
            _result = 31 * _result + (this.rateSourceFixing != null ? this.rateSourceFixing.hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxCashSettlement {settlementCurrency=" + String.valueOf(this.settlementCurrency) + ", referenceCurrency=" + String.valueOf(this.referenceCurrency) + ", notionalAmount=" + String.valueOf(this.notionalAmount) + ", fixing=" + String.valueOf(this.fixing) + ", rateSourceFixing=" + String.valueOf(this.rateSourceFixing) + ", settlementDate=" + String.valueOf(this.settlementDate) + "}";
        }
    }
}

